/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.explainer;

import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class DistanceCalculationHelper {
    private BooleanFormulaManagerView bfmgr;

    public DistanceCalculationHelper(BooleanFormulaManagerView pBooleanFormulaManagerView) {
        this.bfmgr = pBooleanFormulaManagerView;
    }

    public DistanceCalculationHelper() {
    }

    public List<CFAEdge> cleanPath(ARGPath path) {
        List<CFAEdge> flow = path.getFullPath();
        return this.cleanPath(flow);
    }

    public List<CFAEdge> cleanPath(List<CFAEdge> path) {
        List code;
        CFAEdge f;
        if (path == null) {
            return null;
        }
        ArrayList<CFAEdge> filteredEdges = new ArrayList<CFAEdge>();
        Iterator<CFAEdge> iterator = path.iterator();
        while (!(!iterator.hasNext() || (f = iterator.next()).getEdgeType().equals((Object)CFAEdgeType.FunctionCallEdge) && ((String)(code = Splitter.onPattern((String)"\\s*[()]\\s*").splitToList((CharSequence)f.getCode())).get(0)).equals("__VERIFIER_assert"))) {
            filteredEdges.add(f);
        }
        return filteredEdges;
    }

    public List<List<CFAEdge>> convertPathsToEdges(List<ARGPath> paths) {
        ArrayList<List<CFAEdge>> result = new ArrayList<List<CFAEdge>>();
        for (ARGPath pPath : paths) {
            result.add(pPath.getFullPath());
        }
        return result;
    }

    public boolean isConj(BooleanFormula f) {
        Set<BooleanFormula> after = this.bfmgr.toConjunctionArgs(f, true);
        return after.size() >= 2;
    }

    public boolean isDisj(BooleanFormula f) {
        Set<BooleanFormula> after = this.bfmgr.toDisjunctionArgs(f, true);
        return after.size() >= 2;
    }

    public Set<BooleanFormula> splitPredicates(BooleanFormula form) {
        Iterator iterator;
        HashSet<BooleanFormula> result = new HashSet<BooleanFormula>();
        HashSet<BooleanFormula> modulo = new HashSet<BooleanFormula>();
        modulo.add(form);
        while ((iterator = modulo.iterator()).hasNext()) {
            Set<BooleanFormula> temp;
            BooleanFormula current = (BooleanFormula)iterator.next();
            modulo.remove(current);
            if (this.isConj(current)) {
                temp = this.bfmgr.toConjunctionArgs(current, true);
                for (BooleanFormula f : temp) {
                    if (this.isConj(f) || this.isDisj(f)) {
                        modulo.add(f);
                        continue;
                    }
                    result.add(f);
                }
                continue;
            }
            if (!this.isDisj(current)) continue;
            temp = this.bfmgr.toDisjunctionArgs(current, true);
            for (BooleanFormula f : temp) {
                if (this.isConj(f) || this.isDisj(f)) {
                    modulo.add(f);
                    continue;
                }
                result.add(f);
            }
        }
        return result;
    }

    List<ARGPath> generateAllSuccessfulExecutions(Collection<ARGState> pStatesOnPathTo, ARGState root, boolean filterChildren) {
        if (filterChildren) assert (pStatesOnPathTo != null);
        ArrayList<ARGPath> paths = new ArrayList<ARGPath>();
        ArrayList<List<ARGState>> nodeWaitList = new ArrayList<List<ARGState>>();
        nodeWaitList.add(new ArrayList());
        ((List)nodeWaitList.get(0)).add(root);
        int numberOfCurrentPath = -1;
        for (int i = 0; i < nodeWaitList.size(); ++i) {
            ImmutableList immutableList;
            List list = (List)nodeWaitList.get(++numberOfCurrentPath);
            ImmutableList children = ImmutableList.of();
            int lastNode = ((List)nodeWaitList.get(numberOfCurrentPath)).size() - 1;
            ARGState currentNode = (ARGState)((List)nodeWaitList.get(numberOfCurrentPath)).get(lastNode);
            children = filterChildren ? FluentIterable.from(currentNode.getChildren()).filter(pStatesOnPathTo::contains).toList() : ImmutableList.copyOf(currentNode.getChildren());
            if (children.isEmpty()) continue;
            do {
                if (children.size() > 1) {
                    this.handleChildren(nodeWaitList, numberOfCurrentPath, (ImmutableList<ARGState>)children);
                }
                list.add((ARGState)children.get(0));
                currentNode = (ARGState)children.get(0);
                if (filterChildren) {
                    immutableList = FluentIterable.from(currentNode.getChildren()).filter(pStatesOnPathTo::contains).toList();
                    continue;
                }
                immutableList = ImmutableList.copyOf(currentNode.getChildren());
            } while (!(children = immutableList).isEmpty());
        }
        for (List list : nodeWaitList) {
            ARGPath targetPath = new ARGPath(list);
            paths.add(targetPath);
        }
        return paths;
    }

    private void handleChildren(List<List<ARGState>> nodeWaitList, int numberOfCurrentPath, ImmutableList<ARGState> children) {
        IntStream.range(1, children.size()).forEach(j -> {
            ArrayList<ARGState> anotherPath = new ArrayList<ARGState>((Collection)nodeWaitList.get(numberOfCurrentPath));
            anotherPath.add((ARGState)children.get(j));
            nodeWaitList.add(anotherPath);
        });
        nodeWaitList.get(numberOfCurrentPath).add((ARGState)children.get(0));
    }
}

