/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.explainer;

import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;

public class Event {
    private final int line;
    private final CFAEdge execution;
    private final CFANode node;
    private final List<CFAEdge> path;

    public Event(CFAEdge pExecution, List<CFAEdge> pPath) {
        this.line = pExecution.getLineNumber();
        this.execution = pExecution;
        this.node = pExecution.getPredecessor();
        this.path = pPath;
    }

    public int getDistanceFromTheEnd() {
        for (int i = 0; i < this.path.size(); ++i) {
            if (this.path.get(i) != this.execution) continue;
            return this.path.size() - i;
        }
        return 0;
    }

    int getLine() {
        return this.line;
    }

    String getStatement() {
        return this.execution.getCode();
    }

    CFANode getNode() {
        return this.node;
    }

    public String toString() {
        return "Line " + this.line + ": " + this.execution.getCode();
    }
}

