/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.explainer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.core.algorithm.explainer.Alignment;
import org.sosy_lab.cpachecker.core.algorithm.explainer.DistanceCalculationHelper;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultLocalizationInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultReason;

public class ExplainTool {
    public void explainDeltas(List<CFAEdge> counterexample, List<CFAEdge> closestExecution, CounterexampleInfo ceInfo) {
        closestExecution = new DistanceCalculationHelper().cleanPath(closestExecution);
        ArrayList<CFAEdge> spEdges = new ArrayList<CFAEdge>(closestExecution);
        List<CFAEdge> deltasCe = new ArrayList<CFAEdge>();
        List<CFAEdge> deltasSp = new ArrayList<CFAEdge>();
        for (CFAEdge pEdge : counterexample) {
            if (!spEdges.contains(pEdge)) {
                deltasCe.add(pEdge);
                continue;
            }
            spEdges.remove(pEdge);
        }
        for (CFAEdge pEdge : closestExecution) {
            if (!counterexample.contains(pEdge)) {
                deltasSp.add(pEdge);
                continue;
            }
            counterexample.remove(pEdge);
        }
        deltasCe = this.cleanZeros(deltasCe);
        deltasSp = this.cleanZeros(deltasSp);
        Alignment<CFAEdge> wasChangedTo = new Alignment<CFAEdge>();
        ArrayList<CFAEdge> deleted = new ArrayList<CFAEdge>(deltasCe);
        ArrayList<CFAEdge> executed = new ArrayList<CFAEdge>(deltasSp);
        for (CFAEdge ceEdge : deltasCe) {
            for (CFAEdge spEdge : deltasSp) {
                if (ceEdge.getPredecessor().getNodeNumber() != spEdge.getPredecessor().getNodeNumber()) continue;
                wasChangedTo.addPair(ceEdge, spEdge);
                deleted.remove(ceEdge);
                executed.remove(spEdge);
            }
        }
        this.writeFaults(wasChangedTo, deleted, executed, ceInfo);
    }

    private List<CFAEdge> cleanZeros(List<CFAEdge> path) {
        ArrayList<CFAEdge> result = new ArrayList<CFAEdge>();
        for (CFAEdge e : path) {
            if (e.getEdgeType().equals((Object)CFAEdgeType.BlankEdge)) continue;
            result.add(e);
        }
        return result;
    }

    private void faultInfo(List<Fault> faults, CounterexampleInfo cInfo) {
        FaultLocalizationInfo info = new FaultLocalizationInfo(faults, cInfo);
        info.getHtmlWriter().toHtml(faults.get(0));
        info.apply();
    }

    public void writeFaults(Alignment<CFAEdge> wasChangedTo, List<CFAEdge> deleted, List<CFAEdge> executed, CounterexampleInfo ceInfos) {
        FaultContribution con;
        ArrayList<FaultReason> hints = new ArrayList<FaultReason>();
        HashSet<FaultContribution> contributionSet = new HashSet<FaultContribution>();
        for (int i = 0; i < wasChangedTo.getCounterexample().size(); ++i) {
            FaultContribution faultContribution = new FaultContribution(wasChangedTo.getCounterexampleElement(i));
            contributionSet.add(faultContribution);
            hints.add(FaultInfo.justify("LINE " + wasChangedTo.getCounterexampleElement(i).getLineNumber() + " WAS: " + wasChangedTo.getCounterexampleElement(i).getCode() + ", CHANGED TO: " + wasChangedTo.getSafePathElement(i).getCode()));
        }
        for (CFAEdge cFAEdge : deleted) {
            con = new FaultContribution(cFAEdge);
            contributionSet.add(con);
            hints.add(FaultInfo.justify("LINE " + cFAEdge.getLineNumber() + ", DELETED: " + cFAEdge.getCode()));
        }
        for (CFAEdge cFAEdge : executed) {
            con = new FaultContribution(cFAEdge);
            contributionSet.add(con);
            hints.add(FaultInfo.justify("LINE " + cFAEdge.getLineNumber() + ", WAS EXECUTED: " + cFAEdge.getCode()));
        }
        Fault fault = new Fault(contributionSet);
        for (FaultInfo faultInfo : hints) {
            fault.addInfo(faultInfo);
        }
        ArrayList<Fault> faults = new ArrayList<Fault>();
        faults.add(fault);
        this.faultInfo(faults, ceInfos);
    }
}

