/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.explainer;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.Optionals;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.NestingAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.explainer.AbstractDistanceMetric;
import org.sosy_lab.cpachecker.core.algorithm.explainer.ControlFlowDistanceMetric;
import org.sosy_lab.cpachecker.core.algorithm.explainer.DistanceCalculationHelper;
import org.sosy_lab.cpachecker.core.algorithm.explainer.ExplainTool;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.defaults.MultiStatistics;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;

@Options(prefix="faultLocalization.by_distance")
public class Explainer
extends NestingAlgorithm {
    @Option(secure=true, name="analysis", description="Configuration to use for initial program-state exploration")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path firstStepConfig = null;
    @Option(secure=true, name="metric", description="The distance metric that ought to be used for the computation of the distance")
    private Metric distanceMetric = Metric.ADM;
    @Option(secure=true, name="stopAfter", description="Maximum number of explorations to run for collecting error paths, before performing fault localization.  Exploration runs stop when the program under analysis is fully explored or the specified number of runs is reached. Fault localization may be more precise if more error paths are available.")
    private int stopAfter = 40;
    private PredicateCPA cpa;
    private final ExplainerAlgorithmStatistics stats;
    private final CFA cfa;

    public Explainer(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pShutdownNotifier, pSpecification);
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.stats = new ExplainerAlgorithmStatistics(pLogger);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        ForwardingReachedSet reached = (ForwardingReachedSet)reachedSet;
        Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> secondAlg = null;
        try {
            ShutdownManager shutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
            secondAlg = this.createAlgorithm(this.firstStepConfig, this.cfa, shutdownManager, reached);
            this.cpa = CPAs.retrieveCPAOrFail(secondAlg.getSecond(), PredicateCPA.class, Explainer.class);
        }
        catch (IOException pE) {
            throw new AssertionError((Object)pE);
        }
        catch (InvalidConfigurationException pE) {
            throw new CPAException("First Step Configuration File is invalid", pE);
        }
        ReachedSet currentReached = secondAlg.getThird();
        Algorithm firstStepAlgorithm = secondAlg.getFirst();
        assert (firstStepAlgorithm != null);
        Algorithm.AlgorithmStatus status = firstStepAlgorithm.run(currentReached);
        for (int i = 0; currentReached.hasWaitingState() && i < this.stopAfter; ++i) {
            status = firstStepAlgorithm.run(currentReached);
        }
        reached.setDelegate(currentReached);
        ImmutableList allTargets = FluentIterable.from((Iterable)currentReached).transform(s -> AbstractStates.extractStateByType(s, ARGState.class)).filter(ARGState::isTarget).toList();
        if (allTargets.isEmpty()) {
            return status;
        }
        FluentIterable counterExamples = Optionals.presentInstances((Iterable)FluentIterable.from((Iterable)allTargets).transform(ARGState::getCounterexampleInformation));
        ARGPath targetPath = ((CounterexampleInfo)((Object)counterExamples.get(0))).getTargetPath();
        ImmutableList safeLeafNodes = FluentIterable.from((Iterable)currentReached).transform(x -> AbstractStates.extractStateByType(x, ARGState.class)).filter(x -> x.getChildren().isEmpty()).filter(x -> !x.isTarget()).filter(x -> x.wasExpanded()).toList();
        ARGState rootNode = AbstractStates.extractStateByType(currentReached.getFirstState(), ARGState.class);
        List<CFAEdge> closestSuccessfulExecution = null;
        if (this.distanceMetric.equals((Object)Metric.PG)) {
            this.startPathGeneration(targetPath, (CounterexampleInfo)((Object)counterExamples.get(0)));
            return status;
        }
        List<ARGPath> safePaths = this.findAllSafePaths((List<ARGState>)safeLeafNodes, rootNode);
        switch (this.distanceMetric) {
            case ADM: {
                closestSuccessfulExecution = this.startADM(safePaths, targetPath);
                break;
            }
            case CFDM: {
                closestSuccessfulExecution = this.startCFDM(safePaths, targetPath);
                break;
            }
            default: {
                this.logger.log(Level.WARNING, new Object[]{"NO DISTANCE METRIC WAS GIVEN"});
                return status;
            }
        }
        if (closestSuccessfulExecution == null) {
            this.logger.log(Level.INFO, new Object[]{"NO SUCCESSFUL EXECUTION WAS FOUND"});
            return status;
        }
        new ExplainTool().explainDeltas(new DistanceCalculationHelper().cleanPath(targetPath.getFullPath()), closestSuccessfulExecution, (CounterexampleInfo)((Object)counterExamples.get(0)));
        return status;
    }

    private List<ARGPath> findAllSafePaths(List<ARGState> safeLeafNodes, ARGState rootNode) {
        List<ARGPath> safePaths = new ArrayList<ARGPath>();
        for (ARGState safeLeaf : safeLeafNodes) {
            ImmutableSet<ARGState> statesOnPathTo = ARGUtils.getAllStatesOnPathsTo(safeLeaf);
            safePaths = new DistanceCalculationHelper(null).generateAllSuccessfulExecutions((Collection<ARGState>)statesOnPathTo, rootNode, true);
        }
        return safePaths;
    }

    private List<CFAEdge> startADM(List<ARGPath> safePaths, ARGPath targetPath) {
        BooleanFormulaManagerView bfmgr = this.cpa.getSolver().getFormulaManager().getBooleanFormulaManager();
        AbstractDistanceMetric metric = new AbstractDistanceMetric(new DistanceCalculationHelper(bfmgr));
        return metric.startDistanceMetric(safePaths, targetPath);
    }

    private List<CFAEdge> startCFDM(List<ARGPath> safePaths, ARGPath targetPath) {
        ControlFlowDistanceMetric metric = new ControlFlowDistanceMetric(new DistanceCalculationHelper());
        return metric.startDistanceMetric(safePaths, targetPath);
    }

    private void startPathGeneration(ARGPath targetPath, CounterexampleInfo ceInfo) {
        ControlFlowDistanceMetric pathGeneration = new ControlFlowDistanceMetric(new DistanceCalculationHelper());
        pathGeneration.generateClosestSuccessfulExecution(targetPath, ceInfo);
    }

    private Triple<Algorithm, ConfigurableProgramAnalysis, ReachedSet> createAlgorithm(Path singleConfigFileName, CFA pCfa, ShutdownManager singleShutdownManager, ReachedSet currentReached) throws InvalidConfigurationException, CPAException, IOException, InterruptedException {
        AggregatedReachedSets aggregateReached = currentReached != null ? AggregatedReachedSets.singleton(currentReached) : AggregatedReachedSets.empty();
        return super.createAlgorithm(singleConfigFileName, pCfa.getMainFunction(), pCfa, singleShutdownManager, aggregateReached, (Collection<String>)ImmutableSet.of((Object)"analysis.algorithm.faultLocalization.by_distance"), this.stats.getSubStatistics());
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.stats);
    }

    private static class ExplainerAlgorithmStatistics
    extends MultiStatistics {
        private static final int noOfAlgorithmsUsed = 0;
        private Timer totalTime = new Timer();

        public ExplainerAlgorithmStatistics(LogManager pLogger) {
            super(pLogger);
        }

        @Override
        public void resetSubStatistics() {
            super.resetSubStatistics();
            this.totalTime = new Timer();
        }

        @Override
        public String getName() {
            return "Explainer Algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            out.println("Number of algorithms provided:    ");
            out.println("Number of algorithms used:        0");
            this.printSubStatistics(out, result, reached);
        }

        private void printSubStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            out.println("Total time for algorithm 0: " + this.totalTime);
            super.printStatistics(out, result, reached);
        }
    }

    private static enum Metric {
        ADM,
        CFDM,
        PG;

    }
}

