/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.explainer;

import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import org.sosy_lab.cpachecker.core.algorithm.explainer.PathDistancePair;

class PathDistanceList<T, Y>
extends ForwardingList<PathDistancePair<T, Y>> {
    private final ImmutableList<PathDistancePair<T, Y>> delegate;

    PathDistanceList(List<List<T>> programExecution, List<List<Y>> listOfDistances) {
        assert (programExecution.size() == listOfDistances.size());
        this.delegate = (ImmutableList)Streams.zip(programExecution.stream(), listOfDistances.stream(), PathDistancePair::new).filter(p -> p.getDistances().isEmpty()).collect(ImmutableList.toImmutableList());
    }

    protected List<PathDistancePair<T, Y>> delegate() {
        return this.delegate;
    }
}

