/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.utils.CoverageInformationBuilder;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.utils.FailedAndPassedExecutionCount;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;

public abstract class SuspiciousnessMeasure {
    public List<Fault> getAllFaults(Set<ARGPath> safePaths, Set<ARGPath> errorPaths, CoverageInformationBuilder coverageInfo) throws InterruptedException {
        int totalSafePaths = safePaths.size();
        int totalErrorPaths = errorPaths.size();
        Map<CFAEdge, FailedAndPassedExecutionCount> coverage = coverageInfo.getCoverageInformation();
        ArrayList<Fault> faults = new ArrayList<Fault>();
        for (Map.Entry<CFAEdge, FailedAndPassedExecutionCount> e : coverage.entrySet()) {
            CFAEdge cfaEdge = e.getKey();
            FailedAndPassedExecutionCount executionCount = e.getValue();
            double suspiciousness = this.calculateSuspiciousness(executionCount.getFailedCases(), executionCount.getPassedCases(), totalErrorPaths, totalSafePaths);
            FaultContribution pFaultContribution = new FaultContribution(cfaEdge);
            if (suspiciousness == 0.0) continue;
            pFaultContribution.setScore(suspiciousness);
            faults.add(new Fault(pFaultContribution, suspiciousness));
        }
        return faults;
    }

    public abstract double calculateSuspiciousness(double var1, double var3, double var5, double var7);
}

