/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.utils;

import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.utils.FailedAndPassedExecutionCount;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;

public class CoverageInformationBuilder {
    private final ShutdownNotifier shutdownNotifier;
    private final Set<ARGPath> safePaths;
    private final Set<ARGPath> errorPaths;

    public CoverageInformationBuilder(ShutdownNotifier pShutdownNotifier, Set<ARGPath> pSafePaths, Set<ARGPath> pErrorPaths) {
        this.shutdownNotifier = pShutdownNotifier;
        this.safePaths = pSafePaths;
        this.errorPaths = pErrorPaths;
    }

    private Map<CFAEdge, FailedAndPassedExecutionCount> calculateCoverageInformation(Set<ARGPath> paths) throws InterruptedException {
        LinkedHashMap<CFAEdge, FailedAndPassedExecutionCount> coverageInfo = new LinkedHashMap<CFAEdge, FailedAndPassedExecutionCount>();
        for (ARGPath path : paths) {
            for (CFAEdge cfaEdge : path.getFullPath()) {
                this.shutdownNotifier.shutdownIfNecessary();
                if (!coverageInfo.containsKey(cfaEdge)) {
                    coverageInfo.put(cfaEdge, new FailedAndPassedExecutionCount(0, 0));
                }
                FailedAndPassedExecutionCount caseStatus = (FailedAndPassedExecutionCount)coverageInfo.get(cfaEdge);
                caseStatus = path.getLastState().isTarget() ? new FailedAndPassedExecutionCount(caseStatus.getFailedCases() + 1, caseStatus.getPassedCases()) : new FailedAndPassedExecutionCount(caseStatus.getFailedCases(), caseStatus.getPassedCases() + 1);
                if (cfaEdge.getLineNumber() == 0) continue;
                coverageInfo.put(cfaEdge, caseStatus);
            }
        }
        return coverageInfo;
    }

    public Map<CFAEdge, FailedAndPassedExecutionCount> getCoverageInformation() throws InterruptedException {
        return this.calculateCoverageInformation((Set<ARGPath>)Sets.union(this.safePaths, this.errorPaths));
    }
}

