/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_coverage.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class SafeCase {
    private final ReachedSet reachedSet;

    public SafeCase(ReachedSet pReachedSet) {
        this.reachedSet = pReachedSet;
    }

    private ImmutableList<ARGState> getSafeStates() {
        return this.getRootState().getSubgraph().filter(e -> !e.isCovered() && !e.isTarget() && e.getChildren().isEmpty()).toList();
    }

    public ImmutableSet<ARGPath> getSafePaths() {
        ImmutableSet.Builder allSafePathsTogether = ImmutableSet.builder();
        for (ARGState safeState : this.getSafeStates()) {
            allSafePathsTogether.addAll(ARGUtils.getAllPaths(this.reachedSet, safeState));
        }
        return allSafePathsTogether.build();
    }

    public boolean existsSafePath() {
        return !this.getSafeStates().isEmpty();
    }

    private ARGState getRootState() {
        return AbstractStates.extractStateByType(this.reachedSet.getFirstState(), ARGState.class);
    }
}

