/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultLocalizationInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultRankingUtils;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;

public class FaultLocalizationInfoWithTraceFormula
extends FaultLocalizationInfo {
    private final TraceFormula traceFormula;

    public FaultLocalizationInfoWithTraceFormula(Set<Fault> pFaults, FaultScoring pScoring, TraceFormula pTraceFormula, CounterexampleInfo pParent, boolean pSortIntended) {
        super(FaultLocalizationInfoWithTraceFormula.correctlySortFaults(pFaults, pScoring, pSortIntended), pParent);
        this.traceFormula = pTraceFormula;
    }

    private static List<Fault> correctlySortFaults(Set<Fault> pFaults, FaultScoring pScoring, boolean pSortIntended) {
        if (pSortIntended) {
            return ImmutableList.sortedCopyOf(Comparator.comparingInt(Fault::getIntendedIndex), pFaults);
        }
        return FaultRankingUtils.rank(pScoring, pFaults);
    }

    public TraceFormula getTraceFormula() {
        return this.traceFormula;
    }
}

