/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.error_invariants;

import com.google.common.base.Joiner;
import com.google.common.base.VerifyException;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.collect.MapsDifference;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizerWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.error_invariants.AbstractTraceElement;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.ConjunctionTraceInterpreter;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.Trace;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

public class ErrorInvariantsAlgorithm
implements FaultLocalizerWithTraceFormula,
Statistics {
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final LogManager logger;
    private TraceFormula errorTrace;
    private ImmutableList<SSAMap> maps;
    private final Multimap<BooleanFormula, Integer> memorize;
    private final StatTimer totalTime = new StatTimer(StatKind.SUM, "Total time for ErrInv");
    private final StatCounter searchCalls = new StatCounter("Number of search calls");
    private final StatCounter solverCalls = new StatCounter("Number of solver calls");
    private final StatCounter memoizationCalls = new StatCounter("Number of interpolant-interval cache hits");

    public ErrorInvariantsAlgorithm(ShutdownNotifier pShutdownNotifier, Configuration pConfiguration, LogManager pLogger) {
        this.shutdownNotifier = pShutdownNotifier;
        this.config = pConfiguration;
        this.logger = pLogger;
        this.memorize = ArrayListMultimap.create();
    }

    private List<BooleanFormula> getInterpolants(FormulaContext formulaContext) throws CPAException, InterruptedException, InvalidConfigurationException {
        this.solverCalls.inc();
        InterpolationManager interpolationManager = new InterpolationManager(formulaContext.getManager(), formulaContext.getSolver(), Optional.empty(), Optional.empty(), this.config, this.shutdownNotifier, this.logger);
        ArrayList<BooleanFormula> allFormulas = new ArrayList<BooleanFormula>();
        allFormulas.add(this.errorTrace.getPrecondition().getPrecondition());
        allFormulas.addAll(this.errorTrace.getTrace().toFormulaList());
        allFormulas.add(formulaContext.getSolver().getFormulaManager().getBooleanFormulaManager().not(this.errorTrace.getPostCondition().getPostCondition()));
        List interpolants = (List)interpolationManager.interpolate(allFormulas).orElseThrow();
        return Collections3.transformedImmutableListCopy((Collection)interpolants, element -> formulaContext.getSolver().getFormulaManager().uninstantiate(element));
    }

    @Override
    public Set<Fault> run(FormulaContext context, TraceFormula tf) throws CPAException, InterruptedException, SolverException, VerifyException, InvalidConfigurationException {
        this.errorTrace = tf;
        this.maps = ImmutableList.builder().add((Object)tf.getTrace().getInitialSsaMap()).addAll(tf.getTrace().toSSAMapList()).build();
        this.totalTime.start();
        List<BooleanFormula> interpolants = this.getInterpolants(context);
        ArrayList<Interval> sortedIntervals = new ArrayList<Interval>();
        for (int i = 0; i < interpolants.size(); ++i) {
            BooleanFormula interpolant = interpolants.get(i);
            Interval current = new Interval(this.search(context.getSolver(), 0, i, interpolant, true), this.search(context.getSolver(), i, tf.getTrace().size(), interpolant, false) - 1, interpolant);
            sortedIntervals.add(current);
        }
        sortedIntervals.sort(Comparator.comparingInt(Interval::getStart));
        ImmutableList selectors = ImmutableList.copyOf((Collection)((Object)this.errorTrace.getTrace()));
        Interval maxInterval = (Interval)sortedIntervals.get(0);
        int prevEnd = 0;
        List<AbstractTraceElement> abstractTrace = new ArrayList<AbstractTraceElement>();
        for (Interval currInterval : sortedIntervals) {
            if (currInterval.getStart() > prevEnd) {
                abstractTrace.add(maxInterval);
                if (maxInterval.getEnd() < tf.getTrace().size()) {
                    abstractTrace.add((AbstractTraceElement)selectors.get(maxInterval.getEnd()));
                }
                prevEnd = maxInterval.getEnd();
                maxInterval = currInterval;
                continue;
            }
            if (currInterval.getEnd() <= maxInterval.getEnd()) continue;
            maxInterval = currInterval;
        }
        this.totalTime.stop();
        abstractTrace = this.summarize(abstractTrace, context.getSolver().getFormulaManager().getBooleanFormulaManager());
        return this.createFaults(abstractTrace);
    }

    private List<AbstractTraceElement> summarize(List<AbstractTraceElement> abstractTrace, BooleanFormulaManager bmgr) {
        if (abstractTrace.size() < 2) {
            return new ArrayList<AbstractTraceElement>(abstractTrace);
        }
        ArrayList<AbstractTraceElement> summarizedList = new ArrayList<AbstractTraceElement>();
        Trace.TraceAtom lastSelector = null;
        for (AbstractTraceElement abstractTraceElement : abstractTrace) {
            if (abstractTraceElement instanceof Trace.TraceAtom) {
                if (abstractTraceElement.equals(lastSelector)) {
                    Interval toMerge = (Interval)summarizedList.remove(summarizedList.size() - 3);
                    Interval lastInterval = (Interval)summarizedList.remove(summarizedList.size() - 1);
                    Interval merged = Interval.merge(toMerge, lastInterval, bmgr);
                    summarizedList.add(summarizedList.size() - 1, merged);
                    continue;
                }
                summarizedList.add(abstractTraceElement);
                lastSelector = (Trace.TraceAtom)abstractTraceElement;
                continue;
            }
            summarizedList.add(abstractTraceElement);
        }
        return summarizedList;
    }

    private Set<Fault> createFaults(List<AbstractTraceElement> abstractTrace) {
        ImmutableList allSelectors = ImmutableList.copyOf((Collection)((Object)this.errorTrace.getTrace()));
        Trace.TraceAtom prev = (Trace.TraceAtom)allSelectors.get(0);
        HashSet<Fault> faults = new HashSet<Fault>();
        for (int i = 0; i < abstractTrace.size(); ++i) {
            AbstractTraceElement errorInvariant = abstractTrace.get(i);
            if (errorInvariant instanceof Trace.TraceAtom) {
                prev = (Trace.TraceAtom)errorInvariant;
                Fault singleton = new Fault(prev);
                singleton.setIntendedIndex(i);
                faults.add(singleton);
                continue;
            }
            if (!(errorInvariant instanceof Interval)) continue;
            Interval curr = (Interval)errorInvariant;
            Trace.TraceAtom next = i + 1 < abstractTrace.size() ? (Trace.TraceAtom)abstractTrace.get(i + 1) : (Trace.TraceAtom)allSelectors.get(allSelectors.size() - 1);
            HashSet<FaultContribution> contributions = new HashSet<FaultContribution>();
            for (int j = allSelectors.indexOf((Object)prev); j < allSelectors.indexOf((Object)next); ++j) {
                contributions.add((FaultContribution)allSelectors.get(j));
            }
            if (curr.isEmpty()) {
                contributions.add(prev);
            }
            curr.replaceErrorSet(contributions);
            curr.setIntendedIndex(i);
            if (i == 0 && curr.invariant.equals(this.errorTrace.getPrecondition().getPrecondition())) continue;
            faults.add(curr);
        }
        this.logger.log(Level.ALL, new Object[]{"Abstract error trace:", Appenders.forIterable((Joiner)Joiner.on((String)"\n - "), abstractTrace)});
        this.logger.log(Level.FINEST, new Object[]{"tfresult=", FluentIterable.from(abstractTrace).filter(tr -> !(tr instanceof Interval)).transform(fc -> ((Trace.TraceAtom)fc).correspondingEdge().getFileLocation().getStartingLineInOrigin())});
        return faults;
    }

    private int search(Solver solver, int low, int high, BooleanFormula interpolant, boolean negate) throws SolverException, InterruptedException {
        this.searchCalls.inc();
        if (high < low) {
            return low;
        }
        int mid = (low + high) / 2;
        if (this.isErrInv(solver, interpolant, mid) ^ negate) {
            return this.search(solver, mid + 1, high, interpolant, negate);
        }
        return this.search(solver, low, mid - 1, interpolant, negate);
    }

    private boolean isErrInv(Solver solver, BooleanFormula interpolant, int slicePosition) throws SolverException, InterruptedException {
        FormulaManagerView fmgr = solver.getFormulaManager();
        BooleanFormulaManagerView bmgr = solver.getFormulaManager().getBooleanFormulaManager();
        int n = this.errorTrace.getTrace().size();
        BooleanFormula plainInterpolant = fmgr.uninstantiate(interpolant);
        if (this.memorize.containsKey((Object)plainInterpolant)) {
            this.memoizationCalls.inc();
            if (this.memorize.get((Object)plainInterpolant).contains(-slicePosition - 1)) {
                return false;
            }
            if (this.memorize.get((Object)plainInterpolant).contains(slicePosition + 1)) {
                return true;
            }
        }
        SSAMap shift = SSAMap.merge((SSAMap)this.maps.get(slicePosition), (SSAMap)this.maps.get(0), (MapsDifference.Visitor<String, Integer>)MapsDifference.collectMapsDifferenceTo(new ArrayList()));
        BooleanFormula shiftedInterpolant = fmgr.instantiate(plainInterpolant, shift);
        ConjunctionTraceInterpreter interpreter = new ConjunctionTraceInterpreter(solver.getFormulaManager().getBooleanFormulaManager());
        BooleanFormula firstFormula = bmgr.implication(bmgr.and(this.errorTrace.getPrecondition().getPrecondition(), interpreter.interpret(this.errorTrace.getTrace().slice(slicePosition))), shiftedInterpolant);
        BooleanFormula secondFormula = bmgr.and(new BooleanFormula[]{shiftedInterpolant, interpreter.interpret(this.errorTrace.getTrace().slice(slicePosition, n)), bmgr.not(this.errorTrace.getPostCondition().getPostCondition())});
        this.solverCalls.inc();
        boolean isValid = this.isValid(solver, firstFormula) && solver.isUnsat(secondFormula);
        this.memorize.put((Object)plainInterpolant, (Object)(isValid ? slicePosition + 1 : -slicePosition - 1));
        return isValid;
    }

    private boolean isValid(Solver solver, BooleanFormula formula) throws SolverException, InterruptedException {
        this.solverCalls.inc();
        BooleanFormulaManagerView bmgr = solver.getFormulaManager().getBooleanFormulaManager();
        return solver.isUnsat(bmgr.not(formula));
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
        StatisticsWriter.writingStatisticsTo(out).put(this.totalTime).put(this.searchCalls).put(this.solverCalls).put(this.memoizationCalls);
    }

    @Override
    public @Nullable String getName() {
        return this.getClass().getSimpleName();
    }

    public static class Interval
    extends Fault
    implements AbstractTraceElement {
        private final int start;
        private final int end;
        private final BooleanFormula invariant;

        public Interval(int pStart, int pEnd, BooleanFormula pInvariant) {
            this.start = pStart;
            this.end = pEnd;
            this.invariant = pInvariant;
        }

        public static Interval merge(Interval pFirst, Interval pSecond, BooleanFormulaManager pBmgr) {
            int newStart = Integer.min(pFirst.start, pSecond.start);
            int newEnd = Integer.max(pFirst.end, pSecond.end);
            return new Interval(newStart, newEnd, pBmgr.and(pFirst.getInvariant(), pSecond.getInvariant()));
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }

        @Override
        public String toString() {
            return "Interval [" + this.start + ";" + this.end + "]: " + this.invariant;
        }

        @Override
        public boolean equals(Object q) {
            if (q instanceof Interval) {
                Interval compare = (Interval)q;
                return compare.start == this.start && compare.end == this.end && this.invariant.equals(compare.invariant) && super.equals(q);
            }
            return false;
        }

        public BooleanFormula getInvariant() {
            return this.invariant;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.invariant, this.start, this.end, super.hashCode());
        }
    }
}

