/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.error_invariants;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.error_invariants.ErrorInvariantsAlgorithm;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultReportWriter;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultReason;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.PotentialFix;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaToCVisitor;
import org.sosy_lab.java_smt.api.Formula;

public class IntervalReportWriter
extends FaultReportWriter {
    private final FormulaManagerView formulaManager;
    private final FormulaToCVisitor visitor;

    public IntervalReportWriter(FormulaManagerView pFormulaManager) {
        this.formulaManager = pFormulaManager;
        this.visitor = new FormulaToCVisitor(this.formulaManager);
    }

    @Override
    public String toHtml(Fault pFault) {
        if (pFault instanceof ErrorInvariantsAlgorithm.Interval) {
            List edges = (List)pFault.stream().map(FaultContribution::correspondingEdge).sorted(Comparator.comparingInt(l -> l.getFileLocation().getStartingLineInOrigin())).collect(ImmutableList.toImmutableList());
            return this.intervalToHtml((ErrorInvariantsAlgorithm.Interval)pFault, pFault.getInfos(), edges);
        }
        return super.toHtml(pFault);
    }

    public String intervalToHtml(ErrorInvariantsAlgorithm.Interval interval, List<FaultInfo> infos, List<CFAEdge> correspondingEdges) {
        ArrayList<FaultReason> faultReasons = new ArrayList<FaultReason>();
        ArrayList<RankInfo> faultInfo = new ArrayList<RankInfo>();
        ArrayList<PotentialFix> faultFix = new ArrayList<PotentialFix>();
        block5: for (FaultInfo info : infos) {
            switch (info.getType()) {
                case FIX: {
                    faultFix.add((PotentialFix)info);
                    continue block5;
                }
                case REASON: {
                    faultReasons.add((FaultReason)info);
                    continue block5;
                }
                case RANK_INFO: {
                    faultInfo.add((RankInfo)info);
                    continue block5;
                }
            }
            throw new AssertionError((Object)"Unknown InfoType");
        }
        int index = interval.getIntendedIndex() / 2;
        this.formulaManager.visit((Formula)interval.getInvariant(), this.visitor);
        Map<Integer, String> distinctRelevantStatements = this.getDistinctStatements(correspondingEdges);
        String header = "Interpolant <strong>" + index + "</strong>:<br> <textarea readonly class=\"interval-scrollbox\">" + this.visitor.getString() + "</textarea><br>";
        StringBuilder html = new StringBuilder();
        if (!distinctRelevantStatements.isEmpty()) {
            html.append(" Relevant lines:\n<ul class=\"fault-lines\">\n");
            distinctRelevantStatements.entrySet().stream().sorted(Comparator.comparingInt(e -> (Integer)e.getKey())).forEach(e -> html.append("<li><span class=\"line-number\">").append(e.getKey()).append("</span>").append("<span class=\"line-content\">").append((String)e.getValue()).append("</span>").append("</li>"));
            html.append("</ul>\n");
        } else {
            header = "Additional Information for:<br>" + header;
        }
        if (!faultReasons.isEmpty() && !this.hideTypes.contains((Object)FaultInfo.InfoType.REASON)) {
            html.append(this.printList("Detected <strong>" + faultReasons.size() + "</strong> possible reason" + (faultReasons.size() == 1 ? ":" : "s:"), "", faultReasons, true)).append("<br>");
        }
        if (!faultFix.isEmpty() && !this.hideTypes.contains((Object)FaultInfo.InfoType.FIX)) {
            html.append(this.printList("Found <strong>" + faultFix.size() + "</strong> possible bug-fix" + (faultFix.size() == 1 ? ":" : "es:"), "fix-list", faultFix, false)).append("<br>");
        }
        if (!faultInfo.isEmpty() && !this.hideTypes.contains((Object)FaultInfo.InfoType.RANK_INFO)) {
            html.append(this.printList("The score is obtained by:", "", faultInfo, true)).append("<br>");
        }
        return header + "<br>" + html;
    }
}

