/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.rankings;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;

public class CallHierarchyScoring
implements FaultScoring {
    private final Map<CFAEdge, Integer> mapEdgeToPosition = new HashMap<CFAEdge, Integer>();
    private final int firstErrorEdge;

    public CallHierarchyScoring(List<CFAEdge> pEdgeList) {
        for (int i = 0; i < pEdgeList.size(); ++i) {
            this.mapEdgeToPosition.put(pEdgeList.get(i), i + 1);
        }
        this.firstErrorEdge = pEdgeList.size() + 1;
    }

    @Override
    public RankInfo scoreFault(Fault fault) {
        int max = fault.stream().mapToInt(fc -> this.mapEdgeToPosition.getOrDefault(fc.correspondingEdge(), 0)).max().orElse(0);
        int min = this.firstErrorEdge - max;
        return FaultInfo.rankInfo("This fault is " + min + " execution step(s) away from the error location.", max);
    }
}

