/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.rankings;

import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;

public class EdgeTypeScoring
implements FaultScoring {
    private double getScore(CFAEdge edge) {
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                return 100.0;
            }
            case StatementEdge: {
                return 50.0;
            }
            case ReturnStatementEdge: {
                return 25.0;
            }
            case FunctionReturnEdge: 
            case CallToReturnEdge: 
            case FunctionCallEdge: {
                return 12.5;
            }
        }
        return 0.0;
    }

    @Override
    public RankInfo scoreFault(Fault fault) {
        double sum = fault.stream().mapToDouble(fc -> this.getScore(fc.correspondingEdge())).sum();
        return FaultInfo.rankInfo("Score based on edge type(s).", sum);
    }
}

