/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.tests;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.truth.Truth;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.junit.Test;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizationInfoWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.error_invariants.ErrorInvariantsAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.Trace;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class TraceFormulaTest {
    private final Level logLevel = Level.FINEST;

    private TestResults runFaultLocalization(String name, FLAlgorithm algorithm, Map<String, String> additionalOptions) throws Exception {
        Configuration config = TestDataTools.configurationForTest().loadFromResource(TraceFormulaTest.class, "predicateAnalysisWithFaultLocalization.properties").setOption("faultLocalization.by_traceformula.type", algorithm.name()).setOptions(additionalOptions).build();
        String test_dir = "test/programs/fault_localization/";
        Path program = Path.of(test_dir, name);
        return CPATestRunner.run(config, program.toString(), this.logLevel);
    }

    private Multimap<LogKeys, Object> findFLPatterns(String log, Set<LogKeys> keywords) {
        ArrayListMultimap entries = ArrayListMultimap.create();
        Splitter.on((String)"\n").split((CharSequence)log).forEach(arg_0 -> this.lambda$findFLPatterns$1(keywords, (Multimap)entries, arg_0));
        return entries;
    }

    private void checkIfExpectedValuesMatchResultValues(String program, FLAlgorithm algorithm, Map<String, String> options, Map<LogKeys, Object> expected) throws Exception {
        TestResults test = this.runFaultLocalization(program, algorithm, options);
        FaultLocalizationInfoWithTraceFormula faultInfo = (FaultLocalizationInfoWithTraceFormula)AbstractStates.getTargetStates(test.getCheckerResult().getReached()).stream().filter(state -> ((ARGState)state).getCounterexampleInformation().isPresent()).map(state -> ((ARGState)state).getCounterexampleInformation().orElseThrow()).filter(cex -> cex instanceof FaultLocalizationInfoWithTraceFormula).findFirst().orElseThrow();
        Multimap<LogKeys, Object> found = this.findFLPatterns(test.getLog(), expected.keySet());
        ArrayList<Integer> lines = new ArrayList<Integer>();
        block4: for (Fault fault : faultInfo.getRankedList()) {
            switch (algorithm) {
                case ERRINV: {
                    if (fault instanceof ErrorInvariantsAlgorithm.Interval) continue block4;
                    Trace.TraceAtom traceElement = (Trace.TraceAtom)Iterables.getOnlyElement((Iterable)((Object)fault));
                    lines.add(traceElement.correspondingEdge().getFileLocation().getStartingLineInOrigin());
                    break;
                }
                case MAXSAT: {
                    Iterator iterator = fault.iterator();
                    while (iterator.hasNext()) {
                        FaultContribution contribution = (FaultContribution)iterator.next();
                        Trace.TraceAtom traceElement = (Trace.TraceAtom)contribution;
                        lines.add(traceElement.correspondingEdge().getFileLocation().getStartingLineInOrigin());
                    }
                    continue block4;
                }
                default: {
                    throw new AssertionError((Object)(algorithm + " is not a valid algorithm."));
                }
            }
        }
        expected.forEach((key, value) -> {
            switch (key) {
                case TFRESULT: {
                    ImmutableList expectedLines = (ImmutableList)value;
                    ImmutableList foundLinesLog = Collections3.transformedImmutableListCopy((Collection)found.get((Object)key), val -> (Integer)val);
                    Truth.assertThat((Iterable)lines).containsExactlyElementsIn((Iterable)expectedLines);
                    Truth.assertThat((Iterable)foundLinesLog).containsExactlyElementsIn((Iterable)expectedLines);
                    break;
                }
                case TFPOSTCONDITION: {
                    ImmutableList expectedLines = (ImmutableList)value;
                    ImmutableList foundLines = Collections3.transformedImmutableListCopy((Collection)found.get((Object)key), val -> (Integer)val);
                    Truth.assertThat((Iterable)foundLines).containsExactlyElementsIn((Iterable)expectedLines);
                    break;
                }
                case TFPRECONDITION: {
                    ImmutableList expectedValues = (ImmutableList)value;
                    ImmutableList variableValues = (ImmutableList)found.get((Object)key).stream().map(Object::toString).collect(ImmutableList.toImmutableList());
                    Truth.assertThat((Iterable)variableValues).containsExactlyElementsIn((Iterable)expectedValues);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown log keyword: " + key));
                }
            }
        });
    }

    @Test
    public void testCorrectCalculationOfPreAndPostCondition() throws Exception {
        ImmutableList preconditionValues = ImmutableList.of((Object)"__VERIFIER_nondet_int!2@: 4", (Object)"main::number@3: 4", (Object)"main::copyForCheck@2: 4", (Object)"main::test@2: 1", (Object)"main::i@2: 2", (Object)"isPrime::n@2: 2", (Object)"isPrime::i@2: 2", (Object)"isPrime::__retval__@2: 1", (Object)"main::__CPAchecker_TMP_0@3: 1", (Object)"main::test@3: 2", (Object)"main::number@4: 2", (Object)"main::i@3: 2", (Object[])new String[]{"main::i@4: 3"});
        ImmutableList postConditionLocation = ImmutableList.of((Object)47);
        this.checkIfExpectedValuesMatchResultValues("unit_test_pre-post-condition.c", FLAlgorithm.ERRINV, (Map<String, String>)ImmutableMap.of(), (Map<LogKeys, Object>)ImmutableMap.builder().put((Object)LogKeys.TFPRECONDITION, (Object)preconditionValues).put((Object)LogKeys.TFPOSTCONDITION, (Object)postConditionLocation).buildOrThrow());
    }

    @Test
    public void testErrorInvariantsOnFlowSensitiveTrace() throws Exception {
        ImmutableList faultyLines = ImmutableList.of((Object)17);
        this.checkIfExpectedValuesMatchResultValues("unit_test_traces.c", FLAlgorithm.ERRINV, (Map<String, String>)ImmutableMap.of(), (Map<LogKeys, Object>)ImmutableMap.of((Object)((Object)LogKeys.TFRESULT), (Object)faultyLines));
    }

    @Test
    public void testErrorInvariantsOnDefaultTrace() throws Exception {
        ImmutableList faultyLines = ImmutableList.of((Object)17);
        this.checkIfExpectedValuesMatchResultValues("unit_test_traces.c", FLAlgorithm.ERRINV, (Map<String, String>)ImmutableMap.of((Object)"faultLocalization.by_traceformula.errorInvariants.disableFSTF", (Object)"true"), (Map<LogKeys, Object>)ImmutableMap.of((Object)((Object)LogKeys.TFRESULT), (Object)faultyLines));
    }

    @Test
    public void testMaxSatSelectorTrace() throws Exception {
        ImmutableList faultyLines = ImmutableList.of((Object)17);
        this.checkIfExpectedValuesMatchResultValues("unit_test_traces.c", FLAlgorithm.MAXSAT, (Map<String, String>)ImmutableMap.of(), (Map<LogKeys, Object>)ImmutableMap.of((Object)((Object)LogKeys.TFRESULT), (Object)faultyLines));
    }

    private /* synthetic */ void lambda$findFLPatterns$1(Set keywords, Multimap entries, String line) {
        List result = Splitter.on((String)"=").limit(2).splitToList((CharSequence)line);
        if (result.size() == 2 && LogKeys.containsKey((String)result.get(0))) {
            LogKeys key = LogKeys.valueOf(((String)result.get(0)).toUpperCase());
            String value = ((String)result.get(1)).replaceAll("\\(.*, " + this.logLevel + "\\)", "").trim();
            if (keywords.contains((Object)key)) {
                if (key == LogKeys.TFPRECONDITION) {
                    entries.put((Object)key, (Object)value);
                } else {
                    value = CharMatcher.anyOf((CharSequence)"[]").removeFrom((CharSequence)value);
                    Splitter.on((String)", ").splitToList((CharSequence)value).forEach(loc -> entries.put((Object)key, (Object)Integer.parseInt(loc)));
                }
            }
        }
    }

    private static enum LogKeys {
        TFRESULT,
        TFPRECONDITION,
        TFPOSTCONDITION;


        public static boolean containsKey(String keyString) {
            for (LogKeys key : LogKeys.values()) {
                if (!key.toString().toLowerCase().equals(keyString)) continue;
                return true;
            }
            return false;
        }
    }

    private static enum FLAlgorithm {
        MAXSAT,
        ERRINV;

    }
}

