/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition.PostCondition;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition.PostConditionComposer;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.java_smt.api.SolverException;

public class FinalAssumeClusterPostConditionComposer
implements PostConditionComposer {
    private final FormulaContext context;

    public FinalAssumeClusterPostConditionComposer(FormulaContext pContext) {
        this.context = pContext;
    }

    @Override
    public PostCondition extractPostCondition(List<CFAEdge> pCounterexample) throws SolverException, InterruptedException, CPATransferException {
        int i;
        CFAEdge lastAssumeEdge = null;
        ArrayList<CFAEdge> irrelevant = new ArrayList<CFAEdge>();
        List<CFAEdge> postConditionEdges = new ArrayList();
        for (i = pCounterexample.size() - 1; i >= 0; --i) {
            CFAEdge currentEdge = pCounterexample.get(i);
            if (currentEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                lastAssumeEdge = currentEdge;
                postConditionEdges.add(currentEdge);
                continue;
            }
            if (lastAssumeEdge != null) break;
            irrelevant.add(currentEdge);
        }
        if (postConditionEdges.isEmpty()) {
            throw new AssertionError((Object)("Cannot extract post-condition from counterexample: " + pCounterexample));
        }
        postConditionEdges = Lists.reverse(postConditionEdges);
        postConditionEdges.forEach(edge -> this.context.getLogger().log(Level.FINEST, new Object[]{"tfpostcondition=" + edge.getFileLocation().getStartingLineInOrigin()}));
        return new PostCondition(postConditionEdges, Lists.reverse(irrelevant), pCounterexample.subList(0, i + 1), PostConditionComposer.postConditionFromList(this.context, postConditionEdges));
    }
}

