/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition.PostCondition;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.postcondition.PostConditionComposer;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.java_smt.api.SolverException;

public class FinalAssumeEdgePostConditionComposer
implements PostConditionComposer {
    private final FormulaContext context;

    public FinalAssumeEdgePostConditionComposer(FormulaContext pContext) {
        this.context = pContext;
    }

    @Override
    public PostCondition extractPostCondition(List<CFAEdge> pCounterexample) throws SolverException, InterruptedException, CPATransferException {
        ArrayList<CFAEdge> irrelevant = new ArrayList<CFAEdge>();
        for (int i = pCounterexample.size() - 1; i >= 0; --i) {
            CFAEdge currentEdge = pCounterexample.get(i);
            if (currentEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                ImmutableList postConditionEdges = ImmutableList.of((Object)currentEdge);
                postConditionEdges.forEach(edge -> this.context.getLogger().log(Level.FINEST, new Object[]{"tfpostcondition=" + edge.getFileLocation().getStartingLineInOrigin()}));
                return new PostCondition((List<CFAEdge>)postConditionEdges, Lists.reverse(irrelevant), pCounterexample.subList(0, i + 1), PostConditionComposer.postConditionFromList(this.context, (List<CFAEdge>)postConditionEdges));
            }
            irrelevant.add(currentEdge);
        }
        throw new IllegalArgumentException("Cannot find post-condition for provided counterexample: " + pCounterexample);
    }
}

