/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.precondition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.cpachecker.cfa.ast.AbstractStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.precondition.PreCondition;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.precondition.PreConditionComposer;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;

public class VariableAssignmentPreConditionComposer
implements PreConditionComposer {
    private final FormulaContext context;
    private final TraceFormula.TraceFormulaOptions options;
    private final boolean includeInitialAssignment;

    public VariableAssignmentPreConditionComposer(FormulaContext pContext, TraceFormula.TraceFormulaOptions pOptions, boolean pWithInitialAssignment) {
        this.context = pContext;
        this.options = pOptions;
        this.includeInitialAssignment = pWithInitialAssignment;
    }

    @Override
    public PreCondition extractPreCondition(List<CFAEdge> pCounterexample) throws SolverException, InterruptedException, CPATransferException {
        PreCondition nondets = this.createNondetPrecondition(pCounterexample);
        if (!this.includeInitialAssignment) {
            return nondets;
        }
        ArrayList<CFAEdge> remainingCounterexample = new ArrayList<CFAEdge>();
        ArrayList<CFAEdge> preconditionEdges = new ArrayList<CFAEdge>();
        HashSet<String> coveredVariables = new HashSet<String>();
        for (CFAEdge cfaEdge : pCounterexample) {
            if (cfaEdge.getEdgeType() != CFAEdgeType.DeclarationEdge && cfaEdge.getEdgeType() != CFAEdgeType.StatementEdge) {
                remainingCounterexample.add(cfaEdge);
                continue;
            }
            if (!this.options.getFunctionsForPrecondition().contains(cfaEdge.getPredecessor().getFunction().getQualifiedName())) {
                remainingCounterexample.add(cfaEdge);
                continue;
            }
            if (cfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
                CDeclarationEdge declarationEdge = (CDeclarationEdge)cfaEdge;
                String qualifiedName = declarationEdge.getDeclaration().getQualifiedName();
                if (coveredVariables.contains(qualifiedName) || !this.handleDeclarationEdge(declarationEdge)) {
                    remainingCounterexample.add(cfaEdge);
                } else {
                    preconditionEdges.add(cfaEdge);
                }
                coveredVariables.add(qualifiedName);
                continue;
            }
            if (cfaEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
                AbstractStatement statement;
                CStatementEdge statementEdge = (CStatementEdge)cfaEdge;
                if (statementEdge.getStatement() instanceof CFunctionCallAssignmentStatement) {
                    statement = (CFunctionCallAssignmentStatement)statementEdge.getStatement();
                    coveredVariables.add(((CFunctionCallAssignmentStatement)statement).getLeftHandSide().toQualifiedASTString());
                    remainingCounterexample.add(cfaEdge);
                    continue;
                }
                if (statementEdge.getStatement() instanceof CExpressionAssignmentStatement) {
                    statement = (CExpressionAssignmentStatement)statementEdge.getStatement();
                    String qualifiedName = ((CExpressionAssignmentStatement)statement).getLeftHandSide().toQualifiedASTString();
                    if (coveredVariables.contains(qualifiedName) || !(((CExpressionAssignmentStatement)statement).getRightHandSide() instanceof CLiteralExpression)) {
                        remainingCounterexample.add(cfaEdge);
                    } else {
                        preconditionEdges.add(cfaEdge);
                    }
                    coveredVariables.add(qualifiedName);
                    continue;
                }
            }
            remainingCounterexample.add(cfaEdge);
        }
        FormulaManagerView fmgr = this.context.getSolver().getFormulaManager();
        return new PreCondition(preconditionEdges, remainingCounterexample, fmgr.uninstantiate(fmgr.getBooleanFormulaManager().and(nondets.getPrecondition(), this.context.getManager().makeFormulaForPath(preconditionEdges).getFormula())));
    }

    private PreCondition createNondetPrecondition(List<CFAEdge> pCounterexample) throws SolverException, InterruptedException, CPATransferException {
        BooleanFormulaManagerView bmgr = this.context.getSolver().getFormulaManager().getBooleanFormulaManager();
        BooleanFormula precond = bmgr.makeTrue();
        try (ProverEnvironment prover = this.context.getProver();){
            prover.push(this.context.getManager().makeFormulaForPath(pCounterexample).getFormula());
            Preconditions.checkArgument((!prover.isUnsat() ? 1 : 0) != 0, (Object)"a model has to be existent");
            for (Model.ValueAssignment modelAssignment : prover.getModelAssignments()) {
                this.context.getLogger().log(Level.FINEST, new Object[]{"tfprecondition=" + modelAssignment});
                BooleanFormula formula = modelAssignment.getAssignmentAsFormula();
                if (Pattern.matches(".+::.+@[0-9]+", modelAssignment.getKey().toString())) continue;
                precond = bmgr.and(precond, formula);
            }
            Object object = new PreCondition((List<CFAEdge>)ImmutableList.of(), pCounterexample, this.context.getSolver().getFormulaManager().uninstantiate(precond));
            return object;
        }
    }

    private boolean handleDeclarationEdge(CDeclarationEdge declarationEdge) {
        if (!(declarationEdge.getDeclaration() instanceof CVariableDeclaration)) {
            return false;
        }
        CVariableDeclaration variableDeclaration = (CVariableDeclaration)declarationEdge.getDeclaration();
        if (this.options.getExcludeFromPrecondition().contains(variableDeclaration.getQualifiedName())) {
            return false;
        }
        CInitializer initializer = variableDeclaration.getInitializer();
        if (initializer == null) {
            return false;
        }
        if (initializer instanceof CInitializerList) {
            CInitializerList listInitializer = (CInitializerList)initializer;
            ArrayList<CInitializer> waitlist = new ArrayList<CInitializer>(listInitializer.getInitializers());
            while (!waitlist.isEmpty()) {
                CInitializerExpression expression;
                CInitializer next = (CInitializer)waitlist.remove(0);
                if (next instanceof CInitializerList) {
                    waitlist.addAll(((CInitializerList)next).getInitializers());
                    continue;
                }
                if (!(next instanceof CInitializerExpression) || (expression = (CInitializerExpression)next).getExpression() instanceof CLiteralExpression) continue;
                return false;
            }
            return true;
        }
        if (initializer instanceof CInitializerExpression) {
            CInitializerExpression expression = (CInitializerExpression)initializer;
            return expression.getExpression() instanceof CLiteralExpression;
        }
        return false;
    }
}

