/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.error_invariants.AbstractTraceElement;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.dependencegraph.MergePoint;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;

public class Trace
extends ForwardingList<TraceAtom> {
    private final ImmutableList<TraceAtom> entries;
    private final SSAMap latestSSAMap;
    private final SSAMap initialSSAMap;
    private final FormulaContext context;

    private Trace(FormulaContext pContext, List<TraceAtom> pEntries) {
        this.entries = ImmutableList.copyOf(pEntries);
        this.context = pContext;
        if (this.entries.isEmpty()) {
            this.latestSSAMap = SSAMap.emptySSAMap();
            this.initialSSAMap = SSAMap.emptySSAMap();
        } else {
            this.latestSSAMap = ((TraceAtom)this.entries.get((int)(this.entries.size() - 1))).ssaMap;
            this.initialSSAMap = this.calculateInitialSsaMap();
        }
    }

    public SSAMap getLatestSsaMap() {
        return this.latestSSAMap;
    }

    public SSAMap getInitialSsaMap() {
        return this.initialSSAMap;
    }

    private SSAMap calculateInitialSsaMap() {
        HashMap minIndexMap = new HashMap();
        HashMap typeMap = new HashMap();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TraceAtom traceAtom = (TraceAtom)iterator.next();
            this.context.getSolver().getFormulaManager().extractVariables((Formula)traceAtom.formula).forEach((name, variable) -> {
                Pair<String, OptionalInt> pair = FormulaManagerView.parseName(name);
                if (Objects.requireNonNull(pair.getSecond()).isPresent()) {
                    minIndexMap.merge(pair.getFirst(), pair.getSecond().orElseThrow(), Integer::min);
                    typeMap.put(pair.getFirst(), traceAtom.ssaMap.getType(Objects.requireNonNull(pair.getFirst())));
                }
            });
        }
        SSAMap.SSAMapBuilder builder = SSAMap.emptySSAMap().builder();
        for (Map.Entry variableIndexEntry : minIndexMap.entrySet()) {
            builder = builder.setIndex((String)variableIndexEntry.getKey(), (CType)typeMap.get(variableIndexEntry.getKey()), (Integer)variableIndexEntry.getValue());
        }
        return builder.build();
    }

    private Trace makeFlowSensitive() {
        int i;
        if (this.entries.isEmpty()) {
            return this;
        }
        BooleanFormulaManagerView bmgr = this.context.getSolver().getFormulaManager().getBooleanFormulaManager();
        HashMap<CFANode, Integer> mergeNodes = new HashMap<CFANode, Integer>();
        MergePoint<CFANode> mergePoint = new MergePoint<CFANode>(((TraceAtom)this.entries.get(0)).correspondingEdge().getPredecessor(), CFAUtils::allSuccessorsOf, CFAUtils::allPredecessorsOf);
        ArrayList labels = new ArrayList(this.entries.size());
        for (TraceAtom entry : this.entries) {
            ArrayList<FormulaLabel> labelsForEntry = new ArrayList<FormulaLabel>();
            if (entry.correspondingEdge().getEdgeType() == CFAEdgeType.AssumeEdge) {
                labelsForEntry.add(FormulaLabel.IF);
                mergeNodes.merge(mergePoint.findMergePoint(entry.correspondingEdge().getPredecessor()), 1, Integer::sum);
            }
            for (i = 0; i < mergeNodes.getOrDefault(entry.correspondingEdge().getSuccessor(), 0); ++i) {
                labelsForEntry.add(0, FormulaLabel.ENDIF);
            }
            labels.add(labelsForEntry);
        }
        ArrayDeque<BooleanFormula> conditions = new ArrayDeque<BooleanFormula>();
        ArrayList<TraceAtom> flowSensitiveList = new ArrayList<TraceAtom>(this.entries.size());
        int index = 0;
        for (i = 0; i < labels.size(); ++i) {
            List currentLabels = (List)labels.get(i);
            TraceAtom currentTraceAtom = (TraceAtom)this.entries.get(i);
            boolean isIf = false;
            for (FormulaLabel currentLabel : currentLabels) {
                if (currentLabel == FormulaLabel.ENDIF) {
                    conditions.pop();
                    continue;
                }
                if (currentLabel != FormulaLabel.IF) continue;
                conditions.push(currentTraceAtom.formula);
                isIf = true;
            }
            if (isIf) continue;
            if (conditions.isEmpty()) {
                flowSensitiveList.add(new TraceAtom(index, currentTraceAtom.selector, currentTraceAtom.formula, currentTraceAtom.ssaMap, currentTraceAtom.correspondingEdge()));
            } else {
                flowSensitiveList.add(new TraceAtom(index, currentTraceAtom.selector, bmgr.implication(bmgr.and(conditions), currentTraceAtom.formula), currentTraceAtom.ssaMap, currentTraceAtom.correspondingEdge()));
            }
            ++index;
        }
        return new Trace(this.context, flowSensitiveList);
    }

    public static Trace fromCounterexample(List<CFAEdge> pCounterexample, FormulaContext pContext, TraceFormula.TraceFormulaOptions pOptions) throws CPATransferException, InterruptedException {
        ArrayList<TraceAtom> atoms = new ArrayList<TraceAtom>(pCounterexample.size());
        FormulaManagerView fmgr = pContext.getSolver().getFormulaManager();
        BooleanFormulaManagerView bmgr = fmgr.getBooleanFormulaManager();
        PathFormulaManagerImpl manager = pContext.getManager();
        HashMap<CFAEdge, BooleanFormula> edgeToSelector = new HashMap<CFAEdge, BooleanFormula>();
        PathFormula previousPathFormula = null;
        int index = 0;
        for (CFAEdge cfaEdge : pCounterexample) {
            BooleanFormula selector;
            if (bmgr.isTrue(manager.makeAnd(manager.makeEmptyPathFormula(), cfaEdge).getFormula())) continue;
            if (pOptions.isReduceSelectors()) {
                selector = edgeToSelector.getOrDefault(cfaEdge, Trace.makeSelectorFormula(fmgr, index));
                edgeToSelector.put(cfaEdge, selector);
            } else {
                selector = Trace.makeSelectorFormula(fmgr, index);
            }
            if (previousPathFormula == null) {
                previousPathFormula = manager.makeAnd(manager.makeEmptyPathFormula(), cfaEdge);
                atoms.add(new TraceAtom(index, selector, previousPathFormula.getFormula(), previousPathFormula.getSsa(), cfaEdge));
            } else {
                PathFormula currentPathFormula = manager.makeAnd(previousPathFormula, cfaEdge);
                HashSet parts = new HashSet(bmgr.toConjunctionArgs(currentPathFormula.getFormula(), false));
                parts.remove(previousPathFormula.getFormula());
                BooleanFormula currentBooleanFormula = (BooleanFormula)Iterables.getOnlyElement(parts);
                atoms.add(new TraceAtom(index, selector, currentBooleanFormula, currentPathFormula.getSsa(), cfaEdge));
                previousPathFormula = currentPathFormula;
            }
            ++index;
        }
        if (pOptions.makeFlowSensitive()) {
            return new Trace(pContext, atoms).makeFlowSensitive();
        }
        return new Trace(pContext, atoms);
    }

    private static BooleanFormula makeSelectorFormula(FormulaManagerView fmgr, int index) {
        return (BooleanFormula)fmgr.makeVariable(FormulaType.BooleanType, "S." + index);
    }

    public List<BooleanFormula> toSelectorList() {
        return Lists.transform((List)((Object)this), atom -> atom.selector);
    }

    public List<BooleanFormula> toFormulaList() {
        return Lists.transform((List)((Object)this), atom -> atom.formula);
    }

    public List<SSAMap> toSSAMapList() {
        return Lists.transform((List)((Object)this), atom -> atom.ssaMap);
    }

    public List<CFAEdge> toEdgeList() {
        return Lists.transform((List)((Object)this), atom -> atom.correspondingEdge());
    }

    public Trace slice(int end) {
        return this.slice(0, end);
    }

    public Trace slice(int start, int end) {
        return new Trace(this.context, this.subList(start, end));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("size", this.size()).toString();
    }

    protected List<TraceAtom> delegate() {
        return this.entries;
    }

    public static class TraceAtom
    extends FaultContribution
    implements AbstractTraceElement {
        private final BooleanFormula selector;
        private final BooleanFormula formula;
        private final SSAMap ssaMap;
        private final int index;

        private TraceAtom(int pIndex, BooleanFormula pSelector, BooleanFormula pFormula, SSAMap pSSAMap, CFAEdge pEdge) {
            super(pEdge);
            this.index = pIndex;
            this.selector = pSelector;
            this.formula = pFormula;
            this.ssaMap = pSSAMap;
        }

        public BooleanFormula getFormula() {
            return this.formula;
        }

        public BooleanFormula getSelector() {
            return this.selector;
        }

        public int getIndex() {
            return this.index;
        }

        public SSAMap getSsaMap() {
            return this.ssaMap;
        }

        @Override
        public boolean equals(Object pO) {
            if (!(pO instanceof TraceAtom)) {
                return false;
            }
            TraceAtom traceAtom = (TraceAtom)pO;
            return this.index == traceAtom.index && super.equals(pO);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.index);
        }
    }

    private static enum FormulaLabel {
        IF,
        ENDIF;

    }
}

