/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat;

import com.google.common.base.VerifyException;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizerWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.SelectorTraceInterpreter;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.Trace;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat.MaxSatStatistics;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

public class ModifiedMaxSatAlgorithm
implements FaultLocalizerWithTraceFormula,
StatisticsProvider {
    private final MaxSatStatistics stats = new MaxSatStatistics();

    @Override
    public Set<Fault> run(FormulaContext pContext, TraceFormula tf) throws CPATransferException, InterruptedException, SolverException, VerifyException {
        Solver solver = pContext.getSolver();
        BooleanFormulaManagerView bmgr = solver.getFormulaManager().getBooleanFormulaManager();
        BooleanFormula booleanTraceFormula = tf.toFormula(new SelectorTraceInterpreter(bmgr), true);
        LinkedHashSet<Set<Trace.TraceAtom>> hard = new LinkedHashSet<Set<Trace.TraceAtom>>();
        LinkedHashSet<Trace.TraceAtom> soft = new LinkedHashSet<Trace.TraceAtom>((Collection<Trace.TraceAtom>)((Object)tf.getTrace()));
        int initSize = soft.size();
        Set<Object> minUnsatCore = new LinkedHashSet();
        this.stats.totalTime.start();
        while (minUnsatCore.size() != initSize) {
            minUnsatCore = this.getMinUnsatCore(soft, hard, booleanTraceFormula, pContext);
            if (minUnsatCore.size() == 1) {
                soft.removeAll(minUnsatCore);
                initSize = soft.size();
            }
            if (minUnsatCore.size() == initSize) continue;
            hard.add(minUnsatCore);
        }
        this.stats.totalTime.stop();
        pContext.getLogger().log(Level.FINEST, new Object[]{"tfresult=" + FluentIterable.from(hard).transformAndConcat(ImmutableList::copyOf).transform(fc -> fc.correspondingEdge().getFileLocation().getStartingLineInOrigin()).toSortedList(Integer::compareTo)});
        return Collections3.transformedImmutableSetCopy(hard, h -> (Fault)((Object)FluentIterable.from((Iterable)h).transform(atom -> atom).copyInto((Collection)((Object)new Fault()))));
    }

    private Set<Trace.TraceAtom> getMinUnsatCore(Set<Trace.TraceAtom> pSoftSet, Set<Set<Trace.TraceAtom>> pHardSet, BooleanFormula pTraceFormula, FormulaContext pContext) throws SolverException, InterruptedException {
        boolean changed;
        Solver solver = pContext.getSolver();
        BooleanFormulaManagerView bmgr = solver.getFormulaManager().getBooleanFormulaManager();
        LinkedHashSet<Trace.TraceAtom> result = new LinkedHashSet<Trace.TraceAtom>(pSoftSet);
        block0: do {
            changed = false;
            for (Trace.TraceAtom atom : result) {
                LinkedHashSet<Trace.TraceAtom> copy = new LinkedHashSet<Trace.TraceAtom>(result);
                copy.remove(atom);
                if (!this.isSubsetOrSupersetOf(copy, pHardSet)) {
                    this.stats.unsatCalls.inc();
                    if (!solver.isUnsat(bmgr.and(pTraceFormula, this.softSetFormula(copy, bmgr)))) continue;
                    changed = true;
                    result.remove(atom);
                    continue block0;
                }
                this.stats.savedCalls.inc();
            }
        } while (changed);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSubsetOrSupersetOf(Set<Trace.TraceAtom> pSet, Set<Set<Trace.TraceAtom>> pHardSet) {
        this.stats.timeForSubSupCheck.start();
        try {
            for (Set<Trace.TraceAtom> hardSet : pHardSet) {
                if (!hardSet.containsAll(pSet) && !pSet.containsAll(hardSet)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stats.timeForSubSupCheck.stop();
        }
    }

    private BooleanFormula softSetFormula(Set<Trace.TraceAtom> softSet, BooleanFormulaManager bmgr) {
        return (BooleanFormula)softSet.stream().map(f -> f.getFormula()).collect(bmgr.toConjunction());
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.stats);
    }
}

