/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat;

import com.google.common.base.VerifyException;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizerWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.SelectorTraceInterpreter;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.Trace;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat.MaxSatStatistics;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;

public class OriginalMaxSatAlgorithm
implements FaultLocalizerWithTraceFormula,
StatisticsProvider {
    private final MaxSatStatistics stats = new MaxSatStatistics();

    @Override
    public Set<Fault> run(FormulaContext pContext, TraceFormula tf) throws CPATransferException, InterruptedException, SolverException, VerifyException {
        Set<Trace.TraceAtom> complement;
        Solver solver = pContext.getSolver();
        BooleanFormulaManagerView bmgr = solver.getFormulaManager().getBooleanFormulaManager();
        BooleanFormula booleanTraceFormula = tf.toFormula(new SelectorTraceInterpreter(bmgr), true);
        LinkedHashSet<Fault> hard = new LinkedHashSet<Fault>();
        LinkedHashSet<Trace.TraceAtom> soft = new LinkedHashSet<Trace.TraceAtom>((Collection<Trace.TraceAtom>)((Object)tf.getTrace()));
        soft.removeIf(fc -> bmgr.isTrue(fc.getFormula()) || bmgr.isFalse(fc.getFormula()));
        this.stats.totalTime.start();
        while (!(complement = this.coMSS(soft, hard, booleanTraceFormula, pContext)).isEmpty()) {
            hard.add((Fault)((Object)FluentIterable.from(complement).transform(atom -> atom).copyInto((Collection)((Object)new Fault()))));
            soft.removeAll(complement);
        }
        this.stats.totalTime.stop();
        return hard;
    }

    private Set<Trace.TraceAtom> coMSS(Set<Trace.TraceAtom> pSoftSet, Set<Fault> pHardSet, BooleanFormula pTraceFormula, FormulaContext pContext) throws SolverException, InterruptedException {
        boolean changed;
        Solver solver = pContext.getSolver();
        BooleanFormulaManagerView bmgr = solver.getFormulaManager().getBooleanFormulaManager();
        LinkedHashSet<Trace.TraceAtom> selectors = new LinkedHashSet<Trace.TraceAtom>(pSoftSet);
        Fault result = new Fault();
        BooleanFormula composedFormula = bmgr.and(pTraceFormula, this.hardSetFormula(pHardSet, bmgr));
        block0: do {
            changed = false;
            for (Trace.TraceAtom atom : selectors) {
                Fault copy = new Fault((Collection<FaultContribution>)((Object)result));
                copy.add(atom);
                this.stats.unsatCalls.inc();
                if (solver.isUnsat(bmgr.and(composedFormula, this.softSetFormula(copy, bmgr)))) continue;
                changed = true;
                result.add(atom);
                selectors.remove(atom);
                continue block0;
            }
        } while (changed);
        return selectors;
    }

    private BooleanFormula softSetFormula(Fault softSet, BooleanFormulaManager bmgr) {
        return (BooleanFormula)softSet.stream().map(f -> ((Trace.TraceAtom)f).getFormula()).collect(bmgr.toConjunction());
    }

    private BooleanFormula hardSetFormula(Set<Fault> hardSet, BooleanFormulaManager bmgr) {
        return (BooleanFormula)hardSet.stream().map(l -> (BooleanFormula)l.stream().map(f -> ((Trace.TraceAtom)f).getFormula()).collect(bmgr.toDisjunction())).collect(bmgr.toConjunction());
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.stats);
    }
}

