/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat;

import com.google.common.base.VerifyException;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizerWithTraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.FormulaContext;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.TraceFormula;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.ConjunctionTraceInterpreter;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.trace_formula.trace.Trace;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.unsat.MaxSatStatistics;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public class SingleUnsatCoreAlgorithm
implements FaultLocalizerWithTraceFormula,
StatisticsProvider {
    private final MaxSatStatistics stats = new MaxSatStatistics();

    @Override
    public Set<Fault> run(FormulaContext context, TraceFormula tf) throws CPATransferException, InterruptedException, SolverException, VerifyException {
        Solver solver = context.getSolver();
        BooleanFormulaManagerView bmgr = solver.getFormulaManager().getBooleanFormulaManager();
        this.stats.totalTime.start();
        BooleanFormula booleanTraceFormula = tf.toFormula(new ConjunctionTraceInterpreter(bmgr), true);
        BiMap formulaToAtom = HashBiMap.create((Map)Maps.asMap((Set)ImmutableSet.copyOf((Collection)((Object)tf.getTrace())), entry -> entry.getFormula())).inverse();
        ImmutableList unsatCore = FluentIterable.from(solver.unsatCore(booleanTraceFormula)).filter(((Map)formulaToAtom)::containsKey).transform(arg_0 -> SingleUnsatCoreAlgorithm.lambda$run$1((Map)formulaToAtom, arg_0)).toList();
        this.stats.totalTime.stop();
        HashSet<Fault> resultSet = new HashSet<Fault>();
        resultSet.add(new Fault(new HashSet<FaultContribution>((Collection<FaultContribution>)unsatCore)));
        return resultSet;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.stats);
    }

    private static /* synthetic */ Trace.TraceAtom lambda$run$1(Map formulaToAtom, BooleanFormula formula) {
        return (Trace.TraceAtom)formulaToAtom.get(formula);
    }
}

