/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.impact;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.impact.Vertex;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.CachingPathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

@Options(prefix="impact")
public class ImpactAlgorithm
implements Algorithm,
StatisticsProvider {
    private final LogManager logger;
    private final ConfigurableProgramAnalysis cpa;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final PathFormulaManager pfmgr;
    private final Solver solver;
    private final InterpolationManager imgr;
    private final Timer expandTime = new Timer();
    private final Timer forceCoverTime = new Timer();
    private final Timer refinementTime = new Timer();
    private final Timer coverTime = new Timer();
    private final Timer closeTime = new Timer();
    private int successfulForcedCovering = 0;
    @Option(secure=true, description="enable the Forced Covering optimization")
    private boolean useForcedCovering = true;

    public ImpactAlgorithm(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ConfigurableProgramAnalysis pCpa, CFA cfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.cpa = pCpa;
        this.solver = Solver.create(config, pLogger, pShutdownNotifier);
        this.fmgr = this.solver.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.pfmgr = new CachingPathFormulaManager(new PathFormulaManagerImpl(this.fmgr, config, this.logger, pShutdownNotifier, cfa, AnalysisDirection.FORWARD));
        this.imgr = new InterpolationManager(this.pfmgr, this.solver, cfa.getLoopStructure(), cfa.getVarClassification(), config, pShutdownNotifier, this.logger);
    }

    public AbstractState getInitialState(CFANode location) throws InterruptedException {
        return new Vertex(this.bfmgr, this.bfmgr.makeTrue(), this.cpa.getInitialState(location, StateSpacePartition.getDefaultPartition()));
    }

    public Precision getInitialPrecision(CFANode location) throws InterruptedException {
        return this.cpa.getInitialPrecision(location, StateSpacePartition.getDefaultPartition());
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        try {
            this.unwind(pReachedSet);
        }
        catch (SolverException e) {
            throw new CPAException("Solver Failure", e);
        }
        pReachedSet.popFromWaitlist();
        return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
    private void expand(Vertex v, ReachedSet reached) throws CPAException, InterruptedException {
        this.expandTime.start();
        try {
            assert (v.isLeaf() && !v.isCovered());
            AbstractState predecessor = v.getWrappedState();
            Precision precision = reached.getPrecision(v);
            CFANode loc = AbstractStates.extractLocation(v);
            for (CFAEdge edge : CFAUtils.leavingEdges(loc)) {
                Collection<? extends AbstractState> successors = this.cpa.getTransferRelation().getAbstractSuccessorsForEdge(predecessor, precision, edge);
                if (successors.isEmpty()) {
                    Vertex fake = new Vertex(this.bfmgr, v, this.bfmgr.makeFalse(), null);
                    continue;
                }
                assert (successors.size() == 1);
                Vertex w = new Vertex(this.bfmgr, v, this.bfmgr.makeTrue(), (AbstractState)Iterables.getOnlyElement(successors));
                reached.add(w, precision);
                reached.popFromWaitlist();
            }
        }
        finally {
            this.expandTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Vertex> refine(Vertex v) throws CPAException, SolverException, InterruptedException {
        this.refinementTime.start();
        try {
            assert (v.isTarget() && !this.bfmgr.isFalse(v.getStateFormula()));
            this.logger.log(Level.FINER, new Object[]{"Refinement on " + v});
            List<Vertex> path = this.getPathFromRootTo(v);
            path = path.subList(1, path.size());
            ArrayList<BooleanFormula> pathFormulas = new ArrayList<BooleanFormula>(path.size());
            this.addPathFormulasToList(path, pathFormulas);
            Optional<ImmutableList<BooleanFormula>> interpolants = this.imgr.interpolate(pathFormulas);
            if (interpolants.isEmpty()) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            this.logger.log(Level.FINER, new Object[]{"Refinement successful"});
            path = path.subList(0, path.size() - 1);
            assert (interpolants.orElseThrow().size() == path.size());
            ImmutableList.Builder changedElements = ImmutableList.builder();
            for (Pair interpolationPoint : Pair.zipList((Collection)interpolants.orElseThrow(), path)) {
                BooleanFormula itp = (BooleanFormula)interpolationPoint.getFirst();
                Vertex w = interpolationPoint.getSecond();
                if (this.bfmgr.isTrue(itp)) continue;
                itp = this.fmgr.uninstantiate(itp);
                BooleanFormula stateFormula = w.getStateFormula();
                if (this.solver.implies(stateFormula, itp)) continue;
                w.setStateFormula(this.bfmgr.and(stateFormula, itp));
                w.cleanCoverage();
                changedElements.add((Object)w);
            }
            if (!this.bfmgr.isFalse(v.getStateFormula())) {
                v.setStateFormula(this.bfmgr.makeFalse());
                v.cleanCoverage();
                changedElements.add((Object)v);
            }
            ImmutableList immutableList = changedElements.build();
            return immutableList;
        }
        finally {
            this.refinementTime.stop();
        }
    }

    private boolean mayCover(Vertex v, Vertex w, Precision prec) throws CPAException, InterruptedException {
        return v != w && !w.isCovered() && w.isOlderThan(v) && !v.isAncestorOf(w) && this.cpa.getStopOperator().stop(v.getWrappedState(), Collections.singleton(w.getWrappedState()), prec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cover(Vertex v, Vertex w, Precision prec) throws CPAException, InterruptedException, SolverException {
        this.coverTime.start();
        try {
            assert (!v.isCovered());
            if (this.mayCover(v, w, prec) && this.solver.implies(v.getStateFormula(), w.getStateFormula())) {
                for (Vertex y : v.getSubtree()) {
                    y.cleanCoverage();
                }
                v.setCoveredBy(w);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.coverTime.stop();
        }
    }

    private boolean forceCover(Vertex v, Vertex w, Precision prec) throws CPAException, InterruptedException, SolverException {
        List<Vertex> path = new ArrayList<Vertex>();
        Vertex x = v;
        HashSet<Vertex> parentsOfW = new HashSet<Vertex>(this.getPathFromRootTo(w));
        while (!parentsOfW.contains(x)) {
            path.add(x);
            assert (x.hasParent());
            x = x.getParent();
        }
        path = Lists.reverse(path);
        ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>(path.size() + 2);
        PathFormula pf = this.pfmgr.makeEmptyPathFormula();
        formulas.add(this.fmgr.instantiate(x.getStateFormula(), SSAMap.emptySSAMap().withDefault(1)));
        for (Vertex vertex : path) {
            pf = this.pfmgr.makeAnd(pf, vertex.getIncomingEdge());
            formulas.add(pf.getFormula());
            pf = this.pfmgr.makeEmptyPathFormulaWithContextFrom(pf);
        }
        formulas.add(this.bfmgr.not(this.fmgr.instantiate(w.getStateFormula(), pf.getSsa().withDefault(1))));
        path.add(0, x);
        assert (formulas.size() == path.size() + 1);
        Optional<ImmutableList<BooleanFormula>> interpolantInfo = this.imgr.interpolate(formulas);
        if (interpolantInfo.isEmpty()) {
            this.logger.log(Level.FINER, new Object[]{"Forced covering unsuccessful."});
            return false;
        }
        ++this.successfulForcedCovering;
        this.logger.log(Level.FINER, new Object[]{"Forced covering successful."});
        List interpolants = (List)interpolantInfo.orElseThrow();
        assert (interpolants.size() == formulas.size() - 1);
        assert (interpolants.size() == path.size());
        for (Pair pair : Pair.zipList(interpolants, path)) {
            BooleanFormula itp = (BooleanFormula)pair.getFirst();
            Vertex p = (Vertex)pair.getSecond();
            if (this.bfmgr.isTrue(itp)) continue;
            itp = this.fmgr.uninstantiate(itp);
            BooleanFormula stateFormula = p.getStateFormula();
            if (this.solver.implies(stateFormula, itp)) continue;
            p.setStateFormula(this.bfmgr.and(stateFormula, itp));
            p.cleanCoverage();
        }
        boolean bl = this.cover(v, w, prec);
        assert (bl);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close(Vertex v, ReachedSet reached) throws CPAException, InterruptedException, SolverException {
        this.closeTime.start();
        try {
            if (v.isCovered()) {
                boolean bl = true;
                return bl;
            }
            Precision prec = reached.getPrecision(v);
            for (AbstractState ae : reached.getReached(v)) {
                Vertex w = (Vertex)ae;
                if (!this.cover(v, w, prec)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dfs(Vertex pVertex, ReachedSet reached) throws CPAException, InterruptedException, SolverException {
        ArrayDeque<Vertex> stack = new ArrayDeque<Vertex>();
        stack.push(pVertex);
        while (!stack.isEmpty()) {
            Vertex v = (Vertex)stack.pop();
            if (this.close(v, reached)) {
                return true;
            }
            if (v.isTarget()) {
                List<Vertex> changedElements = this.refine(v);
                if (changedElements.isEmpty()) {
                    return false;
                }
                for (Vertex w : changedElements) {
                    if (this.close(w, reached)) break;
                }
                assert (this.bfmgr.isFalse(v.getStateFormula()));
                return true;
            }
            if (!v.isLeaf()) {
                return true;
            }
            if (this.useForcedCovering) {
                this.forceCoverTime.start();
                try {
                    Precision prec = reached.getPrecision(v);
                    for (AbstractState ae : reached.getReached(v)) {
                        Vertex w = (Vertex)ae;
                        if (!this.mayCover(v, w, prec) || !this.forceCover(v, w, prec)) continue;
                        assert (v.isCovered());
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    this.forceCoverTime.stop();
                }
            }
            this.expand(v, reached);
            for (Vertex w : v.getChildren()) {
                if (this.bfmgr.isFalse(w.getStateFormula())) continue;
                stack.push(w);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void unwind(ReachedSet reached) throws CPAException, InterruptedException, SolverException {
        block0: while (true) {
            AbstractState ae;
            Vertex v;
            Iterator<AbstractState> iterator = reached.iterator();
            do {
                if (!iterator.hasNext()) return;
            } while (!(v = (Vertex)(ae = iterator.next())).isLeaf() || v.isCovered());
            List<Vertex> path = this.getPathFromRootTo(v);
            path = path.subList(0, path.size() - 1);
            for (Vertex w : path) {
                if (!this.close(w, reached)) continue;
                continue block0;
            }
            if (!this.dfs(v, reached)) break;
        }
        this.logger.log(Level.INFO, new Object[]{"Bug found"});
    }

    private void addPathFormulasToList(List<Vertex> path, List<BooleanFormula> pathFormulas) throws CPATransferException, InterruptedException {
        PathFormula pf = this.pfmgr.makeEmptyPathFormula();
        for (Vertex w : path) {
            pf = this.pfmgr.makeAnd(pf, w.getIncomingEdge());
            pathFormulas.add(pf.getFormula());
            pf = this.pfmgr.makeEmptyPathFormulaWithContextFrom(pf);
        }
    }

    private List<Vertex> getPathFromRootTo(Vertex v) {
        ArrayList<Vertex> path = new ArrayList<Vertex>();
        Vertex w = v;
        while (w.hasParent()) {
            path.add(w);
            w = w.getParent();
        }
        path.add(w);
        return Lists.reverse(path);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Stats());
    }

    private class Stats
    implements Statistics {
        private Stats() {
        }

        @Override
        public String getName() {
            return "Impact Algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("Time for expand:                    " + ImpactAlgorithm.this.expandTime);
            if (ImpactAlgorithm.this.useForcedCovering) {
                out.println("  Time for forced covering:         " + ImpactAlgorithm.this.forceCoverTime);
            }
            out.println("Time for refinement:                " + ImpactAlgorithm.this.refinementTime);
            out.println("Time for close:                     " + ImpactAlgorithm.this.closeTime);
            out.println("  Time for cover:                   " + ImpactAlgorithm.this.coverTime);
            out.println("Time spent by solver for reasoning: " + ImpactAlgorithm.this.solver.solverTime);
            out.println();
            out.println("Number of SMT sat checks:           " + ImpactAlgorithm.this.solver.satChecks);
            out.println("  trivial:                          " + ImpactAlgorithm.this.solver.trivialSatChecks);
            out.println("  cached:                           " + ImpactAlgorithm.this.solver.cachedSatChecks);
            out.println("Number of refinements:              " + ImpactAlgorithm.this.refinementTime.getNumberOfIntervals());
            if (ImpactAlgorithm.this.useForcedCovering) {
                out.println("Number of forced coverings:         " + ImpactAlgorithm.this.forceCoverTime.getNumberOfIntervals());
                out.println("  Successful:                       " + ImpactAlgorithm.this.successfulForcedCovering);
            }
        }
    }
}

