/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.invariants;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.LazyFutureTask;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.invariants.AbstractInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.predicates.invariants.ExpressionTreeInvariantSupplier;
import org.sosy_lab.cpachecker.util.predicates.invariants.FormulaInvariantsSupplier;

@Options(prefix="invariantGeneration")
public class CPAInvariantGenerator
extends AbstractInvariantGenerator
implements StatisticsProvider {
    @Option(secure=true, name="config", required=true, description="configuration file for invariant generation")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path configFile;
    private final CPAInvariantGeneratorStatistics stats;
    private final LogManager logger;
    private final CPAAlgorithm algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final ReachedSetFactory reachedSetFactory;
    private final CFA cfa;
    private final ShutdownManager shutdownManager;
    private final int iteration;
    private Future<AggregatedReachedSets> invariantGenerationFuture = null;
    private volatile boolean programIsSafe = false;
    private final ShutdownNotifier.ShutdownRequestListener shutdownListener = new ShutdownNotifier.ShutdownRequestListener(){

        public void shutdownRequested(String pReason) {
            if (!CPAInvariantGenerator.this.invariantGenerationFuture.isDone() && !CPAInvariantGenerator.this.programIsSafe) {
                CPAInvariantGenerator.this.invariantGenerationFuture.cancel(true);
            }
        }
    };
    private Optional<ShutdownManager> shutdownOnSafeNotifier;

    public static InvariantGenerator create(Configuration pConfig, LogManager pLogger, ShutdownManager pShutdownManager, Optional<ShutdownManager> pShutdownOnSafeManager, CFA pCFA, Specification specification, List<Automaton> additionalAutomata) throws InvalidConfigurationException, CPAException, InterruptedException {
        ShutdownManager childShutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)pShutdownManager.getNotifier());
        return new CPAInvariantGenerator(pConfig, pLogger.withComponentName("CPAInvariantGenerator"), childShutdownManager, pShutdownOnSafeManager, 1, pCFA, specification, additionalAutomata);
    }

    private CPAInvariantGenerator(Configuration config, LogManager pLogger, ShutdownManager pShutdownManager, Optional<ShutdownManager> pShutdownOnSafeManager, int pIteration, CFA pCFA, Specification pSpecification, List<Automaton> pAdditionalAutomata) throws InvalidConfigurationException, CPAException, InterruptedException {
        Configuration invariantConfig;
        config.inject((Object)this);
        this.stats = new CPAInvariantGeneratorStatistics();
        this.logger = pLogger;
        this.shutdownManager = pShutdownManager;
        this.shutdownOnSafeNotifier = pShutdownOnSafeManager;
        this.iteration = pIteration;
        try {
            invariantConfig = Configuration.builder().loadFromFile(this.configFile).build();
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("could not read configuration file for invariant generation: " + e.getMessage(), (Throwable)e);
        }
        this.reachedSetFactory = new ReachedSetFactory(invariantConfig, this.logger);
        this.cfa = pCFA;
        this.cpa = new CPABuilder(invariantConfig, this.logger, this.shutdownManager.getNotifier(), this.reachedSetFactory).buildCPAs(this.cfa, pSpecification, pAdditionalAutomata, AggregatedReachedSets.empty());
        this.algorithm = CPAAlgorithm.create(this.cpa, this.logger, invariantConfig, this.shutdownManager.getNotifier());
    }

    private CPAInvariantGenerator(Configuration config, LogManager pLogger, ShutdownManager pShutdownManager, Optional<ShutdownManager> pShutdownOnSafeManager, int pIteration, CFA pCFA, ReachedSetFactory pReachedSetFactory, ConfigurableProgramAnalysis pCPA, CPAAlgorithm pAlgorithm, CPAInvariantGeneratorStatistics pStats) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.shutdownManager = pShutdownManager;
        this.shutdownOnSafeNotifier = pShutdownOnSafeManager;
        this.iteration = pIteration;
        this.reachedSetFactory = pReachedSetFactory;
        this.cfa = pCFA;
        this.cpa = pCPA;
        this.algorithm = pAlgorithm;
        this.stats = pStats;
    }

    @Override
    protected void startImpl(CFANode initialLocation) {
        Preconditions.checkState((this.invariantGenerationFuture == null ? 1 : 0) != 0);
        InvariantGenerationTask task = new InvariantGenerationTask(initialLocation);
        this.invariantGenerationFuture = new LazyFutureTask((Callable)task);
        this.shutdownManager.getNotifier().registerAndCheckImmediately(this.shutdownListener);
    }

    @Override
    public void cancel() {
        Preconditions.checkState((this.invariantGenerationFuture != null ? 1 : 0) != 0);
        this.shutdownManager.requestShutdown("Invariant generation cancel requested.");
    }

    private AggregatedReachedSets getAggregatedReachedSets() throws CPAException, InterruptedException {
        try {
            return this.invariantGenerationFuture.get();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), CPAException.class, InterruptedException.class);
            throw new Classes.UnexpectedCheckedException("invariant generation", e.getCause());
        }
        catch (CancellationException e) {
            this.shutdownManager.getNotifier().shutdownIfNecessary();
            throw e;
        }
    }

    @Override
    public InvariantSupplier getSupplier() throws CPAException, InterruptedException {
        return new FormulaInvariantsSupplier(this.getAggregatedReachedSets());
    }

    @Override
    public ExpressionTreeSupplier getExpressionTreeSupplier() throws CPAException, InterruptedException {
        return new ExpressionTreeInvariantSupplier(this.getAggregatedReachedSets(), this.cfa);
    }

    @Override
    public boolean isProgramSafe() {
        return this.programIsSafe;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.cpa instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.cpa)).collectStatistics(pStatsCollection);
        }
        this.algorithm.collectStatistics(pStatsCollection);
        pStatsCollection.add(this.stats);
    }

    private static boolean hasAssumption(AbstractState state) {
        AssumptionStorageState assumption = AbstractStates.extractStateByType(state, AssumptionStorageState.class);
        return assumption != null && !assumption.isStopFormulaTrue() && !assumption.isAssumptionTrue();
    }

    private class InvariantGenerationTask
    implements Callable<AggregatedReachedSets> {
        private static final String SAFE_MESSAGE = "Invariant generation with abstract interpretation proved specification to hold.";
        private final CFANode initialLocation;

        private InvariantGenerationTask(CFANode pInitialLocation) {
            this.initialLocation = (CFANode)Preconditions.checkNotNull((Object)pInitialLocation);
        }

        @Override
        public AggregatedReachedSets call() throws Exception {
            CPAInvariantGenerator.this.stats.invariantGeneration.start();
            try {
                CPAInvariantGenerator.this.shutdownManager.getNotifier().shutdownIfNecessary();
                CPAInvariantGenerator.this.logger.log(Level.INFO, new Object[]{"Starting iteration", CPAInvariantGenerator.this.iteration, "of invariant generation with abstract interpretation."});
                AggregatedReachedSets aggregatedReachedSets = this.runInvariantGeneration(this.initialLocation);
                return aggregatedReachedSets;
            }
            finally {
                CPAInvariantGenerator.this.stats.invariantGeneration.stop();
            }
        }

        private AggregatedReachedSets runInvariantGeneration(CFANode pInitialLocation) throws CPAException, InterruptedException {
            ReachedSet taskReached = CPAInvariantGenerator.this.reachedSetFactory.createAndInitialize(CPAInvariantGenerator.this.cpa, pInitialLocation, StateSpacePartition.getDefaultPartition());
            while (taskReached.hasWaitingState()) {
                if (CPAInvariantGenerator.this.algorithm.run(taskReached).isSound()) continue;
                return AggregatedReachedSets.empty();
            }
            if (!taskReached.wasTargetReached() && !FluentIterable.from((Iterable)taskReached).anyMatch(x$0 -> CPAInvariantGenerator.hasAssumption(x$0))) {
                CPAInvariantGenerator.this.logger.log(Level.INFO, new Object[]{SAFE_MESSAGE});
                CPAInvariantGenerator.this.programIsSafe = true;
                if (CPAInvariantGenerator.this.shutdownOnSafeNotifier.isPresent()) {
                    CPAInvariantGenerator.this.shutdownOnSafeNotifier.orElseThrow().requestShutdown(SAFE_MESSAGE);
                }
            }
            Preconditions.checkState((!taskReached.hasWaitingState() ? 1 : 0) != 0);
            Preconditions.checkState((!taskReached.isEmpty() ? 1 : 0) != 0);
            return AggregatedReachedSets.singleton(taskReached);
        }
    }

    public static class CPAInvariantGeneratorStatistics
    implements Statistics {
        private final Timer invariantGeneration = new Timer();

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            if (this.invariantGeneration.getNumberOfIntervals() > 0) {
                out.println("Time for invariant generation:   " + this.invariantGeneration.getSumTime());
            }
        }

        public TimeSpan getConsumedTime() {
            return this.invariantGeneration.getSumTime();
        }

        @Override
        public String getName() {
            return "CPA-based invariant generator";
        }
    }
}

