/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.invariants;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.KInductionInvariantGenerator;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;

@Options(prefix="invariantChecker")
public class KInductionInvariantChecker {
    @Option(secure=true, description="Configuration file for the K-Induction algorithm for checking candidates on invariance.")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private Path kInductionConfig = Classes.getCodeLocation(KInductionInvariantChecker.class).resolveSibling("config/bmc-invgen.properties");
    private final CFA cfa;
    private final KInductionInvariantGenerator invGen;
    private boolean isComputationFinished = false;

    public KInductionInvariantChecker(Configuration pConfig, ShutdownNotifier pShutdownNotifier, LogManager pLogger, CFA pCfa, Specification specification, CandidateGenerator pCandidateGenerator) throws InvalidConfigurationException, CPAException, InterruptedException {
        Configuration invariantConfig;
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        try {
            Thread.interrupted();
            invariantConfig = Configuration.builder().loadFromFile(this.kInductionConfig).build();
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Could not read configuration file for invariant generation: " + e.getMessage(), (Throwable)e);
        }
        ReachedSetFactory reached = new ReachedSetFactory(pConfig, pLogger);
        this.invGen = KInductionInvariantGenerator.create(invariantConfig, pLogger, ShutdownManager.createWithParent((ShutdownNotifier)pShutdownNotifier), this.cfa, specification, reached, pCandidateGenerator, false);
    }

    public boolean isProgramSafe() {
        Preconditions.checkState((boolean)this.isComputationFinished);
        return this.invGen.isProgramSafe();
    }

    public void checkCandidates() throws CPAException, InterruptedException {
        Preconditions.checkState((!this.isComputationFinished ? 1 : 0) != 0);
        this.invGen.start(this.cfa.getMainFunction());
        this.invGen.getSupplier();
        this.isComputationFinished = true;
    }
}

