/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.invariants;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.LazyFutureTask;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.ParallelAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCAlgorithmForInvariantGeneration;
import org.sosy_lab.cpachecker.core.algorithm.bmc.BMCStatistics;
import org.sosy_lab.cpachecker.core.algorithm.bmc.CandidateGenerator;
import org.sosy_lab.cpachecker.core.algorithm.bmc.StaticCandidateProvider;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.CandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.EdgeFormulaNegation;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.ExpressionTreeLocationInvariant;
import org.sosy_lab.cpachecker.core.algorithm.bmc.candidateinvariants.TargetLocationCandidateInvariant;
import org.sosy_lab.cpachecker.core.algorithm.invariants.AbstractInvariantGenerator;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.InvariantSupplier;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.ExpressionSubstitution;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.WitnessInvariantsExtractor;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;
import org.sosy_lab.cpachecker.util.variableclassification.Partition;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;
import org.sosy_lab.java_smt.api.SolverException;

public class KInductionInvariantGenerator
extends AbstractInvariantGenerator
implements StatisticsProvider,
ParallelAlgorithm.ConditionAdjustmentEventSubscriber {
    private final KInductionInvariantGeneratorStatistics stats = new KInductionInvariantGeneratorStatistics();
    private final BMCAlgorithmForInvariantGeneration algorithm;
    private final ConfigurableProgramAnalysis cpa;
    private final ReachedSetFactory reachedSetFactory;
    private final LogManager logger;
    private final ShutdownManager shutdownManager;
    private final boolean async;
    private Future<Pair<InvariantSupplier, ExpressionTreeSupplier>> invariantGenerationFuture = null;
    private final ShutdownNotifier.ShutdownRequestListener shutdownListener = new ShutdownNotifier.ShutdownRequestListener(){

        public void shutdownRequested(String pReason) {
            KInductionInvariantGenerator.this.invariantGenerationFuture.cancel(true);
        }
    };
    private final AtomicBoolean cancelled = new AtomicBoolean();

    public static KInductionInvariantGenerator create(Configuration pConfig, LogManager pLogger, ShutdownManager pShutdownManager, CFA pCFA, Specification specification, ReachedSetFactory pReachedSetFactory, TargetLocationProvider pTargetLocationProvider, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        KInductionInvariantGeneratorOptions options = new KInductionInvariantGeneratorOptions();
        pConfig.inject((Object)options);
        return new KInductionInvariantGenerator(pConfig, pLogger.withComponentName("KInductionInvariantGenerator"), pShutdownManager, pCFA, specification, pReachedSetFactory, options.async, KInductionInvariantGenerator.getCandidateInvariants(options, pConfig, pLogger, pCFA, pShutdownManager, pTargetLocationProvider, specification), pAggregatedReachedSets);
    }

    static KInductionInvariantGenerator create(Configuration pConfig, LogManager pLogger, ShutdownManager pShutdownManager, CFA pCFA, Specification specification, ReachedSetFactory pReachedSetFactory, CandidateGenerator candidateGenerator, boolean pAsync) throws InvalidConfigurationException, CPAException, InterruptedException {
        return new KInductionInvariantGenerator(pConfig, pLogger.withComponentName("KInductionInvariantGenerator"), pShutdownManager, pCFA, specification, pReachedSetFactory, pAsync, candidateGenerator, AggregatedReachedSets.empty());
    }

    private KInductionInvariantGenerator(Configuration config, LogManager pLogger, ShutdownManager pShutdownNotifier, CFA cfa, Specification specification, ReachedSetFactory pReachedSetFactory, boolean pAsync, final CandidateGenerator pCandidateGenerator, AggregatedReachedSets pAggregatedReachedSets) throws InvalidConfigurationException, CPAException, InterruptedException {
        this.logger = pLogger;
        this.shutdownManager = pShutdownNotifier;
        this.reachedSetFactory = pReachedSetFactory;
        this.async = pAsync;
        if (pCandidateGenerator instanceof StaticCandidateProvider) {
            StaticCandidateProvider staticCandidateProvider = (StaticCandidateProvider)pCandidateGenerator;
            this.stats.totalNumberOfCandidates = FluentIterable.from(staticCandidateProvider.getAllCandidates()).filter(Predicates.not((Predicate)Predicates.instanceOf(TargetLocationCandidateInvariant.class))).size();
        }
        CandidateGenerator statisticsCandidateGenerator = new CandidateGenerator(){
            private final Set<CandidateInvariant> confirmedCandidates = new HashSet<CandidateInvariant>();

            @Override
            public boolean produceMoreCandidates() {
                return pCandidateGenerator.produceMoreCandidates();
            }

            @Override
            public Iterator<CandidateInvariant> iterator() {
                final Iterator<CandidateInvariant> it = pCandidateGenerator.iterator();
                return new Iterator<CandidateInvariant>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public CandidateInvariant next() {
                        return (CandidateInvariant)it.next();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public boolean hasCandidatesAvailable() {
                return pCandidateGenerator.hasCandidatesAvailable();
            }

            @Override
            public Set<? extends CandidateInvariant> getConfirmedCandidates() {
                return pCandidateGenerator.getConfirmedCandidates();
            }

            @Override
            public void confirmCandidates(Iterable<CandidateInvariant> pCandidates) {
                pCandidateGenerator.confirmCandidates(pCandidates);
                for (CandidateInvariant invariant : pCandidates) {
                    if (invariant instanceof TargetLocationCandidateInvariant || !this.confirmedCandidates.add(invariant)) continue;
                    ++KInductionInvariantGenerator.this.stats.numberOfConfirmedCandidates;
                }
            }
        };
        ShutdownManager childShutdown = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownManager.getNotifier());
        ResourceLimitChecker.fromConfiguration(config, this.logger, childShutdown).start();
        CPABuilder invGenBMCBuilder = new CPABuilder(config, this.logger, childShutdown.getNotifier(), pReachedSetFactory);
        this.cpa = invGenBMCBuilder.buildCPAs(cfa, specification, pAggregatedReachedSets);
        CPAAlgorithm cpaAlgorithm = CPAAlgorithm.create(this.cpa, this.logger, config, childShutdown.getNotifier());
        this.algorithm = new BMCAlgorithmForInvariantGeneration((Algorithm)cpaAlgorithm, this.cpa, config, this.logger, pReachedSetFactory, this.shutdownManager, cfa, specification, (BMCStatistics)this.stats, statisticsCandidateGenerator, pAggregatedReachedSets);
    }

    @Override
    protected void startImpl(CFANode initialLocation) {
        Preconditions.checkState((this.invariantGenerationFuture == null ? 1 : 0) != 0);
        InvariantGenerationTask task = new InvariantGenerationTask(initialLocation);
        if (this.async) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            this.invariantGenerationFuture = executor.submit(task);
            executor.shutdown();
        } else {
            this.invariantGenerationFuture = new LazyFutureTask((Callable)task);
        }
        this.shutdownManager.getNotifier().registerAndCheckImmediately(this.shutdownListener);
    }

    @Override
    public void cancel() {
        Preconditions.checkState((this.invariantGenerationFuture != null ? 1 : 0) != 0);
        this.shutdownManager.requestShutdown("Invariant generation cancel requested.");
        this.cancelled.set(true);
    }

    @Override
    public InvariantSupplier getSupplier() throws InterruptedException, CPAException {
        Preconditions.checkState((this.invariantGenerationFuture != null ? 1 : 0) != 0);
        if (this.async && !this.invariantGenerationFuture.isDone() || this.cancelled.get()) {
            return this.algorithm.getCurrentInvariants();
        }
        try {
            return this.invariantGenerationFuture.get().getFirst();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), CPAException.class, InterruptedException.class);
            throw new Classes.UnexpectedCheckedException("invariant generation", e.getCause());
        }
        catch (CancellationException e) {
            this.shutdownManager.getNotifier().shutdownIfNecessary();
            throw e;
        }
    }

    @Override
    public ExpressionTreeSupplier getExpressionTreeSupplier() throws InterruptedException, CPAException {
        Preconditions.checkState((this.invariantGenerationFuture != null ? 1 : 0) != 0);
        if (this.async && !this.invariantGenerationFuture.isDone() || this.cancelled.get()) {
            return this.algorithm.getCurrentInvariantsAsExpressionTree();
        }
        try {
            return this.invariantGenerationFuture.get().getSecond();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), CPAException.class, InterruptedException.class);
            throw new Classes.UnexpectedCheckedException("invariant generation", e.getCause());
        }
        catch (CancellationException e) {
            this.shutdownManager.getNotifier().shutdownIfNecessary();
            throw e;
        }
    }

    @Override
    public boolean isProgramSafe() {
        return this.algorithm.isProgramSafe();
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.algorithm.collectStatistics((Collection)pStatsCollection);
        pStatsCollection.add(this.stats);
    }

    public static CandidateGenerator getCandidateInvariants(KInductionInvariantGeneratorOptions pOptions, Configuration pConfig, LogManager pLogger, CFA pCFA, ShutdownManager pShutdownManager, TargetLocationProvider pTargetLocationProvider, Specification pSpecification) throws InvalidConfigurationException, CPAException, InterruptedException {
        LinkedHashSet<CandidateInvariant> candidates = new LinkedHashSet<CandidateInvariant>();
        Iterables.addAll(candidates, pOptions.guessCandidatesFromCFA.create(pCFA, pSpecification, pTargetLocationProvider, pLogger));
        HashMultimap candidateGroupLocations = HashMultimap.create();
        if (pOptions.invariantsAutomatonFile != null) {
            WitnessInvariantsExtractor extractor = new WitnessInvariantsExtractor(pConfig, pLogger, pCFA, pShutdownManager.getNotifier(), pOptions.invariantsAutomatonFile);
            extractor.extractCandidatesFromReachedSet(candidates, (Multimap<String, CFANode>)candidateGroupLocations);
        }
        candidates.add(TargetLocationCandidateInvariant.INSTANCE);
        if (pOptions.terminateOnCounterexample) {
            return new StaticCandidateProvider(candidates, (Multimap)candidateGroupLocations, pShutdownManager){
                private boolean safetyPropertyConfirmed;
                final /* synthetic */ Multimap val$candidateGroupLocations;
                final /* synthetic */ ShutdownManager val$pShutdownManager;
                {
                    this.val$candidateGroupLocations = multimap;
                    this.val$pShutdownManager = shutdownManager;
                    super(pCandidates);
                    this.safetyPropertyConfirmed = false;
                }

                @Override
                public Iterator<CandidateInvariant> iterator() {
                    final Iterator<CandidateInvariant> iterator = super.iterator();
                    return new Iterator<CandidateInvariant>(){
                        private CandidateInvariant candidate;

                        @Override
                        public boolean hasNext() {
                            return !safetyPropertyConfirmed && iterator.hasNext();
                        }

                        @Override
                        public CandidateInvariant next() {
                            if (safetyPropertyConfirmed) {
                                throw new NoSuchElementException("No more candidates available: The safety property has already been confirmed.");
                            }
                            this.candidate = (CandidateInvariant)iterator.next();
                            return this.candidate;
                        }

                        @Override
                        public void remove() {
                            if (this.candidate instanceof ExpressionTreeLocationInvariant) {
                                ExpressionTreeLocationInvariant expressionTreeLocationInvariant = (ExpressionTreeLocationInvariant)this.candidate;
                                String groupId = expressionTreeLocationInvariant.getGroupId();
                                Collection remainingLocations = val$candidateGroupLocations.get((Object)groupId);
                                remainingLocations.remove(expressionTreeLocationInvariant.getLocation());
                                if (remainingLocations.isEmpty()) {
                                    val$pShutdownManager.requestShutdown("Incorrect invariant: " + this.candidate);
                                }
                            }
                            iterator.remove();
                        }
                    };
                }

                @Override
                public void confirmCandidates(Iterable<CandidateInvariant> pCandidates) {
                    super.confirmCandidates(pCandidates);
                    if (Iterables.contains(pCandidates, (Object)TargetLocationCandidateInvariant.INSTANCE)) {
                        this.safetyPropertyConfirmed = true;
                    }
                }
            };
        }
        return new StaticCandidateProvider(candidates);
    }

    private static Set<AssumeEdge> getRelevantAssumeEdges(Collection<CFANode> pTargetLocations) {
        LinkedHashSet<AssumeEdge> assumeEdges = new LinkedHashSet<AssumeEdge>();
        HashSet<CFANode> visited = new HashSet<CFANode>(pTargetLocations);
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>(pTargetLocations);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            for (CFAEdge enteringEdge : CFAUtils.enteringEdges(current)) {
                CFANode predecessor = enteringEdge.getPredecessor();
                if (enteringEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                    assumeEdges.add((AssumeEdge)enteringEdge);
                    continue;
                }
                if (!visited.add(predecessor)) continue;
                waitlist.add(predecessor);
            }
        }
        return assumeEdges;
    }

    @Override
    public void adjustmentSuccessful(ConfigurableProgramAnalysis pCpa) {
        this.algorithm.adjustmentSuccessful(pCpa);
    }

    @Override
    public void adjustmentRefused(ConfigurableProgramAnalysis pCpa) {
        this.algorithm.adjustmentRefused(pCpa);
    }

    private static Iterable<CandidateInvariant> asNegatedCandidateInvariants(Iterable<AssumeEdge> pAssumeEdges, Set<CFANode> pLoopHeads) {
        return FluentIterable.from(pAssumeEdges).transformAndConcat(e -> FluentIterable.from((Iterable)pLoopHeads).transform(n -> new EdgeFormulaNegation((CFANode)n, (AssumeEdge)e)));
    }

    private static enum CfaCandidateInvariantExtractorFactories implements CfaCandidateInvariantExtractorFactory
    {
        NONE{

            @Override
            public Iterable<CandidateInvariant> create(CFA pCfa, Specification pSpecification, TargetLocationProvider pTargetLocationProvider, LogManager pLogger) {
                return ImmutableSet.of();
            }
        }
        ,
        ASSUME_EDGES_PLAIN{

            @Override
            public Iterable<CandidateInvariant> create(CFA pCfa, Specification pSpecification, TargetLocationProvider pTargetLocationProvider, LogManager pLogger) throws InvalidConfigurationException {
                Optional<ImmutableSet<CFANode>> loopHeads = pCfa.getAllLoopHeads();
                if (!loopHeads.isPresent()) {
                    throw new InvalidConfigurationException("Loop structure not available but required to generate candidate invariants.");
                }
                Set<AssumeEdge> assumeEdges = KInductionInvariantGenerator.getRelevantAssumeEdges(pTargetLocationProvider.tryGetAutomatonTargetLocations(pCfa.getMainFunction(), pSpecification));
                return KInductionInvariantGenerator.asNegatedCandidateInvariants(assumeEdges, (Set)loopHeads.orElseThrow());
            }
        }
        ,
        ASSUME_EDGE_TEMPLATES{

            @Override
            public Iterable<CandidateInvariant> create(CFA pCfa, Specification pSpecification, TargetLocationProvider pTargetLocationProvider, LogManager pLogger) throws InvalidConfigurationException {
                if (!pCfa.getVarClassification().isPresent()) {
                    throw new InvalidConfigurationException("Variable classification not available but required to generate candidate invariants.");
                }
                Optional<ImmutableSet<CFANode>> loopHeads = pCfa.getAllLoopHeads();
                if (!loopHeads.isPresent()) {
                    throw new InvalidConfigurationException("Loop structure not available but required to generate candidate invariants.");
                }
                Set<AssumeEdge> baseAssumeEdges = KInductionInvariantGenerator.getRelevantAssumeEdges(pTargetLocationProvider.tryGetAutomatonTargetLocations(pCfa.getMainFunction(), pSpecification));
                LinkedHashMultimap idsOnEdges = LinkedHashMultimap.create();
                HashMap<String, Object> idExpressions = new HashMap<String, Object>();
                for (AssumeEdge baseAssumeEdge : baseAssumeEdges) {
                    for (Object idExpression : CFAUtils.traverseRecursively(baseAssumeEdge.getExpression()).filter(AIdExpression.class)) {
                        ASimpleDeclaration decl = ((AIdExpression)idExpression).getDeclaration();
                        if (decl == null) continue;
                        if (!(idExpression instanceof CExpression)) {
                            throw new InvalidConfigurationException("Assume-edge templates are only supported for C code.");
                        }
                        idExpressions.put(decl.getQualifiedName(), idExpression);
                        idsOnEdges.put((Object)baseAssumeEdge, (Object)decl.getQualifiedName());
                    }
                }
                VariableClassification varClassification = pCfa.getVarClassification().orElseThrow();
                Equivalence<AssumeEdge> equivalence = new Equivalence<AssumeEdge>(){

                    protected boolean doEquivalent(AssumeEdge pA, AssumeEdge pB) {
                        return pA.getTruthAssumption() == pB.getTruthAssumption() && pA.getExpression().equals(pB.getExpression());
                    }

                    protected int doHash(AssumeEdge pEdge) {
                        return Objects.hash(pEdge.getExpression(), pEdge.getTruthAssumption());
                    }
                };
                LinkedHashSet<Equivalence.Wrapper> assumeEdges = new LinkedHashSet<Equivalence.Wrapper>();
                for (AssumeEdge baseAssumeEdge : baseAssumeEdges) {
                    assumeEdges.add(equivalence.wrap((Object)baseAssumeEdge));
                }
                ArrayDeque<AssumeEdge> waitlist = new ArrayDeque<AssumeEdge>(baseAssumeEdges);
                Set<Partition> partitions = varClassification.getPartitions();
                CBinaryExpressionBuilder binExpBuilder = new CBinaryExpressionBuilder(pCfa.getMachineModel(), pLogger);
                while (!waitlist.isEmpty()) {
                    AssumeEdge edge = (AssumeEdge)waitlist.poll();
                    ArrayList<CAssumeEdge> successors = new ArrayList<CAssumeEdge>();
                    AExpression expression = edge.getExpression();
                    for (String string : idsOnEdges.get((Object)edge)) {
                        Partition partition;
                        Iterator<Partition> iterator;
                        AIdExpression variable = (AIdExpression)idExpressions.get(string);
                        if (variable == null || !(iterator = partitions.iterator()).hasNext() || !(partition = iterator.next()).getVars().contains(string)) continue;
                        for (String s : partition.getVars()) {
                            if (s.equals(string)) continue;
                            AIdExpression substitute = (AIdExpression)idExpressions.get(s);
                            if (substitute == null) {
                                for (CFAEdge e : partition.getEdges().keySet()) {
                                    for (AIdExpression idExpression : FluentIterable.from(CFAUtils.getAstNodesFromCfaEdge(e)).transformAndConcat(CFAUtils::traverseRecursively).filter(AIdExpression.class)) {
                                        ASimpleDeclaration decl = idExpression.getDeclaration();
                                        if (decl == null) continue;
                                        idsOnEdges.put((Object)e, (Object)decl.getQualifiedName());
                                        if (substitute != null || !decl.getQualifiedName().equals(s)) continue;
                                        substitute = idExpression;
                                    }
                                }
                            }
                            if (substitute == null || !this.allowSubstitution(variable, substitute)) continue;
                            try {
                                CExpression newExpression = ExpressionSubstitution.applySubstitution((CExpression)expression, (CExpression)((Object)variable), (CExpression)((Object)substitute), binExpBuilder);
                                Object raw = newExpression.toASTString();
                                if (!edge.getTruthAssumption()) {
                                    raw = "!(" + (String)raw + ")";
                                }
                                CAssumeEdge newEdge = new CAssumeEdge((String)raw, edge.getFileLocation(), edge.getPredecessor(), edge.getSuccessor(), newExpression, edge.getTruthAssumption());
                                successors.add(newEdge);
                            }
                            catch (ExpressionSubstitution.SubstitutionException e) {
                                throw new AssertionError((Object)String.format("Invalid substitution of %s by %s", variable, substitute));
                            }
                        }
                    }
                    for (AssumeEdge assumeEdge : successors) {
                        if (!assumeEdges.add(equivalence.wrap((Object)assumeEdge))) continue;
                        for (AIdExpression idExpression : CFAUtils.traverseRecursively(assumeEdge.getExpression()).filter(AIdExpression.class)) {
                            ASimpleDeclaration decl = idExpression.getDeclaration();
                            if (decl == null) continue;
                            idsOnEdges.put((Object)assumeEdge, (Object)decl.getQualifiedName());
                        }
                        waitlist.add(assumeEdge);
                    }
                }
                return KInductionInvariantGenerator.asNegatedCandidateInvariants((Iterable<AssumeEdge>)FluentIterable.from(assumeEdges).transform(Equivalence.Wrapper::get), (Set)loopHeads.orElseThrow());
            }

            private boolean allowSubstitution(AIdExpression pVariable, AIdExpression pSubstitute) {
                if (pVariable.getExpressionType().equals(pSubstitute.getExpressionType())) {
                    return true;
                }
                if (!(pVariable.getExpressionType() instanceof CType) || !(pSubstitute.getExpressionType() instanceof CType)) {
                    return false;
                }
                CType typeA = ((CType)pVariable.getExpressionType()).getCanonicalType();
                CType typeB = ((CType)pSubstitute.getExpressionType()).getCanonicalType();
                return typeA.canBeAssignedFrom(typeB);
            }
        }
        ,
        LINEAR_TEMPLATES{

            @Override
            public Iterable<CandidateInvariant> create(CFA pCfa, Specification pSpecification, TargetLocationProvider pTargetLocationProvider, LogManager pLogger) throws InvalidConfigurationException {
                if (!pCfa.getVarClassification().isPresent()) {
                    throw new InvalidConfigurationException("Variable classification not available but required to generate candidate invariants.");
                }
                VariableClassification varClassification = pCfa.getVarClassification().orElseThrow();
                Optional<ImmutableSet<CFANode>> loopHeads = pCfa.getAllLoopHeads();
                if (!loopHeads.isPresent()) {
                    throw new InvalidConfigurationException("Loop structure not available but required to generate candidate invariants.");
                }
                MachineModel machineModel = pCfa.getMachineModel();
                ArrayList vars = new ArrayList(Sets.intersection((Set)varClassification.getAssumedVariables().elementSet(), varClassification.getIntAddVars()));
                LinkedHashMap<String, CIdExpression> idExpressions = new LinkedHashMap<String, CIdExpression>();
                TreeSet<BigInteger> constants = new TreeSet<BigInteger>();
                LinkedHashMultimap typePartitions = LinkedHashMultimap.create();
                HashMap<CIdExpression, AFunctionDeclaration> functions = new HashMap<CIdExpression, AFunctionDeclaration>();
                block2: for (String var : vars) {
                    if (idExpressions.containsKey(var)) continue;
                    for (Partition partition : varClassification.getIntAddPartitions()) {
                        if (!partition.getVars().contains(var)) continue;
                        constants.addAll(partition.getValues());
                        for (CFAEdge e : partition.getEdges().keySet()) {
                            for (Object idExpression : FluentIterable.from(CFAUtils.getAstNodesFromCfaEdge(e)).transformAndConcat(CFAUtils::traverseRecursively).filter(AIdExpression.class)) {
                                if (!(idExpression instanceof CIdExpression)) {
                                    throw new InvalidConfigurationException("Linear templates are only supported for C code.");
                                }
                                ASimpleDeclaration decl = ((AIdExpression)idExpression).getDeclaration();
                                if (decl == null) continue;
                                CIdExpression id = (CIdExpression)idExpression;
                                idExpressions.put(decl.getQualifiedName(), id);
                                CType type = id.getExpressionType().getCanonicalType();
                                typePartitions.put((Object)type, (Object)decl.getQualifiedName());
                                functions.put(id, e.getPredecessor().getFunction());
                                if (!(type instanceof CSimpleType)) continue;
                                constants.add(machineModel.getMaximalIntegerValue((CSimpleType)type));
                            }
                        }
                        continue block2;
                    }
                }
                CBinaryExpressionBuilder binExpBuilder = new CBinaryExpressionBuilder(pCfa.getMachineModel(), pLogger);
                LinkedHashMultimap instantiatedTemplates = LinkedHashMultimap.create();
                for (Map.Entry entry : typePartitions.asMap().entrySet()) {
                    CType type = (CType)entry.getKey();
                    if (!(type instanceof CSimpleType)) continue;
                    Collection variables = (Collection)entry.getValue();
                    BigInteger max = machineModel.getMaximalIntegerValue((CSimpleType)type);
                    for (String x : variables) {
                        CIdExpression xId = (CIdExpression)idExpressions.get(x);
                        CSimpleDeclaration xDecl = xId.getDeclaration();
                        if (!(xDecl instanceof CVariableDeclaration)) continue;
                        CVariableDeclaration xVarDecl = (CVariableDeclaration)xDecl;
                        AFunctionDeclaration function = (AFunctionDeclaration)functions.get(xId);
                        for (String y : variables) {
                            if (x.equals(y)) continue;
                            CIdExpression yId = (CIdExpression)idExpressions.get(y);
                            AFunctionDeclaration yFunction = (AFunctionDeclaration)functions.get(yId);
                            if (xVarDecl.isGlobal()) {
                                function = yFunction;
                            } else {
                                CSimpleDeclaration yDecl = yId.getDeclaration();
                                if (!(yDecl instanceof CVariableDeclaration)) continue;
                                CVariableDeclaration yVarDecl = (CVariableDeclaration)yDecl;
                                if (yVarDecl.isGlobal()) {
                                    function = yFunction;
                                } else if (!function.equals(yFunction)) continue;
                            }
                            for (BigInteger c : constants.subSet(BigInteger.ONE, max)) {
                                try {
                                    CIntegerLiteralExpression cLit = new CIntegerLiteralExpression(FileLocation.DUMMY, type, c);
                                    CBinaryExpression cX = binExpBuilder.buildBinaryExpression(xId, cLit, CBinaryExpression.BinaryOperator.MULTIPLY);
                                    CBinaryExpression cXLeqY = binExpBuilder.buildBinaryExpression(cX, yId, CBinaryExpression.BinaryOperator.LESS_EQUAL);
                                    CBinaryExpression cXGeqY = binExpBuilder.buildBinaryExpression(cX, yId, CBinaryExpression.BinaryOperator.GREATER_EQUAL);
                                    instantiatedTemplates.put((Object)function, (Object)cXLeqY);
                                    instantiatedTemplates.put((Object)function, (Object)cXGeqY);
                                }
                                catch (UnrecognizedCodeException e) {
                                    throw new AssertionError((Object)String.format("Invalid template instantiation %s * %s <= %s", c, x, y));
                                }
                            }
                        }
                    }
                }
                ArrayList<AssumeEdge> assumeEdges = new ArrayList<AssumeEdge>();
                for (Map.Entry entry : instantiatedTemplates.asMap().entrySet()) {
                    AFunctionDeclaration function = (AFunctionDeclaration)entry.getKey();
                    Collection expressions = (Collection)entry.getValue();
                    CFANode dummyPred = new CFANode(function);
                    CFANode dummySucc = new CFANode(function);
                    for (CExpression instantiatedTemplate : expressions) {
                        String raw = "!(" + instantiatedTemplate.toASTString() + ")";
                        CAssumeEdge dummyEdge = new CAssumeEdge(raw, FileLocation.DUMMY, dummyPred, dummySucc, instantiatedTemplate, false);
                        assumeEdges.add(dummyEdge);
                    }
                }
                return KInductionInvariantGenerator.asNegatedCandidateInvariants(assumeEdges, (Set)loopHeads.orElseThrow());
            }
        };

    }

    private static interface CfaCandidateInvariantExtractorFactory {
        public Iterable<CandidateInvariant> create(CFA var1, Specification var2, TargetLocationProvider var3, LogManager var4) throws InvalidConfigurationException;
    }

    private class InvariantGenerationTask
    implements Callable<Pair<InvariantSupplier, ExpressionTreeSupplier>> {
        private final CFANode initialLocation;

        private InvariantGenerationTask(CFANode pInitialLocation) {
            this.initialLocation = (CFANode)Preconditions.checkNotNull((Object)pInitialLocation);
        }

        @Override
        public Pair<InvariantSupplier, ExpressionTreeSupplier> call() throws InterruptedException, CPAException {
            KInductionInvariantGenerator.this.stats.invariantGeneration.start();
            KInductionInvariantGenerator.this.shutdownManager.getNotifier().shutdownIfNecessary();
            try {
                ReachedSet reachedSet = KInductionInvariantGenerator.this.reachedSetFactory.createAndInitialize(KInductionInvariantGenerator.this.cpa, this.initialLocation, StateSpacePartition.getDefaultPartition());
                KInductionInvariantGenerator.this.algorithm.run(reachedSet);
                Pair<InvariantSupplier, ExpressionTreeSupplier> pair = Pair.of(KInductionInvariantGenerator.this.algorithm.getCurrentInvariants(), KInductionInvariantGenerator.this.algorithm.getCurrentInvariantsAsExpressionTree());
                return pair;
            }
            catch (SolverException e) {
                throw new CPAException("Solver Failure", e);
            }
            finally {
                KInductionInvariantGenerator.this.stats.invariantGeneration.stop();
                CPAs.closeCpaIfPossible(KInductionInvariantGenerator.this.cpa, KInductionInvariantGenerator.this.logger);
                CPAs.closeIfPossible(KInductionInvariantGenerator.this.algorithm, KInductionInvariantGenerator.this.logger);
            }
        }
    }

    private static class KInductionInvariantGeneratorStatistics
    extends BMCStatistics {
        final Timer invariantGeneration = new Timer();
        private Integer totalNumberOfCandidates = null;
        private int numberOfConfirmedCandidates = 0;

        private KInductionInvariantGeneratorStatistics() {
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
            StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(out);
            writer.put("Time for invariant generation", this.invariantGeneration);
            if (this.totalNumberOfCandidates != null) {
                writer.put("Total number of candidates", this.totalNumberOfCandidates);
            }
            writer.put("Number of confirmed candidates", this.numberOfConfirmedCandidates);
            super.printStatistics(out, result, reached);
        }

        @Override
        public String getName() {
            return "k-Induction-based invariant generator";
        }
    }

    @Options(prefix="invariantGeneration.kInduction")
    public static class KInductionInvariantGeneratorOptions {
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        @Option(secure=true, description="Provides additional candidate invariants to the k-induction invariant generator.")
        private Path invariantsAutomatonFile = null;
        @Option(secure=true, description="Guess some candidates for the k-induction invariant generator from the CFA.")
        private CfaCandidateInvariantExtractorFactories guessCandidatesFromCFA = CfaCandidateInvariantExtractorFactories.ASSUME_EDGES_PLAIN;
        @Option(secure=true, description="For correctness-witness validation: Shut down if a candidate invariant is found to be incorrect.")
        private boolean terminateOnCounterexample = false;
        @Option(secure=true, description="Check candidate invariants in a separate thread asynchronously.")
        private boolean async = true;
    }
}

