/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.invariants;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.LocationMappedReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class LazyLocationMapping {
    private final UnmodifiableReachedSet reachedSet;
    private final AtomicReference<Multimap<CFANode, AbstractState>> statesByLocationRef = new AtomicReference();

    public LazyLocationMapping(UnmodifiableReachedSet pReachedSet) {
        this.reachedSet = Objects.requireNonNull(pReachedSet);
    }

    public Iterable<AbstractState> get(CFANode pLocation, Optional<CallstackStateEqualsWrapper> callstackInformation) {
        Iterable<AbstractState> out = this.get0(pLocation);
        if (!callstackInformation.isPresent()) {
            return out;
        }
        ArrayList<AbstractState> toReturn = new ArrayList<AbstractState>();
        for (AbstractState returned : out) {
            Optional<CallstackStateEqualsWrapper> returnedCallstackInfo = AbstractStates.extractOptionalCallstackWraper(returned);
            if (!returnedCallstackInfo.equals(callstackInformation)) continue;
            toReturn.add(returned);
        }
        return toReturn;
    }

    public Iterable<AbstractState> get0(CFANode pLocation) {
        if (this.reachedSet instanceof LocationMappedReachedSet) {
            return AbstractStates.filterLocation(this.reachedSet, pLocation);
        }
        if (this.statesByLocationRef.get() == null) {
            HashMultimap statesByLocation = HashMultimap.create();
            for (AbstractState state : this.reachedSet) {
                for (CFANode location : AbstractStates.extractLocations(state)) {
                    statesByLocation.put((Object)location, (Object)state);
                }
            }
            this.statesByLocationRef.set((Multimap<CFANode, AbstractState>)statesByLocation);
            return statesByLocation.get((Object)pLocation);
        }
        return this.statesByLocationRef.get().get((Object)pLocation);
    }
}

