/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.invariants;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.invariants.ExpressionTreeSupplier;
import org.sosy_lab.cpachecker.core.algorithm.invariants.LazyLocationMapping;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ExpressionTreeReportingState;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.Or;

public class ReachedSetBasedExpressionTreeSupplier
implements ExpressionTreeSupplier {
    private final LazyLocationMapping lazyLocationMapping;
    private final CFA cfa;

    public ReachedSetBasedExpressionTreeSupplier(LazyLocationMapping pLazyLocationMapping, CFA pCFA) {
        this.lazyLocationMapping = Objects.requireNonNull(pLazyLocationMapping);
        this.cfa = Objects.requireNonNull(pCFA);
    }

    @Override
    public ExpressionTree<Object> getInvariantFor(CFANode pLocation) throws InterruptedException {
        HashSet<InvariantsState> invStates = new HashSet<InvariantsState>();
        boolean otherReportingStates = false;
        Iterable<AbstractState> locationStates = this.lazyLocationMapping.get(pLocation, Optional.empty());
        if (Iterables.isEmpty(locationStates)) {
            return ExpressionTrees.getTrue();
        }
        ArrayList locationInvariants = new ArrayList();
        for (AbstractState locState : locationStates) {
            ExpressionTree<Object> stateInvariant = ExpressionTrees.getTrue();
            for (ExpressionTreeReportingState expressionTreeReportingState : AbstractStates.asIterable(locState).filter(ExpressionTreeReportingState.class)) {
                if (expressionTreeReportingState instanceof InvariantsState) {
                    InvariantsState invState = (InvariantsState)expressionTreeReportingState;
                    boolean skip = false;
                    for (InvariantsState other : invStates) {
                        if (!invState.isLessOrEqual(other)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) {
                        stateInvariant = ExpressionTrees.getFalse();
                        continue;
                    }
                    invStates.add(invState);
                } else {
                    otherReportingStates = true;
                }
                stateInvariant = And.of(stateInvariant, expressionTreeReportingState.getFormulaApproximation(this.cfa.getFunctionHead(pLocation.getFunctionName()), pLocation));
            }
            locationInvariants.add(stateInvariant);
        }
        ExpressionTree<Object> locationInvariant = Or.of(locationInvariants);
        if (!otherReportingStates && invStates.size() > 1) {
            HashSet<InvariantsState> newInvStates = new HashSet<InvariantsState>();
            for (InvariantsState a : invStates) {
                boolean skip = false;
                for (InvariantsState b : invStates) {
                    if (a == b || !a.isLessOrEqual(b)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                newInvStates.add(a);
            }
            if (newInvStates.size() < invStates.size()) {
                locationInvariant = ExpressionTrees.getFalse();
                for (InvariantsState state : newInvStates) {
                    locationInvariant = Or.of(locationInvariant, state.getFormulaApproximation(this.cfa.getFunctionHead(pLocation.getFunctionName()), pLocation));
                }
            }
        }
        return locationInvariant;
    }
}

