/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.mpv.MPVReachedSet;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.Partition;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.PartitioningOperator;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.SeparatePartitioningOperator;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.AbstractSingleProperty;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.MultipleProperties;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;

@Options(prefix="mpv")
public class MPVAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, name="limits.cpuTimePerProperty", description="Set CPU time limit per each property in multi-property verification (use seconds or specify a unit; -1 to disable)")
    @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=-1L)
    private TimeSpan cpuTimePerProperty = TimeSpan.ofNanos((long)-1L);
    @Option(secure=true, name="limits.adjustmentStrategy", description="Adjust resource limitations during the analysis.\n- NONE: do not adjust resource limitations (default).\n- DISTRIBUTE_REMAINING: distribute resources, which were allocated for some already checked property, but were not fully spent, between other properties, which are still checking.\n- DISTRIBUTE_BY_PROPERTY: scale resources for each property in accordance with the given ratio in the property distribution file.")
    private LimitAdjustmentStrategy limitsAdjustmentStrategy = LimitAdjustmentStrategy.NONE;
    @Option(secure=true, name="limits.firstPartitionRatio", description="Change resource limitations for the first partition by the given ratio. This option will be ignored if NONE limits adjustment strategy is used.")
    private double firstPartitionFactor = 1.0;
    @Option(secure=true, name="limits.propertyDistributionFile", description="Get a resource limitation distribution per property from file. This option should be used only together with DISTRIBUTE_BY_PROPERTY limits adjustment strategy. The following format should be used in the file:\n'<property name>':<ratio>")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private @Nullable Path propertyDistributionFile = null;
    private final Map<AbstractSingleProperty, Double> propertyDistribution;
    @Option(secure=true, name="propertySeparator", description="Specifies how to separate a single property.\n- FILE: each .spc file represent a single property (i.e., property is represented by several automata).\n- AUTOMATON: each automaton represent a single property.")
    private MultipleProperties.PropertySeparator propertySeparator = MultipleProperties.PropertySeparator.FILE;
    @Option(secure=true, name="partitionOperator", description="Partitioning operator for multi-property verification.")
    @ClassOption(packagePrefix={"org.sosy_lab.cpachecker.core.algorithm.mpv.partition"})
    private @NonNull PartitioningOperator.Factory partitioningOperatorFactory = (pConfig, pLogger, pShutdownNotifier, pProperties, pCpuTimePerProperty) -> new SeparatePartitioningOperator(pProperties, pCpuTimePerProperty);
    @Option(secure=true, name="findAllViolations", description="Find all violations of each checked property.")
    private boolean findAllViolations = false;
    @Option(secure=true, name="ignoreInnerExceptions", description="Ignore exceptions, which may be caused by checking of some properties, to successfully check the others.")
    private boolean ignoreInnerExceptions = false;
    private final MPVStatistics stats;
    private final ConfigurableProgramAnalysis cpa;
    private final LogManager logger;
    private final Configuration config;
    private final ShutdownNotifier shutdownNotifier;
    private final Specification specification;
    private final CFA cfa;
    private final PartitioningOperator partitioningOperator;
    private final MultipleProperties multipleProperties;

    public MPVAlgorithm(ConfigurableProgramAnalysis pCpa, Configuration pConfig2, LogManager pLogger2, ShutdownNotifier pShutdownNotifier2, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException {
        this.cpa = pCpa;
        this.config = pConfig2;
        this.logger = pLogger2;
        this.shutdownNotifier = pShutdownNotifier2;
        this.specification = pSpecification;
        this.cfa = pCfa;
        this.config.inject((Object)this);
        this.multipleProperties = new MultipleProperties(this.specification.getPathToSpecificationAutomata(), this.propertySeparator, this.findAllViolations);
        this.multipleProperties.determineRelevance(pCfa);
        this.stats = new MPVStatistics();
        this.propertyDistribution = this.initializePropertyDistribution();
        this.partitioningOperator = this.partitioningOperatorFactory.create(this.config, this.logger, this.shutdownNotifier, this.multipleProperties, this.cpuTimePerProperty);
    }

    private Map<AbstractSingleProperty, Double> initializePropertyDistribution() {
        if (this.propertyDistributionFile == null) {
            return ImmutableMap.of();
        }
        try {
            Pattern propertyDistributionPattern = Pattern.compile("'(.+)'\\s*:\\s*(\\S+)");
            List<String> lines = Files.readAllLines(this.propertyDistributionFile, Charset.defaultCharset());
            ImmutableMap.Builder propertyDistributionBuilder = ImmutableMap.builder();
            for (String line : lines) {
                if ((line = line.trim()).isEmpty()) continue;
                Matcher matcher = propertyDistributionPattern.matcher(line);
                if (matcher.matches()) {
                    String propertyName = matcher.group(1);
                    String ratioStr = matcher.group(2);
                    AbstractSingleProperty targetProperty = null;
                    for (AbstractSingleProperty property : this.multipleProperties.getProperties()) {
                        if (!property.getName().equals(propertyName)) continue;
                        targetProperty = property;
                        break;
                    }
                    if (targetProperty == null) {
                        this.logger.log(Level.WARNING, new Object[]{"Property with name '", propertyName, "', specified in property distribution file, does not exist"});
                        continue;
                    }
                    try {
                        Double ratio = Double.parseDouble(ratioStr);
                        propertyDistributionBuilder.put((Object)targetProperty, (Object)ratio);
                    }
                    catch (NumberFormatException e) {
                        this.logger.log(Level.WARNING, new Object[]{"Could not parse ratio '", ratioStr, "' for property", propertyName, e});
                    }
                    continue;
                }
                this.logger.log(Level.WARNING, new Object[]{"Could not parse line '", line, "' in property distribution file. Correct format is '<property name>':<ratio>"});
            }
            return propertyDistributionBuilder.buildOrThrow();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, new Object[]{"Could not read properties distribution from file", this.propertyDistributionFile, e});
            return ImmutableMap.of();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reached) throws CPAException, InterruptedException {
        assert (reached instanceof MPVReachedSet);
        ((MPVReachedSet)reached).setMultipleProperties(this.multipleProperties);
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        this.stats.totalTimer.start();
        Iterable<CFANode> initialNodes = AbstractStates.extractLocations(reached.getFirstState());
        CFANode mainFunction = (CFANode)Iterables.getOnlyElement(initialNodes);
        try {
            do {
                ImmutableList<Partition> partitions = this.partitioningOperator.createPartitions();
                int partitionNumber = 0;
                this.logger.log(Level.FINER, new Object[]{"Using the following partitions of properties:", partitions});
                for (Partition partition : partitions) {
                    int numberOfProperties = partition.getNumberOfProperties();
                    if (numberOfProperties <= 0) continue;
                    this.stats.partitions.add(partition);
                    this.adjustTimeLimit(partition, partitions.size(), partitionNumber);
                    ++partitionNumber;
                    ShutdownManager shutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
                    ResourceLimitChecker limits = ResourceLimitChecker.createCpuTimeLimitChecker(this.logger, shutdownManager, partition.getTimeLimit());
                    limits.start();
                    Algorithm algorithm = this.createInnerAlgorithm(reached, mainFunction, shutdownManager);
                    this.multipleProperties.setTargetProperties(partition.getProperties(), reached);
                    try {
                        partition.startAnalysis();
                        this.logger.log(Level.INFO, new Object[]{"Iteration", this.stats.iterationNumber, ": checking partition", partition, "with", numberOfProperties, "properties"});
                        do {
                            status = status.update(algorithm.run(reached));
                        } while (!partition.isChecked(reached));
                    }
                    catch (InterruptedException e) {
                        if (this.shutdownNotifier.shouldShutdown()) {
                            partition.stopAnalysisOnFailure(reached, "Interrupted");
                            throw e;
                        }
                        this.logger.log(Level.INFO, new Object[]{"Partition has exhausted resource limitations:", e});
                        partition.stopAnalysisOnFailure(reached, "Inner time limit");
                    }
                    catch (CPAException e) {
                        partition.stopAnalysisOnFailure(reached, e.getClass().getSimpleName());
                        if (this.ignoreInnerExceptions) {
                            this.logger.log(Level.INFO, new Object[]{"Exception occured during partition checking:", e});
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        limits.cancel();
                    }
                }
            } while (!this.multipleProperties.isChecked());
        }
        finally {
            this.stats.totalTimer.stop();
        }
        return status;
    }

    private void adjustTimeLimit(Partition partition, int overallPartitions, int currentPartitionNumber) {
        if (this.limitsAdjustmentStrategy.equals((Object)LimitAdjustmentStrategy.NONE)) {
            return;
        }
        if (!partition.isIntermediateStep()) {
            return;
        }
        TimeSpan overallSpentCpuTime = this.stats.getCurrentCpuTime();
        TimeSpan overallCpuTimeLimit = this.cpuTimePerProperty.multiply(this.multipleProperties.getNumberOfProperties());
        if (overallCpuTimeLimit.compareTo(overallSpentCpuTime) <= 0 || overallPartitions <= currentPartitionNumber) {
            return;
        }
        TimeSpan adjustedTimeLimit = this.cpuTimePerProperty;
        switch (this.limitsAdjustmentStrategy) {
            case DISTRIBUTE_REMAINING: {
                adjustedTimeLimit = TimeSpan.difference((TimeSpan)overallCpuTimeLimit, (TimeSpan)overallSpentCpuTime).divide(overallPartitions - currentPartitionNumber);
                break;
            }
            case DISTRIBUTE_BY_PROPERTY: {
                AbstractSingleProperty currentProperty;
                if (partition.getNumberOfProperties() != 1 || !this.propertyDistribution.containsKey(currentProperty = (AbstractSingleProperty)partition.getProperties().getProperties().get(0))) break;
                adjustedTimeLimit = TimeSpan.ofMillis((long)Math.round(this.propertyDistribution.get(currentProperty) * (double)adjustedTimeLimit.asMillis()));
                break;
            }
        }
        if (currentPartitionNumber == 0) {
            adjustedTimeLimit = TimeSpan.ofMillis((long)Math.round(this.firstPartitionFactor * (double)adjustedTimeLimit.asMillis()));
        }
        partition.updateTimeLimit(adjustedTimeLimit);
    }

    private Algorithm createInnerAlgorithm(ReachedSet reached, CFANode mainFunction, ShutdownManager shutdownManager) throws InterruptedException, CPAException {
        try {
            this.stats.createPartitionsTimer.start();
            if (this.stats.iterationNumber > 0) {
                reached.clear();
                AbstractState initialState = this.cpa.getInitialState(mainFunction, StateSpacePartition.getDefaultPartition());
                Precision initialPrecision = this.cpa.getInitialPrecision(mainFunction, StateSpacePartition.getDefaultPartition());
                reached.add(initialState, initialPrecision);
            }
            ++this.stats.iterationNumber;
            ConfigurationBuilder innerConfigBuilder = Configuration.builder();
            innerConfigBuilder.copyFrom(this.config);
            innerConfigBuilder.clearOption("analysis.algorithm.MPV");
            Configuration singleConfig = innerConfigBuilder.build();
            CoreComponentsFactory coreComponents = new CoreComponentsFactory(singleConfig, this.logger, shutdownManager.getNotifier(), AggregatedReachedSets.empty());
            Algorithm algorithm = coreComponents.createAlgorithm(this.cpa, this.cfa, this.specification);
            return algorithm;
        }
        catch (InvalidConfigurationException e) {
            throw new CPAException("Cannot create configuration for inner algorithm", e);
        }
        finally {
            this.stats.createPartitionsTimer.stop();
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private static enum LimitAdjustmentStrategy {
        NONE,
        DISTRIBUTE_REMAINING,
        DISTRIBUTE_BY_PROPERTY;

    }

    private class MPVStatistics
    implements Statistics {
        private final Timer totalTimer = new Timer();
        private final Timer createPartitionsTimer = new Timer();
        private int iterationNumber = 0;
        private final List<Partition> partitions = new ArrayList<Partition>();

        private MPVStatistics() {
        }

        @Override
        public String getName() {
            return "MPV algorithm";
        }

        private TimeSpan getCurrentCpuTime() {
            TimeSpan totalCpuTime = TimeSpan.ofNanos((long)0L);
            for (AbstractSingleProperty property : MPVAlgorithm.this.multipleProperties.getProperties()) {
                totalCpuTime = TimeSpan.sum((TimeSpan)totalCpuTime, (TimeSpan)property.getCpuTime());
            }
            return totalCpuTime;
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            TimeSpan totalCpuTime = this.getCurrentCpuTime();
            out.println("Number of iterations:                         " + this.iterationNumber);
            out.println("Total wall time for creating partitions:  " + this.createPartitionsTimer.getSumTime().formatAs(TimeUnit.SECONDS));
            out.println("Total wall time for MPV algorithm:        " + this.totalTimer.getSumTime().formatAs(TimeUnit.SECONDS));
            out.println("Total CPU time for MPV algorithm:         " + totalCpuTime.formatAs(TimeUnit.SECONDS));
            out.println();
            out.println("Partitions statistics:");
            int counter = 1;
            for (Partition partition : this.partitions) {
                out.println("Partition " + counter++ + ":");
                out.println("  Properties (" + partition.getNumberOfProperties() + "): " + partition);
                out.println("  CPU time limit:\t" + partition.getTimeLimit().formatAs(TimeUnit.SECONDS));
                out.println("  Spent CPU time:\t" + partition.getSpentCPUTime().formatAs(TimeUnit.SECONDS));
            }
            out.println();
            out.println("Properties statistics:");
            for (AbstractSingleProperty property : MPVAlgorithm.this.multipleProperties.getProperties()) {
                CPAcheckerResult.Result result = property.getResult();
                out.println("Property '" + property + "'");
                out.println("  CPU time:" + property.getCpuTime().formatAs(TimeUnit.SECONDS));
                out.println("  Relevant:    " + property.isRelevant());
                out.println("  Result:      " + result);
                if (result.equals((Object)CPAcheckerResult.Result.FALSE)) {
                    out.println("    Found violations:     " + property.getViolations());
                    out.println("    All violations found: " + property.isAllViolationsFound());
                    out.println("    Description:          " + property.getViolatedPropertyDescription());
                }
                if ((!result.equals((Object)CPAcheckerResult.Result.FALSE) || property.isAllViolationsFound()) && !result.equals((Object)CPAcheckerResult.Result.UNKNOWN)) continue;
                out.println("    Reason of UNKNOWN:    " + property.getReasonOfUnknown());
            }
        }
    }
}

