/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Test;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.AbstractSingleProperty;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.AutomataSingleProperty;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class MPVTest {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final int DEFAULT_TIME_LIMIT_PER_PROPERTY = 5;
    private static final String BAD_NAME = "_bad_name_";
    private static final String[] AUTOMATA_FILES = new String[]{"test/config/automata/ldv/alloc_spinlock.spc", "test/config/automata/ldv/bitops.spc", "test/config/automata/ldv/class.spc", "test/config/automata/ldv/module.spc", "test/config/automata/ldv/mutex.spc", "test/config/automata/ldv/rwlock.spc", "test/config/automata/ldv/spinlock.spc", "test/config/automata/ldv/usblock.spc", "test/config/automata/ldv/rculock.spc"};
    private static final String SIMPLE_TEST = "test/programs/ldv-automata/mpv/mpv_test_false_simple.c";
    private static final String MEA_TEST = "test/programs/ldv-automata/mpv/mpv_test_false_mea.c";
    private static final String ITL_TEST = "test/programs/ldv-automata/mpv/mpv_test_false_itl.c";
    private static final String[][] BASIC_IDEAL_RESULTS = new String[][]{{"linux_alloc_spinlock", "FALSE", "true", "true"}, {"linux_bitops", "TRUE", "false", "false"}, {"linux_class", "TRUE", "false", "false"}, {"linux_module", "TRUE", "false", "false"}, {"linux_mutex", "TRUE", "false", "true"}, {"linux_rwlock", "TRUE", "false", "false"}, {"linux_spinlock", "FALSE", "true", "true"}, {"linux_alloc_usblock", "TRUE", "false", "false"}, {"linux_rculock", "TRUE", "false", "true"}, {"linux_rculockbh", "TRUE", "false", "false"}};
    private static final String[][] BASIC_FILE_IDEAL_RESULTS = new String[][]{{"alloc_spinlock", "FALSE", "true", "true"}, {"bitops", "TRUE", "false", "false"}, {"class", "TRUE", "false", "false"}, {"module", "TRUE", "false", "false"}, {"mutex", "TRUE", "false", "true"}, {"rwlock", "TRUE", "false", "false"}, {"spinlock", "FALSE", "true", "true"}, {"usblock", "TRUE", "false", "false"}, {"rculock", "TRUE", "false", "true"}};
    private static final String[][] MEA_IDEAL_RESULTS = new String[][]{{"linux_alloc_spinlock", "FALSE", "true", "true"}, {"linux_bitops", "TRUE", "false", "false"}, {"linux_class", "TRUE", "false", "false"}, {"linux_module", "TRUE", "false", "false"}, {"linux_mutex", "TRUE", "false", "true"}, {"linux_rwlock", "TRUE", "false", "false"}, {"linux_spinlock", "FALSE", "true", "true"}, {"linux_alloc_usblock", "TRUE", "false", "false"}, {"linux_rculock", "FALSE", "false", "true"}, {"linux_rculockbh", "TRUE", "false", "false"}};
    private static final String[][] ITL_IDEAL_RESULTS = new String[][]{{"linux_alloc_spinlock", "FALSE", "true", "true"}, {"linux_bitops", "TRUE", "false", "false"}, {"linux_class", "TRUE", "false", "false"}, {"linux_module", "TRUE", "false", "false"}, {"linux_mutex", "TRUE", "false", "true"}, {"linux_rwlock", "TRUE", "false", "false"}, {"linux_spinlock", "FALSE", "true", "true"}, {"linux_alloc_usblock", "TRUE", "false", "false"}, {"linux_rculock", "UNKNOWN", "false", "true"}, {"linux_rculockbh", "TRUE", "false", "false"}};
    private static final Pattern PROPERTY_RESULT_PATTERN = Pattern.compile("Property '(.+)': (\\w+)$");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^Property '(.+)'$");
    private static final Pattern RELEVANCY_PATTERN = Pattern.compile("^  Relevant:\\s+(true|false)$");
    private static final Pattern ALL_VIOLATIONS_PATTERN = Pattern.compile("^    All violations found:\\s+(true|false)$");

    private Map<String, String> createConfig(String[] automataFiles, String propertySeparator, String partitioningOperator, boolean findAllViolations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"CompositeCPA.cpas", (Object)"cpa.location.LocationCPA,cpa.callstack.CallstackCPA,cpa.value.ValueAnalysisCPA,cpa.predicate.PredicateCPA");
        StringBuilder specificationFiles = new StringBuilder();
        for (String file : automataFiles) {
            if (specificationFiles.length() > 0) {
                specificationFiles.append("," + file);
                continue;
            }
            specificationFiles.append(file);
        }
        builder.put((Object)"specification", (Object)specificationFiles.toString());
        builder.put((Object)"mpv.limits.cpuTimePerProperty", (Object)String.valueOf(5));
        builder.put((Object)"analysis.algorithm.MPV", (Object)"true");
        builder.put((Object)"mpv.propertySeparator", (Object)propertySeparator);
        builder.put((Object)"mpv.partitionOperator", (Object)partitioningOperator);
        builder.put((Object)"mpv.findAllViolations", (Object)String.valueOf(findAllViolations));
        return builder.buildOrThrow();
    }

    private List<AbstractSingleProperty> parseResult(CPAcheckerResult result) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ByteArrayOutputStream outputStreamResults = new ByteArrayOutputStream();
        PrintStream printStreamResults = new PrintStream((OutputStream)outputStreamResults, true, DEFAULT_CHARSET);
        result.printResult(printStreamResults);
        for (String line : Splitter.on((String)"\n").split((CharSequence)outputStreamResults.toString(DEFAULT_CHARSET))) {
            Matcher matcher = PROPERTY_RESULT_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            String name = matcher.group(1);
            String verdict = matcher.group(2);
            AutomataSingleProperty property = new AutomataSingleProperty(name, (List<Automaton>)ImmutableList.of());
            property.updateResult(CPAcheckerResult.Result.valueOf(verdict));
            builder.add((Object)property);
        }
        ImmutableList properties = builder.build();
        ByteArrayOutputStream outputStreamStats = new ByteArrayOutputStream();
        PrintStream printStreamStats = new PrintStream((OutputStream)outputStreamStats, true, DEFAULT_CHARSET);
        result.printStatistics(printStreamStats);
        AbstractSingleProperty currentProperty = null;
        for (String line : Splitter.on((String)"\n").split((CharSequence)outputStreamStats.toString(DEFAULT_CHARSET))) {
            Matcher matcher = PROPERTY_PATTERN.matcher(line);
            if (matcher.find()) {
                String name = matcher.group(1);
                for (AbstractSingleProperty property : properties) {
                    if (!property.getName().equals(name)) continue;
                    currentProperty = property;
                }
            }
            if ((matcher = RELEVANCY_PATTERN.matcher(line)).find()) {
                boolean isRelevant = Boolean.parseBoolean(matcher.group(1));
                assert (currentProperty != null);
                if (isRelevant) {
                    currentProperty.setRelevant();
                }
            }
            if (!(matcher = ALL_VIOLATIONS_PATTERN.matcher(line)).find()) continue;
            boolean isAllViolationsFound = Boolean.parseBoolean(matcher.group(1));
            assert (currentProperty != null);
            if (!isAllViolationsFound) continue;
            currentProperty.allViolationsFound();
        }
        return properties;
    }

    private void compareResultsMatrixes(String[][] idealResults, List<AbstractSingleProperty> propertiesResults) {
        String[][] actualResults = new String[propertiesResults.size()][4];
        int i = 0;
        for (AbstractSingleProperty property : propertiesResults) {
            actualResults[i][0] = property.getName();
            actualResults[i][1] = property.getResult().toString();
            actualResults[i][2] = String.valueOf(property.isAllViolationsFound());
            actualResults[i][3] = String.valueOf(property.isRelevant());
            ++i;
        }
        for (i = 0; i < idealResults.length; ++i) {
            if (!idealResults[i][1].equals("UNKNOWN")) continue;
            Truth.assertThat((String)actualResults[i][0]).isEqualTo((Object)idealResults[i][0]);
            for (int j = 0; j < idealResults[i].length; ++j) {
                idealResults[i][j] = actualResults[i][j];
            }
        }
        Truth.assertThat((Object[])actualResults).isEqualTo((Object)idealResults);
    }

    private void checkResults(TestResults actualResults, String[][] idealResults, CPAcheckerResult.Result overallExpectedResult) {
        actualResults.assertIs(overallExpectedResult);
        List<AbstractSingleProperty> propertiesResults = this.parseResult(actualResults.getCheckerResult());
        if (overallExpectedResult.equals((Object)CPAcheckerResult.Result.NOT_YET_STARTED)) {
            Truth.assertThat(propertiesResults).isEmpty();
        } else {
            this.compareResultsMatrixes(idealResults, propertiesResults);
        }
    }

    @Test
    public void simpleTest() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", "NoPartitioningOperator", false), SIMPLE_TEST);
        this.checkResults(results, BASIC_IDEAL_RESULTS, CPAcheckerResult.Result.FALSE);
    }

    @Test
    public void filePropertySeparator() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "FILE", "NoPartitioningOperator", false), SIMPLE_TEST);
        this.checkResults(results, BASIC_FILE_IDEAL_RESULTS, CPAcheckerResult.Result.FALSE);
    }

    @Test
    public void separatePartitioning() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", "SeparatePartitioningOperator", false), SIMPLE_TEST);
        this.checkResults(results, BASIC_IDEAL_RESULTS, CPAcheckerResult.Result.FALSE);
    }

    @Test
    public void relevancePartitioning() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", "RelevancePartitioningOperator", false), SIMPLE_TEST);
        this.checkResults(results, BASIC_IDEAL_RESULTS, CPAcheckerResult.Result.FALSE);
    }

    @Test
    public void jointPartitioning() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", "JointPartitioningOperator", false), SIMPLE_TEST);
        this.checkResults(results, BASIC_IDEAL_RESULTS, CPAcheckerResult.Result.FALSE);
    }

    @Test
    public void meaAllViolations() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", "NoPartitioningOperator", true), SIMPLE_TEST);
        this.checkResults(results, BASIC_IDEAL_RESULTS, CPAcheckerResult.Result.FALSE);
    }

    @Test
    public void onlySafeVerdicts() throws Exception {
        String[] safeAutomata = (String[])Arrays.stream(AUTOMATA_FILES).filter(s -> !s.contains("spin")).toArray(String[]::new);
        TestResults results = CPATestRunner.run(this.createConfig(safeAutomata, "AUTOMATON", "NoPartitioningOperator", true), SIMPLE_TEST);
        String[][] idealResults = (String[][])Arrays.stream(BASIC_IDEAL_RESULTS).filter(s -> !s[0].contains("spin")).toArray(x$0 -> new String[x$0][]);
        this.checkResults(results, idealResults, CPAcheckerResult.Result.TRUE);
    }

    @Test
    public void meaPartialResult() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", "SeparatePartitioningOperator", true), MEA_TEST);
        this.checkResults(results, MEA_IDEAL_RESULTS, CPAcheckerResult.Result.FALSE);
    }

    @Test
    public void innerTimeLimit() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", "SeparatePartitioningOperator", false), ITL_TEST);
        this.checkResults(results, ITL_IDEAL_RESULTS, CPAcheckerResult.Result.FALSE);
    }

    @Test
    public void overallUnknown() throws Exception {
        String[] safeOrUnknownAutomata = (String[])Arrays.stream(AUTOMATA_FILES).filter(s -> !s.contains("spin")).toArray(String[]::new);
        TestResults results = CPATestRunner.run(this.createConfig(safeOrUnknownAutomata, "AUTOMATON", "SeparatePartitioningOperator", true), ITL_TEST);
        String[][] idealResults = (String[][])Arrays.stream(ITL_IDEAL_RESULTS).filter(s -> !s[0].contains("spin")).toArray(x$0 -> new String[x$0][]);
        this.checkResults(results, idealResults, CPAcheckerResult.Result.UNKNOWN);
    }

    @Test
    public void badSeparator() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, BAD_NAME, "NoPartitioningOperator", true), SIMPLE_TEST);
        this.checkResults(results, null, CPAcheckerResult.Result.NOT_YET_STARTED);
    }

    @Test
    public void badPartitioning() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", BAD_NAME, true), SIMPLE_TEST);
        this.checkResults(results, null, CPAcheckerResult.Result.NOT_YET_STARTED);
    }

    @Test
    public void badFileName() throws Exception {
        TestResults results = CPATestRunner.run(this.createConfig(AUTOMATA_FILES, "AUTOMATON", "NoPartitioningOperator", true), BAD_NAME);
        this.checkResults(results, null, CPAcheckerResult.Result.NOT_YET_STARTED);
    }
}

