/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv.partition;

import com.google.common.collect.ImmutableList;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.Partition;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.PartitioningOperator;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.AbstractSingleProperty;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.MultipleProperties;

abstract class AbstractPartitioningOperator
implements PartitioningOperator {
    private final MultipleProperties properties;
    private final TimeSpan timeLimitPerProperty;
    private int phase;

    protected AbstractPartitioningOperator(MultipleProperties pProperties, TimeSpan pTimeLimitPerProperty) {
        this.properties = pProperties;
        this.timeLimitPerProperty = pTimeLimitPerProperty;
        this.phase = 1;
    }

    protected ImmutableList<Partition> createSeparatedPartition(MultipleProperties targetProperties) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AbstractSingleProperty property : targetProperties.getProperties()) {
            if (!property.isNotChecked()) continue;
            MultipleProperties singleProperty = new MultipleProperties((ImmutableList<AbstractSingleProperty>)ImmutableList.of((Object)property), targetProperties.isFindAllViolations());
            builder.add((Object)new Partition(singleProperty, this.timeLimitPerProperty, true));
        }
        return builder.build();
    }

    protected ImmutableList<Partition> createJointPartition(MultipleProperties targetProperties, TimeSpan timeLimit, boolean isFinal) {
        ImmutableList.Builder propertyBuilder = ImmutableList.builder();
        for (AbstractSingleProperty property : targetProperties.getProperties()) {
            if (!property.isNotChecked()) continue;
            propertyBuilder.add((Object)property);
        }
        MultipleProperties irrelevantProperties = new MultipleProperties((ImmutableList<AbstractSingleProperty>)propertyBuilder.build(), targetProperties.isFindAllViolations());
        return ImmutableList.of((Object)new Partition(irrelevantProperties, timeLimit, isFinal));
    }

    protected TimeSpan scaleTimeLimit(double ratio) {
        return TimeSpan.ofMillis((long)Math.round(ratio * (double)this.timeLimitPerProperty.asMillis()));
    }

    protected MultipleProperties getProperties() {
        return this.properties;
    }

    protected int currentPhase() {
        return this.phase;
    }

    protected void nextPhase() {
        ++this.phase;
    }
}

