/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv.partition;

import com.google.common.collect.ImmutableList;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.AbstractPartitioningOperator;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.Partition;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.MultipleProperties;

@Options(prefix="mpv")
public final class JointPartitioningOperator
extends AbstractPartitioningOperator {
    @Option(secure=true, name="limits.joint.firstPhaseRatio", description="The ratio of CPU time limit in the first phase of Joint partitioning operator to CPU time limit per each property.")
    private double firstPhaseRatio = 1.3;

    public JointPartitioningOperator(Configuration pConfiguration, MultipleProperties pProperties, TimeSpan pTimeLimitPerProperty) throws InvalidConfigurationException {
        super(pProperties, pTimeLimitPerProperty);
        pConfiguration.inject((Object)this);
    }

    @Override
    public ImmutableList<Partition> createPartitions() {
        if (this.currentPhase() == 1) {
            this.nextPhase();
            return this.createJointPartition(this.getProperties(), this.scaleTimeLimit(this.firstPhaseRatio), false);
        }
        return this.createSeparatedPartition(this.getProperties());
    }
}

