/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv.partition;

import javax.management.JMException;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.MultipleProperties;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.resources.ProcessCpuTime;

public final class Partition {
    private final MultipleProperties properties;
    private TimeSpan partitionTimeLimit;
    private final boolean isAssignUnknown;
    private long cpuTime = 0L;
    private TimeSpan spentCpuTime = TimeSpan.ofNanos((long)-1L);

    public Partition(MultipleProperties pProperties, TimeSpan pPartitionTimeLimit, boolean pIsAssignUnknown) {
        this.properties = pProperties;
        this.partitionTimeLimit = pPartitionTimeLimit;
        this.isAssignUnknown = pIsAssignUnknown;
    }

    public boolean isIntermediateStep() {
        return this.isAssignUnknown;
    }

    public void startAnalysis() {
        try {
            this.cpuTime = ProcessCpuTime.read();
        }
        catch (NoClassDefFoundError | JMException e) {
            this.cpuTime = -1L;
        }
    }

    public void stopAnalysisOnFailure(ReachedSet reached, String reason) {
        if (this.isAssignUnknown) {
            this.properties.stopAnalysisOnFailure(reason);
        }
        this.stopAnalysis(reached);
    }

    public boolean isChecked(ReachedSet reached) {
        if (reached.wasTargetReached()) {
            this.properties.processPropertyViolation(reached);
        }
        if (!reached.hasWaitingState() || this.properties.isChecked() && !this.properties.isFindAllViolations()) {
            this.stopAnalysisOnSuccess(reached);
            return true;
        }
        return false;
    }

    private void stopAnalysis(ReachedSet reached) {
        this.spentCpuTime = this.getSpentCPUTime();
        this.properties.divideSpentResources(this.spentCpuTime, reached);
    }

    private void stopAnalysisOnSuccess(ReachedSet reached) {
        this.properties.stopAnalysisOnSuccess();
        this.stopAnalysis(reached);
    }

    public MultipleProperties getProperties() {
        return this.properties;
    }

    public int getNumberOfProperties() {
        return this.properties.getNumberOfProperties();
    }

    public TimeSpan getTimeLimit() {
        return this.partitionTimeLimit;
    }

    public void updateTimeLimit(TimeSpan timeLimit) {
        this.partitionTimeLimit = timeLimit;
    }

    public TimeSpan getSpentCPUTime() {
        if (this.spentCpuTime.asMillis() > 0L) {
            return this.spentCpuTime;
        }
        try {
            long stopCpuTime = ProcessCpuTime.read();
            if (this.cpuTime >= 0L) {
                this.cpuTime = stopCpuTime - this.cpuTime;
            }
        }
        catch (NoClassDefFoundError | JMException throwable) {
            // empty catch block
        }
        return TimeSpan.ofNanos((long)this.cpuTime);
    }

    public String toString() {
        return this.properties.toString();
    }
}

