/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv.partition;

import com.google.common.collect.ImmutableList;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.AbstractPartitioningOperator;
import org.sosy_lab.cpachecker.core.algorithm.mpv.partition.Partition;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.MultipleProperties;

@Options(prefix="mpv")
public final class RelevancePartitioningOperator
extends AbstractPartitioningOperator {
    @Option(secure=true, name="limits.relevance.firstPhaseRatio", description="The ratio of CPU time limit in the first phase of Relevance partitioning operator to CPU time limit per each property.")
    private double firstPhaseRatio = 0.2;
    @Option(secure=true, name="limits.relevance.secondPhaseRatio", description="The ratio of CPU time limit in the second phase of Relevance partitioning operator to CPU time limit per each property.")
    private double secondPhaseRatio = 1.3;
    private int lastNumberOfIrrelevantProperties;

    public RelevancePartitioningOperator(Configuration pConfiguration, MultipleProperties pProperties, TimeSpan pTimeLimitPerProperty) throws InvalidConfigurationException {
        super(pProperties, pTimeLimitPerProperty);
        pConfiguration.inject((Object)this);
        this.lastNumberOfIrrelevantProperties = 0;
    }

    @Override
    public ImmutableList<Partition> createPartitions() {
        if (this.currentPhase() == 1) {
            this.nextPhase();
            return this.createJointPartition(this.getProperties(), this.scaleTimeLimit(this.firstPhaseRatio), false);
        }
        MultipleProperties irrelevant = this.getProperties().createIrrelevantProperties();
        int curNumberOfIrrelevantProperties = irrelevant.getNumberOfProperties();
        if (this.lastNumberOfIrrelevantProperties != curNumberOfIrrelevantProperties) {
            this.lastNumberOfIrrelevantProperties = curNumberOfIrrelevantProperties;
            return this.createJointPartition(irrelevant, this.scaleTimeLimit(this.secondPhaseRatio), false);
        }
        if (curNumberOfIrrelevantProperties > 0) {
            irrelevant.stopAnalysisOnFailure("Relavance algorithm, second phase");
        }
        return this.createSeparatedPartition(this.getProperties());
    }
}

