/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv.property;

import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;

public abstract class AbstractSingleProperty {
    private final String name;
    private TimeSpan cpuTime;
    private boolean relevant;
    private int violations;
    private boolean allViolationsFound;
    private CPAcheckerResult.Result result;
    private final Set<Targetable.TargetInformation> violatedPropertyDescription;
    private String reasonOfUnknown;

    protected AbstractSingleProperty(String pName) {
        this.name = pName;
        this.cpuTime = TimeSpan.ofSeconds((long)0L);
        this.relevant = false;
        this.violations = 0;
        this.allViolationsFound = false;
        this.result = CPAcheckerResult.Result.NOT_YET_STARTED;
        this.violatedPropertyDescription = new HashSet<Targetable.TargetInformation>();
        this.reasonOfUnknown = "";
    }

    public abstract void disable(Precision var1);

    public abstract void enable(Precision var1);

    public abstract boolean isTarget(AutomatonState var1);

    public abstract void determineRelevancy(CFA var1);

    public boolean isNotDetermined() {
        return this.result.equals((Object)CPAcheckerResult.Result.NOT_YET_STARTED);
    }

    public boolean isNotChecked() {
        return this.isNotDetermined() || this.result.equals((Object)CPAcheckerResult.Result.FALSE) && !this.allViolationsFound;
    }

    public void updateResult(CPAcheckerResult.Result newResult) {
        if (!newResult.equals((Object)CPAcheckerResult.Result.UNKNOWN) || !this.result.equals((Object)CPAcheckerResult.Result.FALSE)) {
            this.result = newResult;
        }
        if (newResult.equals((Object)CPAcheckerResult.Result.FALSE)) {
            ++this.violations;
        }
    }

    public boolean isRelevant() {
        return this.relevant;
    }

    public void setRelevant() {
        this.relevant = true;
    }

    public CPAcheckerResult.Result getResult() {
        return this.result;
    }

    public void allViolationsFound() {
        this.allViolationsFound = true;
    }

    public boolean isAllViolationsFound() {
        return this.allViolationsFound;
    }

    public void addViolatedPropertyDescription(Set<Targetable.TargetInformation> pDescription) {
        this.violatedPropertyDescription.addAll(pDescription);
    }

    public String getReasonOfUnknown() {
        return this.reasonOfUnknown;
    }

    public void setReasonOfUnknown(String pReasonOfUnknown) {
        assert (!this.result.equals((Object)CPAcheckerResult.Result.TRUE));
        this.reasonOfUnknown = pReasonOfUnknown;
    }

    public Set<Targetable.TargetInformation> getViolatedPropertyDescription() {
        return this.violatedPropertyDescription;
    }

    public TimeSpan getCpuTime() {
        return this.cpuTime;
    }

    public void addCpuTime(TimeSpan pCpuTime) {
        this.cpuTime = TimeSpan.sum((TimeSpan)this.cpuTime, (TimeSpan)pCpuTime);
    }

    public int getViolations() {
        return this.violations;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

