/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv.property;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.AbstractSingleProperty;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonPrecision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;

public final class AutomataSingleProperty
extends AbstractSingleProperty {
    private final List<Automaton> automata;

    public AutomataSingleProperty(String pName, List<Automaton> pAutomata) {
        super(pName);
        this.automata = pAutomata;
    }

    @Override
    public void disable(Precision precision) {
        for (AutomatonPrecision automatonPrecision : this.getAutomatonPrecision(precision)) {
            automatonPrecision.disable();
        }
    }

    @Override
    public void enable(Precision precision) {
        for (AutomatonPrecision automatonPrecision : this.getAutomatonPrecision(precision)) {
            automatonPrecision.enable();
        }
    }

    private Set<AutomatonPrecision> getAutomatonPrecision(Precision precision) {
        AutomatonPrecision automatonPrecision;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (precision instanceof WrapperPrecision) {
            for (Precision wrappedPrecision : ((WrapperPrecision)precision).getWrappedPrecisions()) {
                builder.addAll(this.getAutomatonPrecision(wrappedPrecision));
            }
        } else if (precision instanceof AutomatonPrecision && this.automata.contains((automatonPrecision = (AutomatonPrecision)precision).getAutomaton())) {
            builder.add((Object)automatonPrecision);
        }
        return builder.build();
    }

    @Override
    public boolean isTarget(AutomatonState pState) {
        return this.automata.contains(pState.getOwningAutomaton());
    }

    @Override
    public void determineRelevancy(CFA cfa) {
        for (Automaton automaton : this.automata) {
            if (!automaton.isRelevantForCFA(cfa)) continue;
            this.setRelevant();
            break;
        }
    }
}

