/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.mpv.property;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.AbstractSingleProperty;
import org.sosy_lab.cpachecker.core.algorithm.mpv.property.AutomataSingleProperty;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;

public final class MultipleProperties {
    private final boolean findAllViolations;
    private final ImmutableList<AbstractSingleProperty> properties;

    public MultipleProperties(ImmutableListMultimap<Path, Automaton> specification, PropertySeparator propertySeparator, boolean findAllViolations) {
        this.findAllViolations = findAllViolations;
        ImmutableList.Builder propertyBuilder = ImmutableList.builder();
        block4: for (Path path : specification.keySet()) {
            switch (propertySeparator) {
                case FILE: {
                    Path propertyFileName = path.getFileName();
                    String propertyName = propertyFileName != null ? propertyFileName.toString() : path.toString();
                    propertyName = propertyName.replace(".spc", "");
                    propertyBuilder.add((Object)new AutomataSingleProperty(propertyName, (List<Automaton>)specification.get((Object)path)));
                    break;
                }
                case AUTOMATON: {
                    String propertyName;
                    for (Automaton automaton : specification.get((Object)path)) {
                        propertyName = automaton.getName();
                        propertyBuilder.add((Object)new AutomataSingleProperty(propertyName, Lists.newArrayList((Object[])new Automaton[]{automaton})));
                    }
                    continue block4;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        this.properties = propertyBuilder.build();
    }

    public MultipleProperties(ImmutableList<AbstractSingleProperty> properties, boolean findAllViolations) {
        this.properties = properties;
        this.findAllViolations = findAllViolations;
    }

    public MultipleProperties createIrrelevantProperties() {
        ImmutableList.Builder propertyBuilder = ImmutableList.builder();
        for (AbstractSingleProperty property : this.properties) {
            if (property.isRelevant()) continue;
            propertyBuilder.add((Object)property);
        }
        return new MultipleProperties((ImmutableList<AbstractSingleProperty>)propertyBuilder.build(), this.findAllViolations);
    }

    public void stopAnalysisOnFailure(String reason) {
        for (AbstractSingleProperty property : this.properties) {
            if (!property.isNotChecked()) continue;
            property.updateResult(CPAcheckerResult.Result.UNKNOWN);
            property.setReasonOfUnknown(reason);
        }
    }

    public void stopAnalysisOnSuccess() {
        for (AbstractSingleProperty property : this.properties) {
            if (property.isNotDetermined()) {
                property.updateResult(CPAcheckerResult.Result.TRUE);
            }
            if (!property.getResult().equals((Object)CPAcheckerResult.Result.FALSE)) continue;
            property.allViolationsFound();
        }
    }

    public void processPropertyViolation(ReachedSet reached) {
        Set<AbstractSingleProperty> violatedProperties = this.determineViolatedProperties(reached.getLastState());
        for (AbstractSingleProperty property : violatedProperties) {
            if (this.findAllViolations) continue;
            this.disablePropertyDuringAnalysis(reached, property);
            property.allViolationsFound();
        }
    }

    private void disablePropertyDuringAnalysis(ReachedSet reached, AbstractSingleProperty property) {
        for (AbstractState state : reached.getWaitlist()) {
            Precision precision = reached.getPrecision(state);
            property.disable(precision);
        }
    }

    private Set<AbstractSingleProperty> determineViolatedProperties(AbstractState targetState) {
        ImmutableSet.Builder builder;
        block3: {
            AutomatonState automatonState;
            block2: {
                builder = ImmutableSet.builder();
                if (!(targetState instanceof AbstractWrapperState)) break block2;
                for (AbstractState state : ((AbstractWrapperState)targetState).getWrappedStates()) {
                    builder.addAll(this.determineViolatedProperties(state));
                }
                break block3;
            }
            if (!(targetState instanceof AutomatonState) || !(automatonState = (AutomatonState)targetState).isTarget()) break block3;
            for (AbstractSingleProperty property : this.properties) {
                if (!property.isTarget(automatonState)) continue;
                property.updateResult(CPAcheckerResult.Result.FALSE);
                property.setRelevant();
                property.addViolatedPropertyDescription(automatonState.getTargetInformation());
                builder.add((Object)property);
            }
        }
        return builder.build();
    }

    public void determineRelevance(CFA cfa) {
        for (AbstractSingleProperty property : this.properties) {
            property.determineRelevancy(cfa);
        }
    }

    public void setTargetProperties(MultipleProperties targetProperties, ReachedSet reached) {
        Precision precision = reached.getPrecision(reached.getFirstState());
        for (AbstractSingleProperty property : this.properties) {
            if (!targetProperties.properties.contains((Object)property)) {
                property.disable(precision);
                continue;
            }
            if (!property.isNotChecked()) continue;
            property.enable(precision);
        }
    }

    public boolean isChecked() {
        for (AbstractSingleProperty property : this.properties) {
            if (!property.isNotDetermined()) continue;
            return false;
        }
        return true;
    }

    public void divideSpentResources(TimeSpan spentCPUTime, ReachedSet reached) {
        for (AbstractSingleProperty property : this.properties) {
            property.addCpuTime(spentCPUTime.divide(this.getNumberOfProperties()));
        }
    }

    public CPAcheckerResult.Result getOverallResult() {
        boolean isUnknown = false;
        for (AbstractSingleProperty property : this.properties) {
            if (property.getResult().equals((Object)CPAcheckerResult.Result.FALSE)) {
                return CPAcheckerResult.Result.FALSE;
            }
            if (property.getResult().equals((Object)CPAcheckerResult.Result.UNKNOWN)) {
                isUnknown = true;
                continue;
            }
            if (!property.getResult().equals((Object)CPAcheckerResult.Result.NOT_YET_STARTED)) continue;
            return CPAcheckerResult.Result.NOT_YET_STARTED;
        }
        if (isUnknown) {
            return CPAcheckerResult.Result.UNKNOWN;
        }
        return CPAcheckerResult.Result.TRUE;
    }

    public int getNumberOfProperties() {
        return this.properties.size();
    }

    public boolean isFindAllViolations() {
        return this.findAllViolations;
    }

    public ImmutableList<AbstractSingleProperty> getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.properties.toString();
    }

    public static enum PropertySeparator {
        FILE,
        AUTOMATON;

    }
}

