/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.parallel_bam;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.parallel_bam.ReachedSetExecutor;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPAWithBreakOnMissingBlock;
import org.sosy_lab.cpachecker.cpa.bam.BAMReachedSetValidator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CompoundException;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatHist;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsSeries;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

@Options(prefix="algorithm.parallelBam")
public class ParallelBAMAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(description="number of threads, positive values match exactly, with -1 we use the number of available cores or the machine automatically.", secure=true)
    private int numberOfThreads = -1;
    @Option(description="export number of running RSE instances as CSV", secure=true)
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path runningRSESeriesFile = Path.of("RSESeries.csv", new String[0]);
    private final ParallelBAMStatistics stats = new ParallelBAMStatistics();
    private final LogManager logger;
    private final LogManagerWithoutDuplicates oneTimeLogger;
    private final BAMCPAWithBreakOnMissingBlock bamcpa;
    private final Algorithm.AlgorithmFactory algorithmFactory;
    private final ShutdownNotifier shutdownNotifier;

    public ParallelBAMAlgorithm(ConfigurableProgramAnalysis pCpa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.bamcpa = (BAMCPAWithBreakOnMissingBlock)pCpa;
        this.logger = pLogger;
        this.oneTimeLogger = new LogManagerWithoutDuplicates(pLogger);
        this.shutdownNotifier = pShutdownNotifier;
        this.algorithmFactory = new CPAAlgorithm.CPAAlgorithmFactory(this.bamcpa, this.logger, pConfig, pShutdownNotifier);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet mainReachedSet) throws CPAException, InterruptedException {
        this.stats.wallTime.start();
        try {
            Algorithm.AlgorithmStatus algorithmStatus = this.run0(mainReachedSet);
            return algorithmStatus;
        }
        finally {
            this.stats.wallTime.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Algorithm.AlgorithmStatus run0(ReachedSet mainReachedSet) throws CPAException, InterruptedException {
        int maxAssassinations;
        ConcurrentHashMap<ReachedSet, ReachedSetExecutor> reachedSetMapping = new ConcurrentHashMap<ReachedSet, ReachedSetExecutor>();
        int numberOfCores = this.getNumberOfCores();
        this.oneTimeLogger.logfOnce(Level.INFO, "creating pool for %d threads", new Object[]{numberOfCores});
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ParallelBAM-thread-%d").build();
        ExecutorService pool = Executors.newFixedThreadPool(numberOfCores, threadFactory);
        List<Throwable> errors = Collections.synchronizedList(new ArrayList());
        AtomicBoolean terminateAnalysis = new AtomicBoolean(false);
        AtomicInteger scheduledJobs = new AtomicInteger(0);
        int running = this.stats.numActiveThreads.get();
        assert (running == 0);
        this.stats.runningRSESeries.add(running);
        ReachedSetExecutor rse = new ReachedSetExecutor(this.bamcpa, mainReachedSet, this.bamcpa.getBlockPartitioning().getMainBlock(), true, reachedSetMapping, pool, this.algorithmFactory, this.shutdownNotifier, this.stats, errors, terminateAnalysis, scheduledJobs, this.logger);
        reachedSetMapping.put(mainReachedSet, rse);
        rse.addNewTask(rse.asRunnable());
        boolean isSound = true;
        try {
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            maxAssassinations = 5;
        }
        catch (Throwable throwable) {
            int maxAssassinations2 = 5;
            for (int i = 0; i < maxAssassinations2 && !pool.isTerminated(); ++i) {
                try {
                    this.logger.logf(Level.INFO, "threadpool did not terminate, killing threadpool now (try %d of %d).", new Object[]{i + 1, maxAssassinations2});
                    this.logger.log(Level.ALL, new Object[]{"remaining dependencies:\n", rse.getDependenciesAsDot()});
                    pool.shutdown();
                    pool.awaitTermination(100L, TimeUnit.MILLISECONDS);
                }
                finally {
                    pool.shutdownNow();
                }
                isSound = false;
            }
            if (!pool.isTerminated()) {
                this.logger.log(Level.WARNING, new Object[]{"threadpool is not yet dead, some thread is alive and we cannot interupt it."});
            }
            throw throwable;
        }
        for (int i = 0; i < maxAssassinations && !pool.isTerminated(); ++i) {
            try {
                this.logger.logf(Level.INFO, "threadpool did not terminate, killing threadpool now (try %d of %d).", new Object[]{i + 1, maxAssassinations});
                this.logger.log(Level.ALL, new Object[]{"remaining dependencies:\n", rse.getDependenciesAsDot()});
                pool.shutdown();
                pool.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            finally {
                pool.shutdownNow();
            }
            isSound = false;
        }
        if (!pool.isTerminated()) {
            this.logger.log(Level.WARNING, new Object[]{"threadpool is not yet dead, some thread is alive and we cannot interupt it."});
        }
        this.collectExceptions(reachedSetMapping, errors, mainReachedSet);
        assert (BAMReachedSetValidator.validateData(this.bamcpa.getData(), this.bamcpa.getBlockPartitioning(), new ARGReachedSet(mainReachedSet)));
        int running2 = this.stats.numActiveThreads.get();
        assert (running2 == 0);
        this.stats.runningRSESeries.add(running2);
        return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE.withSound(isSound);
    }

    private int getNumberOfCores() {
        if (this.numberOfThreads > 0) {
            return this.numberOfThreads;
        }
        Preconditions.checkState((this.numberOfThreads == -1 ? 1 : 0) != 0, (Object)"number of threads can only be a positive number or -1.");
        return Runtime.getRuntime().availableProcessors();
    }

    private void collectExceptions(Map<ReachedSet, ReachedSetExecutor> pReachedSetMapping, List<Throwable> errors, ReachedSet mainReachedSet) throws CPAException, InterruptedException {
        AtomicBoolean mainRScontainsTarget = new AtomicBoolean(false);
        AtomicBoolean otherRScontainsTarget = new AtomicBoolean(false);
        pReachedSetMapping.entrySet().parallelStream().forEach(entry -> {
            ReachedSetExecutor rse = (ReachedSetExecutor)entry.getValue();
            CompletableFuture<Void> job = rse.getWaitingTasks();
            try {
                job.get(5L, TimeUnit.SECONDS);
                this.stats.executionCounter.insertValue(((ReachedSetExecutor)entry.getValue()).execCounter);
                this.stats.unfinishedRSEcounter.inc();
                if (rse.isTargetStateFound()) {
                    if (entry.getKey() == mainReachedSet) {
                        mainRScontainsTarget.set(true);
                    } else {
                        otherRScontainsTarget.set(true);
                    }
                }
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException | TimeoutException e) {
                errors.add(e);
            }
            this.logger.log(Level.ALL, new Object[]{"finishing", rse, job.isCompletedExceptionally()});
        });
        if (!errors.isEmpty()) {
            this.logger.log(Level.ALL, new Object[]{"The following errors appeared in the analysis:", errors});
            ArrayList<CPAException> cpaExceptions = new ArrayList<CPAException>();
            for (Throwable toThrow : errors) {
                if (toThrow instanceof Error) {
                    this.addSuppressedAndThrow((Error)toThrow, errors);
                    continue;
                }
                if (toThrow instanceof RuntimeException) {
                    this.addSuppressedAndThrow((RuntimeException)toThrow, errors);
                    continue;
                }
                if (toThrow instanceof InterruptedException) {
                    this.addSuppressedAndThrow((InterruptedException)toThrow, errors);
                    continue;
                }
                if (toThrow instanceof CPAException) {
                    cpaExceptions.add((CPAException)toThrow);
                    continue;
                }
                this.addSuppressedAndThrow(new Classes.UnexpectedCheckedException("ParallelBAM", toThrow), errors);
            }
            if (cpaExceptions.size() == 1) {
                throw (CPAException)cpaExceptions.get(0);
            }
            throw new CompoundException(cpaExceptions);
        }
        Preconditions.checkState((mainRScontainsTarget.get() == otherRScontainsTarget.get() ? 1 : 0) != 0, (String)"when a target is found in a sub-analysis (%s), we expect a target in the main-reached-set (%s)", (Object)otherRScontainsTarget.get(), (Object)mainRScontainsTarget.get());
    }

    private <T extends Throwable> void addSuppressedAndThrow(T toThrow, List<Throwable> errors) throws T {
        for (Throwable otherErrors : Iterables.filter(errors, e -> e != toThrow)) {
            toThrow.addSuppressed(otherErrors);
        }
        throw toThrow;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    class ParallelBAMStatistics
    implements Statistics {
        final StatTimer wallTime = new StatTimer("Time for execution of algorithm");
        final ThreadSafeTimerContainer threadTime = new ThreadSafeTimerContainer("Time for RSE execution");
        final ThreadSafeTimerContainer addingStatesTime = new ThreadSafeTimerContainer("Time for adding states to RSE");
        final ThreadSafeTimerContainer terminationCheckTime = new ThreadSafeTimerContainer("Time for terminating RSE");
        final LongAccumulator numMaxRSE = new LongAccumulator(Math::max, 0L);
        final AtomicInteger numActiveThreads = new AtomicInteger(0);
        final StatHist histActiveThreads = new StatHist("Active threads");
        final StatHist executionCounter = new StatHist("RSE execution counter");
        private final StatCounter unfinishedRSEcounter = new StatCounter("unfinished reached-sets");
        final StatisticsSeries<Integer> runningRSESeries;

        ParallelBAMStatistics() {
            this.runningRSESeries = ParallelBAMAlgorithm.this.runningRSESeriesFile == null ? new StatisticsSeries.NoopStatisticsSeries() : new StatisticsSeries.StatisticsSeriesWithNumbers();
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsUtils.write(pOut, 0, 50, "max number of executors", this.numMaxRSE);
            StatisticsUtils.write(pOut, 0, 50, this.histActiveThreads);
            StatisticsUtils.write(pOut, 0, 50, this.executionCounter);
            StatisticsUtils.write(pOut, 0, 50, this.unfinishedRSEcounter);
            StatisticsUtils.write(pOut, 0, 50, this.wallTime);
            StatisticsUtils.write(pOut, 0, 50, this.threadTime);
            StatisticsUtils.write(pOut, 1, 50, this.addingStatesTime);
            StatisticsUtils.write(pOut, 1, 50, this.terminationCheckTime);
            if (ParallelBAMAlgorithm.this.runningRSESeriesFile != null) {
                StatisticsSeries.StatisticsSeriesWithNumbers sswn = (StatisticsSeries.StatisticsSeriesWithNumbers)this.runningRSESeries;
                StatisticsUtils.write(pOut, 1, 50, "Avg. number of parallel RSEs w/o time", sswn.getStatsWithoutTime());
                StatisticsUtils.write(pOut, 1, 50, "Avg. number of parallel RSEs over time", sswn.getStatsOverTime());
            }
        }

        @Override
        public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (ParallelBAMAlgorithm.this.runningRSESeriesFile != null) {
                try {
                    IO.writeFile((Path)ParallelBAMAlgorithm.this.runningRSESeriesFile, (Charset)Charset.defaultCharset(), this.runningRSESeries);
                }
                catch (IOException e) {
                    ParallelBAMAlgorithm.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write data-series for RSEs to file");
                }
            }
        }

        @Override
        public @Nullable String getName() {
            return "BAM-parallel";
        }
    }
}

