/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.parallel_bam;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.parallel_bam.ParallelBAMAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPAWithBreakOnMissingBlock;
import org.sosy_lab.cpachecker.cpa.bam.BAMTransferRelation;
import org.sosy_lab.cpachecker.cpa.bam.MissingBlockAbstractionState;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMCache;
import org.sosy_lab.cpachecker.cpa.bam.cache.BAMDataManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

class ReachedSetExecutor {
    private static final Level level = Level.ALL;
    private final ReachedSet rs;
    private final Block block;
    private final Algorithm algorithm;
    private boolean targetStateFound = false;
    private final boolean isMainReachedSet;
    private final ConcurrentMap<ReachedSet, ReachedSetExecutor> reachedSetMapping;
    private final ExecutorService pool;
    private final BAMCPAWithBreakOnMissingBlock bamcpa;
    private final Algorithm.AlgorithmFactory algorithmFactory;
    private final ShutdownNotifier shutdownNotifier;
    private final ParallelBAMAlgorithm.ParallelBAMStatistics stats;
    private final List<Throwable> errors;
    private final AtomicBoolean terminateAnalysis;
    private final LogManager logger;
    private final AtomicInteger scheduledJobs;
    int execCounter = 0;
    private final ThreadSafeTimerContainer.TimerWrapper threadTimer;
    private final ThreadSafeTimerContainer.TimerWrapper addingStatesTimer;
    private final ThreadSafeTimerContainer.TimerWrapper terminationCheckTimer;
    private final Set<AbstractState> dependsOn = new LinkedHashSet<AbstractState>();
    private final Multimap<ReachedSetExecutor, AbstractState> dependingFrom = LinkedHashMultimap.create();
    private CompletableFuture<Void> waitingTask;

    public ReachedSetExecutor(BAMCPAWithBreakOnMissingBlock pBamCpa, ReachedSet pRs, Block pBlock, boolean pIsMainReachedSet, ConcurrentMap<ReachedSet, ReachedSetExecutor> pReachedSetMapping, ExecutorService pPool, Algorithm.AlgorithmFactory pAlgorithmFactory, ShutdownNotifier pShutdownNotifier, ParallelBAMAlgorithm.ParallelBAMStatistics pStats, List<Throwable> pErrors, AtomicBoolean pTerminateAnalysis, AtomicInteger pScheduledJobs, LogManager pLogger) {
        this.bamcpa = pBamCpa;
        this.rs = pRs;
        this.block = pBlock;
        this.isMainReachedSet = pIsMainReachedSet;
        this.reachedSetMapping = pReachedSetMapping;
        this.pool = pPool;
        this.algorithmFactory = pAlgorithmFactory;
        this.shutdownNotifier = pShutdownNotifier;
        this.stats = pStats;
        this.errors = pErrors;
        this.terminateAnalysis = pTerminateAnalysis;
        this.scheduledJobs = pScheduledJobs;
        this.logger = pLogger;
        this.algorithm = this.algorithmFactory.newInstance();
        this.logger.logf(level, "%s :: creating RSE", new Object[]{this});
        assert (pBlock == this.getBlockForState(pRs.getFirstState()));
        this.threadTimer = this.stats.threadTime.getNewTimer();
        this.addingStatesTimer = this.stats.addingStatesTime.getNewTimer();
        this.terminationCheckTimer = this.stats.terminationCheckTime.getNewTimer();
        this.waitingTask = CompletableFuture.runAsync(() -> {}, this.pool);
    }

    public Runnable asRunnable() {
        return this.asRunnable((Collection<AbstractState>)ImmutableSet.of());
    }

    private Runnable asRunnable(Collection<AbstractState> pStatesToBeAdded) {
        ImmutableSet copy = ImmutableSet.copyOf(pStatesToBeAdded);
        return () -> this.apply0((Collection<AbstractState>)copy);
    }

    synchronized void addNewTask(Runnable r) {
        this.scheduledJobs.incrementAndGet();
        this.waitingTask = ((CompletableFuture)this.waitingTask.thenRunAsync(r, this.pool)).exceptionally((Function)new ExceptionHandler(this));
    }

    CompletableFuture<Void> getWaitingTasks() {
        return this.waitingTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply0(Collection<AbstractState> pStatesToBeAdded) {
        this.threadTimer.start();
        int running = this.stats.numActiveThreads.incrementAndGet();
        this.stats.histActiveThreads.insertValue(running);
        this.stats.numMaxRSE.accumulate(this.reachedSetMapping.size());
        this.stats.runningRSESeries.add(running);
        ++this.execCounter;
        this.scheduledJobs.decrementAndGet();
        try {
            this.shutdownNotifier.shutdownIfNecessary();
            this.apply(pStatesToBeAdded);
        }
        catch (Throwable e) {
            this.logger.logException(level, e, e.getClass().getName());
            this.terminateAnalysis.set(true);
            this.errors.add(e);
            this.pool.shutdownNow();
        }
        finally {
            this.stats.numActiveThreads.decrementAndGet();
            this.threadTimer.stop();
        }
    }

    private void apply(Collection<AbstractState> pStatesToBeAdded) throws InterruptedException, CPAException {
        this.logger.logf(level, "%s :: starting, target=%s, statesToBeAdded=%s", new Object[]{this, this.targetStateFound, ReachedSetExecutor.id(pStatesToBeAdded)});
        this.addingStatesTimer.start();
        this.updateStates(pStatesToBeAdded);
        this.addingStatesTimer.stop();
        this.checkForTargetState();
        assert (FluentIterable.from((Iterable)this.rs).filter(MissingBlockAbstractionState.class).isEmpty()) : "dummy state should never exist for longer than needed in a reached-set";
        if (!this.targetStateFound) {
            this.algorithm.run(this.rs);
            if (this.bamcpa.doesBreakForMissingBlock()) {
                AbstractState lastState = this.rs.getLastState();
                if (lastState instanceof MissingBlockAbstractionState) {
                    this.handleMissingBlock((MissingBlockAbstractionState)lastState);
                }
            } else {
                ArrayList missingBlockAbstractionStates = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.rs, MissingBlockAbstractionState.class));
                for (MissingBlockAbstractionState state : missingBlockAbstractionStates) {
                    this.handleMissingBlock(state);
                }
            }
            assert (FluentIterable.from((Iterable)this.rs).filter(MissingBlockAbstractionState.class).isEmpty()) : "dummy state should be removed from reached-set";
        }
        this.terminationCheckTimer.start();
        this.handleTermination();
        this.terminationCheckTimer.stop();
        this.logger.logf(level, "%s :: exiting, targetStateFound=%s", new Object[]{this, this.targetStateFound});
    }

    private void checkForTargetState() {
        boolean endsWithTargetState;
        boolean bl = endsWithTargetState = this.rs.getLastState() != null && AbstractStates.isTargetState(this.rs.getLastState());
        if (this.targetStateFound) {
            Preconditions.checkState((boolean)endsWithTargetState, (Object)"when a target was found before, it should remain as target of the reached-set");
            Preconditions.checkState((boolean)this.terminateAnalysis.get(), (Object)"when a target was found before, we want to stop further scheduling");
        }
        if (endsWithTargetState && !this.bamcpa.searchTargetStatesOnExit()) {
            this.targetStateFound = true;
            this.terminateAnalysis.set(true);
        }
    }

    private static String id(Collection<AbstractState> states) {
        return Collections2.transform(states, s -> ReachedSetExecutor.id(s)).toString();
    }

    private static String id(AbstractState state) {
        return ((ARGState)state).getStateId() + "@" + AbstractStates.extractLocation(state);
    }

    private static String id(ReachedSet pRs) {
        if (pRs.getFirstState() == null) {
            return "no initial state";
        }
        return ReachedSetExecutor.id(pRs.getFirstState());
    }

    private void updateStates(Collection<AbstractState> pStatesToBeAdded) {
        for (AbstractState state : pStatesToBeAdded) {
            this.rs.reAddToWaitlist(state);
            this.dependsOn.remove(state);
        }
    }

    boolean isTargetStateFound() {
        return this.targetStateFound;
    }

    private void handleTermination() {
        this.checkForTargetState();
        boolean isFinished = this.dependsOn.isEmpty();
        if (isFinished) {
            if (this.rs.getWaitlist().isEmpty() || this.targetStateFound) {
                this.updateCache();
            }
            this.reAddStatesToDependingReachedSets();
            this.reachedSetMapping.remove(this.rs);
            this.stats.executionCounter.insertValue(this.execCounter);
            if (this.scheduledJobs.get() == 0 && this.reachedSetMapping.isEmpty()) {
                this.logger.logf(level, "%s :: all RSEs finished, shutdown threadpool", new Object[]{this});
                this.pool.shutdown();
            }
        }
        this.logger.logf(level, "%s :: finished=%s, targetStateFound=%s, terminateAnalysis=%s", new Object[]{this, isFinished, this.targetStateFound, this.terminateAnalysis});
    }

    private void updateCache() {
        if (this.isMainReachedSet) {
            return;
        }
        AbstractState reducedInitialState = this.rs.getFirstState();
        Precision reducedInitialPrecision = this.rs.getPrecision(reducedInitialState);
        Block innerBlock = this.getBlockForState(reducedInitialState);
        Set<AbstractState> exitStates = BAMTransferRelation.extractExitStates(this.rs, innerBlock, this.bamcpa.searchTargetStatesOnExit());
        BAMCache.BAMCacheEntry entry = this.bamcpa.getCache().get(reducedInitialState, reducedInitialPrecision, innerBlock);
        assert (entry.getReachedSet() == this.rs) : String.format("reached-set for initial state should be unique: current rs = %s, cached entry = %s", ReachedSetExecutor.id(this.rs), entry.getReachedSet());
        if (!exitStates.equals(entry.getExitStates())) {
            assert (entry.getExitStates() == null) : String.format("result-states already registered for reached-set %s: current = %s, cached = %s", ReachedSetExecutor.id(this.rs), Collections2.transform(exitStates, s -> ReachedSetExecutor.id(s)), Collections2.transform(entry.getExitStates(), s -> ReachedSetExecutor.id(s)));
            entry.setExitStates(exitStates);
            entry.setRootOfBlock(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reAddStatesToDependingReachedSets() {
        Multimap<ReachedSetExecutor, AbstractState> multimap = this.dependingFrom;
        synchronized (multimap) {
            this.logger.logf(level, "%s :: -> %s", new Object[]{this, Iterables.transform((Iterable)this.dependingFrom.entries(), e -> e.getKey() + "#" + ReachedSetExecutor.id((AbstractState)e.getValue()))});
            for (Map.Entry parent : this.dependingFrom.asMap().entrySet()) {
                this.registerJob((ReachedSetExecutor)parent.getKey(), ((ReachedSetExecutor)parent.getKey()).asRunnable((Collection)parent.getValue()));
            }
            this.dependingFrom.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDependencies(MissingBlockAbstractionState pBsme, ReachedSetExecutor subRse) {
        this.logger.logf(level, "%s :: %s -> %s", new Object[]{this, this, subRse});
        this.dependsOn.add(pBsme.getState());
        Multimap<ReachedSetExecutor, AbstractState> multimap = subRse.dependingFrom;
        synchronized (multimap) {
            subRse.dependingFrom.put((Object)this, (Object)pBsme.getState());
        }
    }

    private void handleMissingBlock(MissingBlockAbstractionState pBsme) throws UnsupportedCodeException {
        AbstractState parentState = pBsme.getState();
        @Nullable ReachedSet reached = pBsme.getReachedSet();
        assert (this.rs.contains(parentState)) : "parent reachedset must contain entry state";
        this.logger.logf(level, "%s :: missing block, bsme=%s, reached=%s", new Object[]{this, ReachedSetExecutor.id(parentState), reached == null ? reached : ReachedSetExecutor.id(reached)});
        this.rs.remove(pBsme);
        if (this.targetStateFound) {
            this.logger.logf(Level.SEVERE, "%s :: after finding a missing block, we should not get new states", new Object[]{this});
            throw new AssertionError((Object)"after finding a missing block, we should not get new states");
        }
        CFANode entryLocation = AbstractStates.extractLocation(parentState);
        if (this.hasRecursion(entryLocation)) {
            this.rs.reAddToWaitlist(parentState);
            throw new UnsupportedCodeException("recursion", entryLocation.getLeavingEdge(0));
        }
        ReachedSetExecutor subRse = this.createAndRegisterNewReachedSet(pBsme);
        this.addDependencies(pBsme, subRse);
        this.registerJob(subRse, subRse.asRunnable());
        this.registerJob(this, this.asRunnable());
    }

    private boolean hasRecursion(CFANode pEntryLocation) {
        return Iterables.any((Iterable)Traverser.forGraph(rse -> rse.dependingFrom.keys()).breadthFirst((Object)this), rse -> rse.block.getCallNodes().contains(pEntryLocation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReachedSetExecutor createAndRegisterNewReachedSet(MissingBlockAbstractionState pBsme) {
        BAMDataManager data;
        ReachedSet newRs = pBsme.getReachedSet();
        BAMDataManager bAMDataManager = data = this.bamcpa.getData();
        synchronized (bAMDataManager) {
            BAMCache.BAMCacheEntry entry;
            if (newRs == null) {
                entry = data.getCache().get(pBsme.getReducedState(), pBsme.getReducedPrecision(), pBsme.getBlock());
                ReachedSet reachedSet = newRs = entry == null ? null : entry.getReachedSet();
            }
            if (newRs == null) {
                entry = data.createAndRegisterNewReachedSet(pBsme.getReducedState(), pBsme.getReducedPrecision(), pBsme.getBlock());
                newRs = entry.getReachedSet();
            }
        }
        ReachedSetExecutor subRse = this.reachedSetMapping.computeIfAbsent(newRs, newRs2 -> new ReachedSetExecutor(this.bamcpa, (ReachedSet)newRs2, pBsme.getBlock(), false, this.reachedSetMapping, this.pool, this.algorithmFactory, this.shutdownNotifier, this.stats, this.errors, this.terminateAnalysis, this.scheduledJobs, this.logger));
        this.logger.logf(level, "%s :: register sub%s", new Object[]{this, subRse});
        return subRse;
    }

    private void registerJob(ReachedSetExecutor pRse, Runnable r) {
        this.logger.logf(level, "%s :: scheduling %s", new Object[]{this, pRse});
        pRse.addNewTask(r);
    }

    private Block getBlockForState(AbstractState state) {
        CFANode location = AbstractStates.extractLocation(state);
        assert (this.bamcpa.getBlockPartitioning().isCallNode(location)) : "root of reached-set must be located at block entry.";
        return this.bamcpa.getBlockPartitioning().getBlockForCallNode(location);
    }

    public String toString() {
        return "RSE " + ReachedSetExecutor.id(this.rs);
    }

    String getDependenciesAsDot() {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (ReachedSetExecutor rse : this.reachedSetMapping.values()) {
            for (ReachedSetExecutor dependentRse : rse.dependingFrom.keys()) {
                dependencies.add(String.format("\"%s\" -> \"%s\"", rse, dependentRse));
            }
        }
        Collections.sort(dependencies);
        return "digraph DEPENDENCIES {\n  " + Joiner.on((String)";\n  ").join(dependencies) + ";\n}\n";
    }

    class ExceptionHandler
    implements Function<Throwable, Void> {
        private final ReachedSetExecutor rse;

        public ExceptionHandler(ReachedSetExecutor pRse) {
            this.rse = pRse;
        }

        @Override
        public Void apply(Throwable e) {
            ReachedSetExecutor.this.errors.add(e);
            this.rse.terminateAnalysis.set(true);
            return null;
        }
    }
}

