/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofCheckAlgorithm;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.util.ValidationConfigurationBuilder;
import org.sosy_lab.cpachecker.util.error.DummyErrorState;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

@Options(prefix="pcc")
public class ConfigReadingProofCheckAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, name="proof", description="file in which proof representation needed for proof checking is stored")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    protected Path proofFile = Path.of("arg.obj", new String[0]);
    private final Configuration valConfig;
    private final ProofCheckAlgorithm checkingAlgorithm;
    private final CoreComponentsFactory coreFact;
    private final ConfigurableProgramAnalysis valCPA;
    private final CFA cfa;

    public ConfigReadingProofCheckAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Specification pSpecification) throws InvalidConfigurationException, CPAException, InterruptedException {
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.valConfig = this.readValidationConfiguration();
        this.coreFact = new CoreComponentsFactory(this.valConfig, pLogger, pShutdownNotifier, AggregatedReachedSets.empty());
        ConfigurationBuilder configBuilder = Configuration.builder();
        configBuilder.copyFrom(pConfig);
        configBuilder.copyOptionFrom(this.valConfig, "pcc.strategy");
        this.valCPA = this.instantiateCPA(pCfa, pSpecification);
        GlobalInfo.getInstance().setUpInfoFromCPA(this.valCPA);
        this.checkingAlgorithm = new ProofCheckAlgorithm(this.valCPA, configBuilder.build(), pLogger, pShutdownNotifier, pCfa, pSpecification);
    }

    private Configuration readValidationConfiguration() throws InvalidConfigurationException {
        try {
            return ValidationConfigurationBuilder.readConfigFromProof(this.proofFile);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Failed to read and build validation configuration from proof", (Throwable)e);
        }
    }

    private ConfigurableProgramAnalysis instantiateCPA(CFA pCfa, Specification pSpecification) throws InvalidConfigurationException, InterruptedException {
        try {
            return this.coreFact.createCPA(pCfa, pSpecification);
        }
        catch (CPAException e) {
            throw new InvalidConfigurationException("Failed to read and build validation configuration from proof", (Throwable)e);
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.checkingAlgorithm.collectStatistics(pStatsCollection);
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        ReachedSet internalReached = this.coreFact.createReachedSet(this.valCPA);
        internalReached.add(this.valCPA.getInitialState(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition()), this.valCPA.getInitialPrecision(this.cfa.getMainFunction(), StateSpacePartition.getDefaultPartition()));
        Algorithm.AlgorithmStatus status = this.checkingAlgorithm.run(internalReached);
        pReachedSet.popFromWaitlist();
        if (!status.isSound()) {
            pReachedSet.add(new DummyErrorState(pReachedSet.getFirstState()), SingletonPrecision.getInstance());
        }
        return status;
    }
}

