/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractWrapperState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.HistoryForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.alwaystop.AlwaysTopCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonStateARGCombiningHelper;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

public class PartialARGsCombiner
implements Algorithm,
StatisticsProvider {
    private final Algorithm restartAlgorithm;
    private final LogManagerWithoutDuplicates logger;
    private final ShutdownNotifier shutdown;
    private final AutomatonStateARGCombiningHelper automatonARGBuilderSupport;
    private final ARGCombinerStatistics stats = new ARGCombinerStatistics();
    private final ReachedSetFactory reachedSetFactory;

    public PartialARGsCombiner(Algorithm pAlgorithm, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        this.restartAlgorithm = pAlgorithm;
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.shutdown = pShutdownNotifier;
        this.automatonARGBuilderSupport = new AutomatonStateARGCombiningHelper();
        this.reachedSetFactory = new ReachedSetFactory(pConfig, pLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status;
        block17: {
            Preconditions.checkArgument((boolean)(pReachedSet instanceof ForwardingReachedSet), (Object)"PartialARGsCombiner needs ForwardingReachedSet");
            HistoryForwardingReachedSet reached = new HistoryForwardingReachedSet(pReachedSet);
            this.logger.log(Level.INFO, new Object[]{"Start inner algorithm to analyze program(s)"});
            status = Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
            this.stats.analysisTime.start();
            try {
                status = this.restartAlgorithm.run(reached);
            }
            finally {
                this.stats.analysisTime.stop();
            }
            if (status.isSound()) {
                this.shutdown.shutdownIfNecessary();
                this.logger.log(Level.INFO, new Object[]{"Program(s) soundly analyzed, start combining ARGs."});
                this.stats.argCombineTime.start();
                try {
                    List<ReachedSet> usedReachedSets = reached.getAllReachedSetsUsedAsDelegates();
                    if (usedReachedSets.size() <= 1) {
                        this.logger.log(Level.INFO, new Object[]{"Only a single ARG is considered. Do not need to combine ARGs"});
                        if (usedReachedSets.size() == 1) {
                            ((ForwardingReachedSet)pReachedSet).setDelegate(reached.getDelegate());
                        }
                        Algorithm.AlgorithmStatus algorithmStatus = status;
                        return algorithmStatus;
                    }
                    if (reached.wasTargetReached()) {
                        this.logger.log(Level.INFO, new Object[]{"Error found, do not combine ARGs."});
                        ((ForwardingReachedSet)pReachedSet).setDelegate(reached.getDelegate());
                        Algorithm.AlgorithmStatus algorithmStatus = status;
                        return algorithmStatus;
                    }
                    this.logger.log(Level.FINE, new Object[]{"Extract root nodes of ARGs"});
                    ArrayList<ARGState> rootNodes = new ArrayList<ARGState>(usedReachedSets.size());
                    for (ReachedSet usedReached : usedReachedSets) {
                        Preconditions.checkArgument((boolean)(usedReached.getFirstState() instanceof ARGState), (Object)"Require that all restart configurations use ARGCPA as top level CPA.");
                        Preconditions.checkArgument((AbstractStates.extractLocation(usedReached.getFirstState()) != null ? 1 : 0) != 0, (Object)"Require that all restart configurations consider a location aware state");
                        for (AbstractState errorState : FluentIterable.from((Iterable)usedReached).filter(AbstractStates::isTargetState)) {
                            this.logger.log(Level.FINE, new Object[]{"Remove infeasible error state", errorState});
                            ((ARGState)errorState).removeFromARG();
                        }
                        rootNodes.add((ARGState)usedReached.getFirstState());
                    }
                    this.shutdown.shutdownIfNecessary();
                    if (!this.combineARGs(rootNodes, (ForwardingReachedSet)pReachedSet, reached)) {
                        this.logger.log(Level.SEVERE, new Object[]{"Combination of ARGs failed."});
                        Algorithm.AlgorithmStatus algorithmStatus = status.withSound(false);
                        return algorithmStatus;
                    }
                    break block17;
                }
                finally {
                    this.stats.argCombineTime.stop();
                }
            }
            this.logger.log(Level.INFO, new Object[]{"Program analysis is already unsound.", "Do not continue with combination of unsound results"});
            if (reached.getDelegate() != pReachedSet) {
                ((ForwardingReachedSet)pReachedSet).setDelegate(reached.getDelegate());
            }
            return status.withSound(false);
        }
        this.logger.log(Level.INFO, new Object[]{"Finished combination of ARGS"});
        return status.withSound(true);
    }

    private boolean combineARGs(List<ARGState> roots, ForwardingReachedSet pReceivedReachedSet, HistoryForwardingReachedSet pForwaredReachedSet) throws InterruptedException, CPAException {
        Pair<Map<String, Integer>, List<AbstractState>> initStates = this.identifyCompositeStateTypesAndTheirInitialInstances(roots);
        Map<String, Integer> stateToPos = initStates.getFirst();
        List<AbstractState> initialStates = initStates.getSecond();
        pReceivedReachedSet.setDelegate(this.reachedSetFactory.create(AlwaysTopCPA.INSTANCE));
        this.shutdown.shutdownIfNecessary();
        ARGState combinedRoot = new ARGState(new CompositeState(initialStates), null);
        ArrayList<List<ARGState>> successorsForEdge = new ArrayList<List<ARGState>>(initialStates.size());
        EdgeSuccessor edgeSuccessorIdentifier = new EdgeSuccessor();
        HashMap<Pair, ARGState> constructedCombinedStates = new HashMap<Pair, ARGState>();
        ArrayDeque<Pair<List<ARGState>, ARGState>> toVisit = new ArrayDeque<Pair<List<ARGState>, ARGState>>();
        toVisit.add(Pair.of(roots, combinedRoot));
        while (!toVisit.isEmpty()) {
            this.shutdown.shutdownIfNecessary();
            Collection components = (Collection)((Pair)toVisit.peek()).getFirst();
            ARGState composedState = (ARGState)((Pair)toVisit.poll()).getSecond();
            pReceivedReachedSet.add(composedState, SingletonPrecision.getInstance());
            pReceivedReachedSet.removeOnlyFromWaitlist(composedState);
            CFANode locPred = AbstractStates.extractLocation(composedState);
            block1: for (CFAEdge succEdge : CFAUtils.allLeavingEdges(locPred)) {
                this.shutdown.shutdownIfNecessary();
                successorsForEdge.clear();
                edgeSuccessorIdentifier.setCFAEdge(succEdge);
                for (ARGState component : components) {
                    edgeSuccessorIdentifier.setPredecessor(component);
                    successorsForEdge.add(Lists.newArrayList((Iterable)Iterables.filter(component.getChildren(), (Predicate)edgeSuccessorIdentifier)));
                    if (!((List)successorsForEdge.get(successorsForEdge.size() - 1)).isEmpty() || !this.noConcreteSuccessorExist(component, succEdge, pForwaredReachedSet)) continue;
                    continue block1;
                }
                for (Pair combinedSuccessor : this.computeCartesianProduct(successorsForEdge, stateToPos, initialStates)) {
                    if (constructedCombinedStates.containsKey(combinedSuccessor)) {
                        ((ARGState)constructedCombinedStates.get(combinedSuccessor)).addParent(composedState);
                        continue;
                    }
                    ARGState composedSuccessor = new ARGState(new CompositeState((List)combinedSuccessor.getFirst()), composedState);
                    constructedCombinedStates.put(combinedSuccessor, composedSuccessor);
                    toVisit.add(Pair.of((List)combinedSuccessor.getSecond(), composedSuccessor));
                }
            }
        }
        return true;
    }

    private boolean noConcreteSuccessorExist(ARGState pPredecessor, CFAEdge pSuccEdge, HistoryForwardingReachedSet pForwaredReachedSet) {
        boolean inReached = false;
        for (ReachedSet reached : pForwaredReachedSet.getAllReachedSetsUsedAsDelegates()) {
            if (reached.getWaitlist().contains(pPredecessor)) {
                return false;
            }
            if (!reached.contains(pPredecessor)) continue;
            inReached = true;
        }
        if (!inReached) {
            return false;
        }
        for (AbstractState state : AbstractStates.asIterable(pPredecessor)) {
            if (!(state instanceof AutomatonState) || !((AutomatonState)state).getOwningAutomatonName().equals("AssumptionAutomaton") || !AutomatonStateARGCombiningHelper.endsInAssumptionTrueState((AutomatonState)state, pSuccEdge, (LogManager)this.logger)) continue;
            return false;
        }
        return true;
    }

    private Pair<Map<String, Integer>, List<AbstractState>> identifyCompositeStateTypesAndTheirInitialInstances(Collection<ARGState> rootNodes) throws InterruptedException, CPAException {
        String name;
        Iterable<AbstractState> wrapped;
        this.logger.log(Level.FINE, new Object[]{"Derive composite state structure of combined ARG"});
        ArrayList<AbstractState> initialState = new ArrayList<AbstractState>();
        HashMap<String, Integer> stateToPos = new HashMap<String, Integer>();
        ArrayList<String> automataStateNames = new ArrayList<String>();
        int nextId = 0;
        this.logger.log(Level.FINE, new Object[]{"Add non-automaton states"});
        for (ARGState root : rootNodes) {
            this.shutdown.shutdownIfNecessary();
            wrapped = this.getWrappedStates(root);
            for (AbstractState innerWrapped : wrapped) {
                this.shutdown.shutdownIfNecessary();
                if (innerWrapped instanceof AssumptionStorageState) continue;
                name = this.getName(innerWrapped);
                if (stateToPos.containsKey(name)) {
                    if (((AbstractState)initialState.get((Integer)stateToPos.get(name))).equals(innerWrapped)) continue;
                    this.logger.log(Level.WARNING, new Object[]{"Abstract state ", innerWrapped.getClass(), " is used by multiple configurations, but cannot check that always start in the same initial state as it is assumed"});
                    continue;
                }
                assert (initialState.size() == nextId);
                if (innerWrapped instanceof AutomatonState) {
                    automataStateNames.add(name);
                    continue;
                }
                stateToPos.put(name, nextId);
                initialState.add(innerWrapped);
                ++nextId;
            }
        }
        this.logger.log(Level.FINE, new Object[]{"Add automaton states related to specification"});
        Collections.sort(automataStateNames);
        int numRootStates = rootNodes.size();
        TreeSet<String> commonAutomataStates = new TreeSet<String>();
        int j = 0;
        for (int i = 1; i < automataStateNames.size(); ++i) {
            assert (j < i && j >= 0);
            if (((String)automataStateNames.get(j)).equals(automataStateNames.get(i))) {
                if (j + numRootStates - 1 != i) continue;
                commonAutomataStates.add((String)automataStateNames.get(j));
                continue;
            }
            j = i;
        }
        ARGState root = rootNodes.iterator().next();
        wrapped = root.getWrappedState() instanceof AbstractWrapperState ? ((AbstractWrapperState)root.getWrappedState()).getWrappedStates() : Collections.singleton(root.getWrappedState());
        for (AbstractState innerWrapped : wrapped) {
            this.shutdown.shutdownIfNecessary();
            name = this.getName(innerWrapped);
            if (!commonAutomataStates.contains(name)) continue;
            assert (initialState.size() == nextId);
            stateToPos.put(name, nextId);
            if (!this.automatonARGBuilderSupport.registerAutomaton((AutomatonState)innerWrapped)) {
                this.logger.log(Level.SEVERE, new Object[]{"Property specification, given by automata specification, is ambigous."});
                throw new CPAException("Ambigious property specification,  automata specification contains automata with same name or same state names");
            }
            initialState.add(this.automatonARGBuilderSupport.replaceStateByStateInAutomatonOfSameInstance((AutomatonState)innerWrapped));
            ++nextId;
        }
        return Pair.of(stateToPos, initialState);
    }

    private Iterable<AbstractState> getWrappedStates(ARGState wrapper) {
        if (wrapper.getWrappedState() instanceof AbstractWrapperState) {
            return ((AbstractWrapperState)wrapper.getWrappedState()).getWrappedStates();
        }
        return Collections.singleton(wrapper.getWrappedState());
    }

    private String getName(AbstractState pState) {
        if (pState instanceof AutomatonState) {
            return ((AutomatonState)pState).getOwningAutomatonName();
        }
        if (pState instanceof PredicateAbstractState) {
            return PredicateAbstractState.class.getName();
        }
        return pState.getClass().getName();
    }

    private Collection<Pair<List<AbstractState>, List<ARGState>>> computeCartesianProduct(List<List<ARGState>> pSuccessorsForEdge, Map<String, Integer> pStateToPos, List<AbstractState> pInitialStates) throws InterruptedException, CPAException {
        int count = 0;
        for (List<ARGState> successor : pSuccessorsForEdge) {
            if (successor.isEmpty()) continue;
            count = count == 0 ? successor.size() : count * successor.size();
        }
        if (count == 0) {
            return ImmutableSet.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        int[] indices = new int[pSuccessorsForEdge.size()];
        int nextIndex = 0;
        int lastSize = pSuccessorsForEdge.get(pSuccessorsForEdge.size() - 1).size();
        if (lastSize == 0) {
            lastSize = 1;
        }
        while (indices[indices.length - 1] < lastSize) {
            this.shutdown.shutdownIfNecessary();
            ArrayList<ARGState> argSuccessors = new ArrayList<ARGState>(pSuccessorsForEdge.size());
            for (int index = 0; index < indices.length; ++index) {
                if (pSuccessorsForEdge.get(index).isEmpty()) continue;
                argSuccessors.add(this.getUncoveredSuccessor(pSuccessorsForEdge.get(index).get(indices[index])));
            }
            result.add(Pair.of(this.combineARGStates(argSuccessors, pStateToPos, pInitialStates), argSuccessors));
            int n = nextIndex;
            indices[n] = indices[n] + 1;
            boolean restart = false;
            while (indices[nextIndex] >= pSuccessorsForEdge.get(nextIndex).size() && nextIndex < indices.length - 1) {
                int n2 = ++nextIndex;
                indices[n2] = indices[n2] + 1;
                restart = true;
            }
            while (restart && nextIndex > 0) {
                indices[--nextIndex] = 0;
            }
        }
        return result.build();
    }

    private ARGState getUncoveredSuccessor(ARGState pMaybeCovered) {
        while (pMaybeCovered.isCovered()) {
            pMaybeCovered = pMaybeCovered.getCoveringState();
        }
        return pMaybeCovered;
    }

    private List<AbstractState> combineARGStates(List<ARGState> combiningStates, Map<String, Integer> pStateToPos, List<AbstractState> pInitialStates) throws InterruptedException, CPAException {
        ArrayList<AbstractState> result = new ArrayList<AbstractState>(pInitialStates);
        for (ARGState combiner : combiningStates) {
            this.shutdown.shutdownIfNecessary();
            Iterable<AbstractState> wrapped = this.getWrappedStates(combiner);
            for (AbstractState innerWrapped : wrapped) {
                this.shutdown.shutdownIfNecessary();
                if (!pStateToPos.containsKey(this.getName(innerWrapped))) {
                    Preconditions.checkState((innerWrapped instanceof AutomatonState || innerWrapped instanceof AssumptionStorageState ? 1 : 0) != 0, (Object)"Found state which is not considered in combined composite state and which is not due to the use of an assumption automaton");
                    continue;
                }
                int index = pStateToPos.get(this.getName(innerWrapped));
                if (pInitialStates.get(index) == result.get(index)) {
                    if (result.get(index) instanceof AutomatonState) {
                        result.set(index, this.automatonARGBuilderSupport.replaceStateByStateInAutomatonOfSameInstance((AutomatonState)innerWrapped));
                        continue;
                    }
                    result.set(index, innerWrapped);
                    continue;
                }
                this.logger.logOnce(Level.WARNING, new Object[]{"Cannot identify the inner state which is more precise, use the earliest found. Combination may be unsound."});
            }
        }
        return result;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.restartAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.restartAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    private static class ARGCombinerStatistics
    implements Statistics {
        private final Timer argCombineTime = new Timer();
        private final Timer analysisTime = new Timer();

        private ARGCombinerStatistics() {
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("Time for program analyis: " + this.analysisTime);
            out.println("Time to combine ARGs:     " + this.argCombineTime);
        }

        @Override
        public @Nullable String getName() {
            return "ARG Combiner Statistics";
        }
    }

    private static class EdgeSuccessor
    implements Predicate<ARGState> {
        private @Nullable CFAEdge edge;
        private @Nullable ARGState predecessor;

        private EdgeSuccessor() {
        }

        public boolean apply(ARGState pChild) {
            return pChild != null && this.predecessor.getEdgeToChild(pChild) == this.edge;
        }

        private void setCFAEdge(CFAEdge pEdge) {
            this.edge = pEdge;
        }

        private void setPredecessor(ARGState pPred) {
            this.predecessor = pPred;
        }
    }
}

