/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PCCStrategy;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.PCCStrategyBuilder;
import org.sosy_lab.cpachecker.util.error.DummyErrorState;

@Options(prefix="pcc")
public class ProofCheckAlgorithm
implements Algorithm,
StatisticsProvider {
    private final CPAStatistics stats = new CPAStatistics();
    protected final LogManager logger;
    protected final PCCStrategy checkingStrategy;
    @Option(secure=true, name="proof", description="file in which proof representation needed for proof checking is stored")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    protected Path proofFile = Path.of("arg.obj", new String[0]);

    public ProofCheckAlgorithm(ConfigurableProgramAnalysis cpa, Configuration pConfig, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Specification specification) throws InvalidConfigurationException, CPAException {
        pConfig.inject((Object)this, ProofCheckAlgorithm.class);
        if (!this.proofFile.toFile().exists()) {
            throw new InvalidConfigurationException("Cannot find proof file. File " + this.proofFile + " does not exists.");
        }
        this.checkingStrategy = PCCStrategyBuilder.buildStrategy(pConfig, logger, pShutdownNotifier, this.proofFile, cpa, pCfa, specification);
        this.logger = logger;
        logger.log(Level.INFO, new Object[]{"Start reading proof."});
        this.stats.totalTimer.start();
        this.stats.readTimer.start();
        try {
            this.checkingStrategy.readProof();
        }
        catch (IOException | ClassNotFoundException | InvalidConfigurationException e) {
            throw new CPAException("Failed reading proof", e);
        }
        finally {
            this.stats.readTimer.stop();
            this.stats.totalTimer.stop();
        }
        logger.log(Level.INFO, new Object[]{"Finished reading proof."});
    }

    protected ProofCheckAlgorithm(Configuration pConfig, LogManager logger, ShutdownNotifier pShutdownNotifier, ReachedSet pReachedSet, CFA pCfa, Specification specification) throws InvalidConfigurationException, InterruptedException {
        pConfig.inject((Object)this, ProofCheckAlgorithm.class);
        ConfigurableProgramAnalysis cpa = pReachedSet.getCPA();
        this.checkingStrategy = PCCStrategyBuilder.buildStrategy(pConfig, logger, pShutdownNotifier, this.proofFile, cpa, pCfa, specification);
        this.logger = logger;
        Preconditions.checkArgument((pReachedSet != null && !pReachedSet.hasWaitingState() ? 1 : 0) != 0, (Object)"Parameter pReachedSet may not be null and may not have any states in its waitlist.");
        this.stats.totalTimer.start();
        this.checkingStrategy.constructInternalProofRepresentation(pReachedSet, cpa);
        this.stats.totalTimer.stop();
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Proof check algorithm started."});
        this.stats.totalTimer.start();
        boolean result = this.checkingStrategy.checkCertificate(reachedSet);
        this.stats.totalTimer.stop();
        this.logger.log(Level.INFO, new Object[]{"Proof check algorithm finished."});
        if (!result) {
            reachedSet.add(new DummyErrorState(reachedSet.getFirstState()), SingletonPrecision.getInstance());
        }
        return Algorithm.AlgorithmStatus.SOUND_AND_PRECISE.withSound(result);
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
        if (this.checkingStrategy instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.checkingStrategy)).collectStatistics(pStatsCollection);
        }
    }

    private static class CPAStatistics
    implements Statistics {
        private Timer totalTimer = new Timer();
        private Timer readTimer = new Timer();

        private CPAStatistics() {
        }

        @Override
        public String getName() {
            return "Proof Check algorithm";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println();
            out.println("Proof Checking statistics");
            out.println("-------------------------------------");
            out.println("Total time for proof check algorithm:     " + this.totalTimer);
            out.println("  Time for reading in proof (not complete time in interleaved modes):  " + this.readTimer);
        }
    }
}

