/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import java.io.IOException;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofCheckAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.arg.AbstractARGStrategy;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionApplications;
import org.sosy_lab.cpachecker.util.ci.CustomInstructionRequirementsExtractor;

@Options
public class ProofCheckAndExtractCIRequirementsAlgorithm
extends ProofCheckAlgorithm {
    private final CustomInstructionApplications.CustomInstructionApplicationBuilder ciasBuilder;
    private final CustomInstructionRequirementsExtractor ciExtractor;
    private final ConfigurableProgramAnalysis cpa;
    @Option(secure=true, name="pcc.HWrequirements.extraction.mode", description="Specifies the mode how HW requirements are detected in the proof.")
    private CustomInstructionApplications.CustomInstructionApplicationBuilder.CIDescriptionType ciMode = CustomInstructionApplications.CustomInstructionApplicationBuilder.CIDescriptionType.OPERATOR;

    public ProofCheckAndExtractCIRequirementsAlgorithm(ConfigurableProgramAnalysis pCpa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Specification pSpecification) throws InvalidConfigurationException, CPAException {
        super(pCpa, pConfig, pLogger, pShutdownNotifier, pCfa, pSpecification);
        pConfig.inject((Object)this);
        this.ciasBuilder = CustomInstructionApplications.CustomInstructionApplicationBuilder.getBuilder(this.ciMode, pConfig, pLogger, pShutdownNotifier, pCfa);
        this.ciExtractor = new CustomInstructionRequirementsExtractor(pConfig, pLogger, pShutdownNotifier, pCpa);
        this.cpa = pCpa;
        Class<? extends AbstractState> requirementsStateClass = this.ciExtractor.getRequirementsStateClass();
        try {
            if (AbstractStates.extractStateByType(pCpa.getInitialState(pCfa.getMainFunction(), StateSpacePartition.getDefaultPartition()), requirementsStateClass) == null) {
                throw new InvalidConfigurationException(requirementsStateClass + "is not an abstract state.");
            }
        }
        catch (InterruptedException e) {
            throw new InvalidConfigurationException(requirementsStateClass + "initial state computation did not finish in time");
        }
        if (!(this.checkingStrategy instanceof AbstractARGStrategy)) {
            throw new InvalidConfigurationException("Custom instruction requirements extraction only works with proofs that are ARGs.");
        }
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet reachedSet) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status;
        CustomInstructionApplications cia;
        try {
            this.logger.log(Level.INFO, new Object[]{"Get custom instruction applications in program."});
            cia = this.ciasBuilder.identifyCIApplications();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Detecting the custom instruction applications in program failed.", e});
            return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
        }
        if (this.ciExtractor.getRequirementsStateClass().equals(PredicateAbstractState.class)) {
            PredicateCPA predCPA = CPAs.retrieveCPA(this.cpa, PredicateCPA.class);
            if (predCPA == null) {
                this.logger.log(Level.SEVERE, new Object[]{"Cannot find PredicateCPA in CPA configuration but it is required to set abstraction nodes"});
                return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
            }
            predCPA.changeExplicitAbstractionNodes(cia.getStartAndEndLocationsOfCIApplications());
        }
        if ((status = super.run(reachedSet)).isSound()) {
            this.logger.log(Level.INFO, new Object[]{"Extracting custom instruction requirements."});
            this.ciExtractor.extractRequirements(((AbstractARGStrategy)this.checkingStrategy).getARG(), cia);
        } else {
            this.logger.log(Level.INFO, new Object[]{"Proof checking failed, do not extract requirements!"});
        }
        return status;
    }
}

