/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import java.io.PrintStream;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofSlicer;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PCCStrategy;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.pcc.strategy.PCCStrategyBuilder;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options
public class ProofGenerator {
    @Option(secure=true, name="pcc.sliceProof", description="Make proof more abstract, remove some of the information not needed to prove the property.")
    private boolean slicingEnabled = false;
    @Option(secure=true, name="pcc.proofFile", description="file in which proof representation will be stored")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    protected Path file = Path.of("arg.obj", new String[0]);
    private final PCCStrategy checkingStrategy;
    private final LogManager logger;
    private final Timer writingTimer = new Timer();
    private final @Nullable ProofSlicer slicer;
    private final Statistics proofGeneratorStats = new Statistics(){

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            pOut.println();
            pOut.println(this.getName() + " statistics");
            pOut.println("------------------------------------");
            pOut.println("Time for proof writing: " + ProofGenerator.this.writingTimer);
            if (ProofGenerator.this.checkingStrategy != null) {
                for (Statistics stats : ProofGenerator.this.checkingStrategy.getAdditionalProofGenerationStatistics()) {
                    StatisticsUtils.printStatistics(stats, pOut, ProofGenerator.this.logger, pResult, pReached);
                }
            }
        }

        @Override
        public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (ProofGenerator.this.checkingStrategy != null) {
                for (Statistics stats : ProofGenerator.this.checkingStrategy.getAdditionalProofGenerationStatistics()) {
                    StatisticsUtils.writeOutputFiles(stats, ProofGenerator.this.logger, pResult, pReached);
                }
            }
        }

        @Override
        public String getName() {
            return "Proof Generation";
        }
    };

    public ProofGenerator(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.checkingStrategy = PCCStrategyBuilder.buildStrategy(pConfig, pLogger, pShutdownNotifier, this.file, null, null, null);
        this.slicer = this.slicingEnabled ? new ProofSlicer(pLogger) : null;
    }

    public void generateProof(CPAcheckerResult pResult) {
        if (pResult.getResult() != CPAcheckerResult.Result.TRUE) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be generated because checked property not known to be true."});
            return;
        }
        if (pResult.getReached() == null) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be generated because reached set not available"});
        }
        this.constructAndWriteProof(pResult.getReached());
        pResult.addProofGeneratorStatistics(this.proofGeneratorStats);
    }

    private void constructAndWriteProof(ReachedSet pReached) {
        UnmodifiableReachedSet reached = pReached;
        if (this.slicer != null) {
            this.logger.log(Level.INFO, new Object[]{"Start slicing of proof"});
            reached = this.slicer.sliceProof(reached, pReached.getCPA());
        }
        this.logger.log(Level.INFO, new Object[]{"Proof Generation started."});
        this.writingTimer.start();
        this.checkingStrategy.writeProof(reached, pReached.getCPA());
        this.writingTimer.stop();
        this.logger.log(Level.INFO, new Object[]{"Writing proof took " + this.writingTimer.getMaxTime().formatAs(TimeUnit.SECONDS)});
    }

    protected Statistics generateProofUnchecked(ReachedSet pReached) {
        this.constructAndWriteProof(pReached);
        return this.proofGeneratorStats;
    }
}

