/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.composite.CompositeState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ProofSlicer {
    private final ReachedSetFactory reachedSetFactory;
    private int numNotCovered;

    public ProofSlicer(LogManager pLogger) throws InvalidConfigurationException {
        this.reachedSetFactory = new ReachedSetFactory(Configuration.defaultConfiguration(), pLogger);
    }

    public UnmodifiableReachedSet sliceProof(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) {
        AbstractState first = pReached.getFirstState();
        if (first instanceof ARGState && AbstractStates.extractLocation(first) != null && AbstractStates.extractStateByType(first, ValueAnalysisState.class) != null && AbstractStates.extractStateByType(first, CallstackState.class) != null && ((ARGState)first).getWrappedState() instanceof CompositeState) {
            this.numNotCovered = 0;
            HashMap varMap = Maps.newHashMapWithExpectedSize((int)pReached.size());
            this.computeRelevantVariablesPerState((ARGState)first, varMap);
            assert (this.numNotCovered == pReached.size());
            return this.buildSlicedARG(varMap, pReached, pCpa);
        }
        return pReached;
    }

    private void computeRelevantVariablesPerState(ARGState root, Map<ARGState, Set<String>> varMap) {
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        this.initializeStates(root, varMap, waitlist);
        while (!waitlist.isEmpty()) {
            ARGState next = (ARGState)waitlist.pop();
            for (ARGState succ : this.getStateAndItsCoveredNodes(next)) {
                assert (varMap.containsKey(succ));
                for (ARGState p : succ.getParents()) {
                    if (p.getEdgeToChild(succ) == null) {
                        if (!this.computeTransferTo(p, succ, varMap.get(succ), varMap)) continue;
                        waitlist.push(p);
                        continue;
                    }
                    if (!this.computeTransferTo(p, p.getEdgeToChild(succ), varMap.get(succ), varMap)) continue;
                    waitlist.push(p);
                }
            }
        }
    }

    private Collection<ARGState> getStateAndItsCoveredNodes(ARGState state) {
        HashSet<ARGState> result = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(state);
        result.add(state);
        while (!waitlist.isEmpty()) {
            for (ARGState covered : ((ARGState)waitlist.pop()).getCoveredByThis()) {
                if (!result.add(covered)) continue;
                waitlist.add(covered);
            }
        }
        return result;
    }

    private boolean computeTransferTo(ARGState pred, ARGState succ, Set<String> succVars, Map<ARGState, Set<String>> varMap) {
        assert (varMap.containsKey(pred));
        HashSet<String> updatedVars = new HashSet<String>((Collection)varMap.get(pred));
        HashSet<String> sSet = new HashSet<String>(succVars);
        HashSet<String> pSet = new HashSet<String>();
        List<CFAEdge> edges = pred.getEdgesToChild(succ);
        for (int i = edges.size() - 1; i >= 0; --i) {
            this.addTransferSet(edges.get(i), sSet, pSet);
            sSet = pSet;
            pSet = new HashSet();
        }
        updatedVars.addAll(sSet);
        if (varMap.get(pred).size() != updatedVars.size()) {
            assert (varMap.get(pred).size() < updatedVars.size());
            varMap.put(pred, updatedVars);
            this.updateCoveredNodes(pred, updatedVars, varMap);
            return true;
        }
        return false;
    }

    private boolean computeTransferTo(ARGState pred, CFAEdge edge, Set<String> succVars, Map<ARGState, Set<String>> varMap) {
        assert (varMap.containsKey(pred));
        HashSet<String> updatedPredVars = new HashSet<String>((Collection)varMap.get(pred));
        this.addTransferSet(edge, succVars, updatedPredVars);
        if (varMap.get(pred).size() != updatedPredVars.size()) {
            assert (varMap.get(pred).size() < updatedPredVars.size());
            varMap.put(pred, updatedPredVars);
            this.updateCoveredNodes(pred, updatedPredVars, varMap);
            return true;
        }
        return false;
    }

    private void addTransferSet(CFAEdge edge, Set<String> succVars, Set<String> updatedVars) {
        switch (edge.getEdgeType()) {
            case StatementEdge: {
                CStatement stm = ((CStatementEdge)edge).getStatement();
                if (stm instanceof CExpressionStatement || stm instanceof CFunctionCallStatement) {
                    updatedVars.addAll(succVars);
                } else {
                    String varNameAssigned;
                    if (stm instanceof CFunctionCallAssignmentStatement) {
                        varNameAssigned = VarNameRetriever.getVarName(((CFunctionCallAssignmentStatement)stm).getLeftHandSide());
                        if (succVars.contains(varNameAssigned)) {
                            for (CExpression expr : ((CFunctionCallAssignmentStatement)stm).getRightHandSide().getParameterExpressions()) {
                                CFAUtils.getVariableNamesOfExpression(expr).copyInto(updatedVars);
                            }
                        }
                    } else {
                        varNameAssigned = VarNameRetriever.getVarName(((CExpressionAssignmentStatement)stm).getLeftHandSide());
                        if (succVars.contains(varNameAssigned)) {
                            CFAUtils.getVariableNamesOfExpression(((CExpressionAssignmentStatement)stm).getRightHandSide()).copyInto(updatedVars);
                        }
                    }
                    if (succVars.contains(varNameAssigned)) {
                        this.addAllExceptVar(varNameAssigned, succVars, updatedVars);
                    } else {
                        updatedVars.addAll(succVars);
                    }
                }
                return;
            }
            case DeclarationEdge: {
                if (((CDeclarationEdge)edge).getDeclaration() instanceof CVariableDeclaration) {
                    CVariableDeclaration varDec = (CVariableDeclaration)((CDeclarationEdge)edge).getDeclaration();
                    String varName = varDec.getQualifiedName();
                    if (succVars.contains(varName)) {
                        if (varDec.getInitializer() != null) {
                            updatedVars.addAll(this.getInitializerVars(varDec.getInitializer()));
                        }
                        this.addAllExceptVar(varName, succVars, updatedVars);
                    } else {
                        updatedVars.addAll(succVars);
                    }
                } else {
                    updatedVars.addAll(succVars);
                }
                return;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge retStm = (CReturnStatementEdge)edge;
                if (retStm.getExpression().isPresent() && !retStm.getSuccessor().getEntryNode().getReturnVariable().isPresent()) {
                    throw new AssertionError((Object)"Return statement but no return variable available");
                }
                if (retStm.getSuccessor().getEntryNode().getReturnVariable().isPresent()) {
                    String varName = retStm.getSuccessor().getEntryNode().getReturnVariable().get().getQualifiedName();
                    this.addAllExceptVar(varName, succVars, updatedVars);
                    if (retStm.getExpression().isPresent()) {
                        CFAUtils.getVariableNamesOfExpression(retStm.getExpression().orElseThrow()).copyInto(updatedVars);
                    }
                } else {
                    updatedVars.addAll(succVars);
                }
                return;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge funCall = (CFunctionCallEdge)edge;
                HashSet<String> paramNames = new HashSet<String>();
                List<CParameterDeclaration> paramDecl = funCall.getSuccessor().getFunctionParameters();
                List<CExpression> args = funCall.getArguments();
                assert (paramDecl.size() == args.size());
                for (int i = 0; i < paramDecl.size(); ++i) {
                    String paramName = paramDecl.get(i).getQualifiedName();
                    if (!succVars.contains(paramName)) continue;
                    CFAUtils.getVariableNamesOfExpression(args.get(i)).copyInto(updatedVars);
                    paramNames.add(paramName);
                }
                for (String var : succVars) {
                    if (paramNames.contains(var)) continue;
                    updatedVars.add(var);
                }
                return;
            }
            case FunctionReturnEdge: {
                CFunctionReturnEdge funRet = (CFunctionReturnEdge)edge;
                if (funRet.getSummaryEdge().getExpression() instanceof CFunctionCallAssignmentStatement) {
                    String varName = VarNameRetriever.getVarName(((CFunctionCallAssignmentStatement)funRet.getSummaryEdge().getExpression()).getLeftHandSide());
                    this.addAllExceptVar(varName, succVars, updatedVars);
                    if (!funRet.getFunctionEntry().getReturnVariable().isPresent()) {
                        throw new AssertionError((Object)"No return variable provided for non-void function.");
                    }
                    updatedVars.add(funRet.getFunctionEntry().getReturnVariable().orElseThrow().getQualifiedName());
                } else {
                    updatedVars.addAll(succVars);
                }
                return;
            }
            case CallToReturnEdge: {
                throw new AssertionError();
            }
            case AssumeEdge: {
                ImmutableSet assumeVars = CFAUtils.getVariableNamesOfExpression(((CAssumeEdge)edge).getExpression()).toSet();
                for (String var : assumeVars) {
                    if (!succVars.contains(var)) continue;
                    updatedVars.addAll((Collection<String>)assumeVars);
                    break;
                }
            }
            case BlankEdge: {
                updatedVars.addAll(succVars);
                return;
            }
        }
        throw new AssertionError();
    }

    private Collection<? extends String> getInitializerVars(CInitializer pInitializer) {
        if (pInitializer instanceof CDesignatedInitializer) {
            throw new AssertionError((Object)"CDesignatedInitializer unsupported in slicing");
        }
        if (pInitializer instanceof CInitializerExpression) {
            return CFAUtils.getVariableNamesOfExpression(((CInitializerExpression)pInitializer).getExpression()).toSet();
        }
        HashSet<? extends String> result = new HashSet<String>();
        for (CInitializer init : ((CInitializerList)pInitializer).getInitializers()) {
            result.addAll(this.getInitializerVars(init));
        }
        return result;
    }

    private void addAllExceptVar(String varName, Set<String> toAdd, Set<String> addTo) {
        for (String var : toAdd) {
            if (var.equals(varName)) continue;
            addTo.add(var);
        }
    }

    private void initializeStates(ARGState root, Map<ARGState, Set<String>> varMap, Collection<ARGState> pWaitlist) {
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> visited = new HashSet<ARGState>();
        waitlist.add(root);
        visited.add(root);
        while (!waitlist.isEmpty()) {
            ARGState next = (ARGState)waitlist.pop();
            if (next.isCovered()) continue;
            ++this.numNotCovered;
            Set<String> init = this.initState(next);
            varMap.put(next, init);
            if (!init.isEmpty()) {
                pWaitlist.add(next);
            }
            this.updateCoveredNodes(next, init, varMap);
            for (ARGState child : next.getChildren()) {
                if (!visited.add(child)) continue;
                waitlist.add(child);
            }
        }
    }

    private Set<String> initState(ARGState parent) {
        assert (!parent.isCovered());
        for (CFAEdge edge : CFAUtils.leavingEdges(AbstractStates.extractLocation(parent))) {
            if (edge.getEdgeType() != CFAEdgeType.AssumeEdge) continue;
            for (ARGState child : parent.getChildren()) {
                if (parent.getEdgeToChild(child) != edge) continue;
            }
            return CFAUtils.getVariableNamesOfExpression(((CAssumeEdge)edge).getExpression()).toSet();
        }
        return ImmutableSet.of();
    }

    private void updateCoveredNodes(ARGState pCovering, Set<String> varSet, Map<ARGState, Set<String>> pVarMap) {
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>(pCovering.getCoveredByThis());
        while (!waitlist.isEmpty()) {
            ARGState covered = (ARGState)waitlist.pop();
            if (pVarMap.get(covered) == varSet) continue;
            pVarMap.put(covered, varSet);
            waitlist.addAll(covered.getCoveredByThis());
        }
    }

    private UnmodifiableReachedSet buildSlicedARG(Map<ARGState, Set<String>> pVarMap, UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) {
        HashMap oldToSliced = Maps.newHashMapWithExpectedSize((int)pVarMap.size());
        ARGState root = (ARGState)pReached.getFirstState();
        assert (pVarMap.containsKey(root));
        for (Map.Entry<ARGState, Set<String>> entry : pVarMap.entrySet()) {
            oldToSliced.put(entry.getKey(), this.getSlicedARGState(entry.getKey(), (Collection<String>)entry.getValue()));
        }
        for (Map.Entry<ARGState, Set<String>> entry : oldToSliced.entrySet()) {
            for (ARGState parent : entry.getKey().getParents()) {
                ((ARGState)((Object)entry.getValue())).addParent((ARGState)oldToSliced.get(parent));
            }
            if (!entry.getKey().isCovered()) continue;
            ((ARGState)((Object)entry.getValue())).setCovered((ARGState)oldToSliced.get(entry.getKey().getCoveringState()));
        }
        ReachedSet returnReached = this.reachedSetFactory.create(pCpa);
        returnReached.add((AbstractState)oldToSliced.get(root), pReached.getPrecision(root));
        for (Map.Entry entry : oldToSliced.entrySet()) {
            if (!Objects.equals(entry.getKey(), root) || ((ARGState)entry.getKey()).isCovered()) continue;
            returnReached.add((AbstractState)entry.getValue(), pReached.getPrecision((AbstractState)entry.getKey()));
        }
        return returnReached;
    }

    private ARGState getSlicedARGState(ARGState unslicedState, Collection<String> necessaryVars) {
        ImmutableList<AbstractState> compOldStates = ((CompositeState)unslicedState.getWrappedState()).getWrappedStates();
        ArrayList<AbstractState> newStates = new ArrayList<AbstractState>(compOldStates.size());
        for (AbstractState state : compOldStates) {
            newStates.add(state instanceof ValueAnalysisState ? this.sliceState((ValueAnalysisState)state, necessaryVars) : state);
        }
        return new ARGState(new CompositeState(newStates), null);
    }

    private ValueAnalysisState sliceState(ValueAnalysisState vState, Collection<String> necessaryVars) {
        ValueAnalysisState returnState = ValueAnalysisState.copyOf(vState);
        for (MemoryLocation ml : vState.getTrackedMemoryLocations()) {
            if (necessaryVars.contains(this.getVarName(ml))) continue;
            returnState.forget(ml);
        }
        return returnState;
    }

    private String getVarName(MemoryLocation pMl) {
        String prefix = pMl.isOnFunctionStack() ? pMl.getFunctionName() + "::" : "";
        return prefix + pMl.getIdentifier();
    }

    private static class VarNameRetriever
    implements CExpressionVisitor<String, NoException> {
        private static VarNameRetriever retriever = new VarNameRetriever();

        private VarNameRetriever() {
        }

        public static String getVarName(CLeftHandSide lhsAssign) {
            return lhsAssign.accept(retriever);
        }

        @Override
        public String visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
            return pIastArraySubscriptExpression.getArrayExpression().accept(this);
        }

        @Override
        public String visit(CFieldReference pIastFieldReference) {
            return pIastFieldReference.getFieldOwner().accept(this);
        }

        @Override
        public String visit(CIdExpression pIastIdExpression) {
            return pIastIdExpression.getDeclaration().getQualifiedName();
        }

        @Override
        public String visit(CPointerExpression pPointerExpression) {
            return pPointerExpression.getOperand().accept(this);
        }

        @Override
        public String visit(CComplexCastExpression pComplexCastExpression) {
            return pComplexCastExpression.getOperand().accept(this);
        }

        @Override
        public String visit(CBinaryExpression pIastBinaryExpression) {
            throw new AssertionError();
        }

        @Override
        public String visit(CCastExpression pIastCastExpression) {
            return pIastCastExpression.getOperand().accept(this);
        }

        @Override
        public String visit(CCharLiteralExpression pIastCharLiteralExpression) {
            throw new AssertionError();
        }

        @Override
        public String visit(CFloatLiteralExpression pIastFloatLiteralExpression) {
            throw new AssertionError();
        }

        @Override
        public String visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) {
            throw new AssertionError();
        }

        @Override
        public String visit(CStringLiteralExpression pIastStringLiteralExpression) {
            throw new AssertionError();
        }

        @Override
        public String visit(CTypeIdExpression pIastTypeIdExpression) {
            throw new AssertionError();
        }

        @Override
        public String visit(CUnaryExpression pIastUnaryExpression) {
            throw new AssertionError();
        }

        @Override
        public String visit(CImaginaryLiteralExpression PIastLiteralExpression) {
            throw new AssertionError();
        }

        @Override
        public String visit(CAddressOfLabelExpression pAddressOfLabelExpression) {
            throw new AssertionError();
        }
    }
}

