/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.pcc;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPABuilder;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofCheckAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofGenerator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.error.DummyErrorState;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

@Options
public class ResultCheckAlgorithm
implements Algorithm,
StatisticsProvider {
    private final LogManager logger;
    private final Configuration config;
    private final ShutdownNotifier shutdownNotifier;
    private final Algorithm analysisAlgorithm;
    private final CFA analyzedProgram;
    private final Specification specification;
    private final ResultCheckStatistics stats;
    @Option(secure=true, name="pcc.resultcheck.writeProof", description="Enable to write proof and read it again for validation instead of using the in memory solution")
    private boolean writeProof = false;
    @Option(secure=true, name="pcc.resultcheck.checkerConfig", description="Configuration for proof checking if differs from analysis configuration")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private @Nullable Path checkerConfig;

    public ResultCheckAlgorithm(Algorithm pAlgorithm, CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.analysisAlgorithm = pAlgorithm;
        this.analyzedProgram = pCfa;
        this.logger = pLogger;
        this.config = pConfig;
        this.shutdownNotifier = pShutdownNotifier;
        this.specification = (Specification)Preconditions.checkNotNull((Object)pSpecification);
        this.stats = new ResultCheckStatistics(pLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Algorithm.AlgorithmStatus status;
        block15: {
            block13: {
                this.logger.log(Level.INFO, new Object[]{"Start analysis."});
                try {
                    this.stats.analysisTimer.start();
                    status = this.analysisAlgorithm.run(pReachedSet);
                }
                catch (Throwable throwable) {
                    this.stats.analysisTimer.stop();
                    this.logger.log(Level.INFO, new Object[]{"Analysis stopped."});
                    throw throwable;
                }
                this.stats.analysisTimer.stop();
                this.logger.log(Level.INFO, new Object[]{"Analysis stopped."});
                if (!status.isSound() || pReachedSet.hasWaitingState()) break block13;
                this.logger.log(Level.INFO, new Object[]{"Analysis successful.", "Start checking analysis result"});
                try {
                    status = this.writeProof ? this.writeProofAndValidateWrittenProof(pReachedSet) : this.resultCheckingWithoutWritingProof(pReachedSet);
                }
                catch (InvalidConfigurationException e) {
                    status = status.withSound(false);
                    if (this.stats.checkTimer.isRunning()) {
                        this.stats.checkTimer.stop();
                    }
                    this.logger.log(Level.INFO, new Object[]{"Stop checking analysis result."});
                }
                catch (InterruptedException e1) {
                    this.logger.log(Level.INFO, new Object[]{"Timed out. Checking incomplete."});
                    Algorithm.AlgorithmStatus algorithmStatus = status.withSound(false);
                    {
                        catch (Throwable throwable) {
                            if (this.stats.checkTimer.isRunning()) {
                                this.stats.checkTimer.stop();
                            }
                            this.logger.log(Level.INFO, new Object[]{"Stop checking analysis result."});
                            throw throwable;
                        }
                    }
                    if (this.stats.checkTimer.isRunning()) {
                        this.stats.checkTimer.stop();
                    }
                    this.logger.log(Level.INFO, new Object[]{"Stop checking analysis result."});
                    return algorithmStatus;
                }
                if (this.stats.checkTimer.isRunning()) {
                    this.stats.checkTimer.stop();
                }
                this.logger.log(Level.INFO, new Object[]{"Stop checking analysis result."});
                if (status.isSound()) {
                    this.logger.log(Level.INFO, new Object[]{"Analysis result checked successfully."});
                    return status;
                }
                pReachedSet.add(new DummyErrorState(pReachedSet.getFirstState()), SingletonPrecision.getInstance());
                this.logger.log(Level.INFO, new Object[]{"Analysis result could not be checked."});
                break block15;
            }
            this.logger.log(Level.WARNING, new Object[]{"Analysis incomplete."});
        }
        return status;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        if (this.analysisAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.analysisAlgorithm)).collectStatistics(pStatsCollection);
        }
        pStatsCollection.add(this.stats);
    }

    private Algorithm.AlgorithmStatus resultCheckingWithoutWritingProof(ReachedSet pVerificationResult) throws InvalidConfigurationException, InterruptedException, CPAException {
        this.stats.checkTimer.start();
        ProofCheckAlgorithm checker = new ProofCheckAlgorithm(this.config, this.logger, this.shutdownNotifier, pVerificationResult, this.analyzedProgram, this.specification);
        this.stats.checkingStatsProvider = checker;
        return checker.run(this.initializeReachedSetForChecking(this.config, pVerificationResult.getCPA()));
    }

    private ReachedSet initializeReachedSetForChecking(Configuration pConfig, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, IllegalArgumentException, InterruptedException {
        CoreComponentsFactory factory = new CoreComponentsFactory(pConfig, this.logger, this.shutdownNotifier, AggregatedReachedSets.empty());
        ReachedSet reached = factory.createReachedSet(pCpa);
        reached.add(pCpa.getInitialState(this.analyzedProgram.getMainFunction(), StateSpacePartition.getDefaultPartition()), pCpa.getInitialPrecision(this.analyzedProgram.getMainFunction(), StateSpacePartition.getDefaultPartition()));
        return reached;
    }

    private Algorithm.AlgorithmStatus writeProofAndValidateWrittenProof(ReachedSet pVerificationResult) throws InvalidConfigurationException, CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Write Proof"});
        ProofGenerator proofGen = new ProofGenerator(this.config, this.logger, this.shutdownNotifier);
        this.stats.proofGenStats = proofGen.generateProofUnchecked(pVerificationResult);
        Configuration checkConfig = this.config;
        ConfigurableProgramAnalysis checkerCPA = pVerificationResult.getCPA();
        if (this.checkerConfig != null) {
            try {
                checkConfig = Configuration.builder().copyFrom(this.config).loadFromFile(this.checkerConfig).build();
                ReachedSetFactory factory = new ReachedSetFactory(checkConfig, this.logger);
                checkerCPA = new CPABuilder(checkConfig, this.logger, this.shutdownNotifier, factory).buildCPAs(this.analyzedProgram, this.specification, AggregatedReachedSets.empty());
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, new Object[]{"Cannot read proof checking configuration."});
                return Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
            }
        }
        GlobalInfo.getInstance().setUpInfoFromCPA(checkerCPA);
        this.stats.checkTimer.start();
        ProofCheckAlgorithm checker = new ProofCheckAlgorithm(checkerCPA, checkConfig, this.logger, this.shutdownNotifier, this.analyzedProgram, this.specification);
        this.stats.checkingStatsProvider = checker;
        return checker.run(this.initializeReachedSetForChecking(checkConfig, checkerCPA));
    }

    private static class ResultCheckStatistics
    implements Statistics {
        private final LogManager logger;
        private Timer checkTimer = new Timer();
        private Timer analysisTimer = new Timer();
        private @Nullable StatisticsProvider checkingStatsProvider = null;
        private final Collection<Statistics> checkingStats = new ArrayList<Statistics>();
        private @Nullable Statistics proofGenStats = null;

        ResultCheckStatistics(LogManager pLogger) {
            this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            pOut.println("Time for Verification:          " + this.analysisTimer);
            pOut.println("Time for Result Check:      " + this.checkTimer);
            if (this.checkTimer.getNumberOfIntervals() > 0) {
                pOut.println("Speed up checking:        " + (float)this.analysisTimer.getSumTime().asNanos() / (float)this.checkTimer.getSumTime().asNanos());
            }
            if (this.proofGenStats != null) {
                StatisticsUtils.printStatistics(this.proofGenStats, pOut, this.logger, pResult, pReached);
            }
            if (this.checkingStatsProvider != null) {
                if (this.checkingStats.isEmpty()) {
                    this.checkingStatsProvider.collectStatistics(this.checkingStats);
                }
                for (Statistics stats : this.checkingStats) {
                    StatisticsUtils.printStatistics(stats, pOut, this.logger, pResult, pReached);
                }
            }
        }

        @Override
        public void writeOutputFiles(CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (this.proofGenStats != null) {
                StatisticsUtils.writeOutputFiles(this.proofGenStats, this.logger, pResult, pReached);
            }
            if (this.checkingStatsProvider != null) {
                if (this.checkingStats.isEmpty()) {
                    this.checkingStatsProvider.collectStatistics(this.checkingStats);
                }
                for (Statistics stats : this.checkingStats) {
                    StatisticsUtils.writeOutputFiles(stats, this.logger, pResult, pReached);
                }
            }
        }

        @Override
        public String getName() {
            return "ResultCheckAlgorithm";
        }
    }
}

