/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.residualprogram;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.Pair;

public abstract class ConditionFolder {
    private final FOLDER_TYPE type;

    public static ConditionFolder createFolder(Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        FolderOptions opt = new FolderOptions();
        pConfig.inject((Object)opt);
        switch (opt.folderType) {
            case CFA: {
                return new CFAFolder();
            }
            case FOLD_EXCEPT_LOOPS: {
                return new ExceptLoopFolder(pCfa);
            }
            case LOOP_ALWAYS: {
                return new LoopAlwaysFolder(pCfa);
            }
            case LOOP_BOUND: {
                return new BoundUnrollingLoopFolder(pCfa, pConfig);
            }
            case LOOP_BOUND_SAME_CONTEXT: {
                return new BoundUnrollingContextLoopFolder(pCfa, pConfig);
            }
            case LOOP_SAME_CONTEXT: {
                return new ContextLoopFolder(pCfa);
            }
        }
        throw new AssertionError((Object)"Unknown condition folder.");
    }

    protected ConditionFolder(FOLDER_TYPE pType) {
        this.type = pType;
    }

    public abstract ARGState foldARG(ARGState var1);

    public FOLDER_TYPE getType() {
        return this.type;
    }

    protected ARGState getUncoveredChild(ARGState pChild) {
        while (pChild.isCovered()) {
            pChild = pChild.getCoveringState();
        }
        return pChild;
    }

    protected void merge(ARGState newState1, ARGState newState2, MergeUpdateFunction updateFun) {
        HashMap<ARGState, ARGState> mergedInto = new HashMap<ARGState, ARGState>();
        ArrayDeque<Pair<ARGState, ARGState>> toMerge = new ArrayDeque<Pair<ARGState, ARGState>>();
        toMerge.push(Pair.of(newState1, newState2));
        while (!toMerge.isEmpty()) {
            ARGState merge = (ARGState)((Pair)toMerge.peek()).getFirst();
            while (mergedInto.containsKey(merge)) {
                merge = (ARGState)mergedInto.get(merge);
            }
            ARGState mergeInto = (ARGState)((Pair)toMerge.pop()).getSecond();
            while (mergedInto.containsKey(mergeInto)) {
                mergeInto = (ARGState)mergedInto.get(mergeInto);
            }
            if (merge.equals(mergeInto)) continue;
            for (ARGState child : merge.getChildren()) {
                for (ARGState ch : mergeInto.getChildren()) {
                    if (merge.getEdgeToChild(child) == null || !merge.getEdgeToChild(child).equals(mergeInto.getEdgeToChild(ch)) || Objects.equals(ch, child)) continue;
                    toMerge.add(Pair.of(child, ch));
                }
            }
            merge.replaceInARGWith(mergeInto);
            mergedInto.put(merge, mergeInto);
            updateFun.updateAfterMerging(merge, mergeInto);
        }
    }

    private static class ExceptLoopFolder
    extends StructureFolder<Pair<String, CallstackStateEqualsWrapper>> {
        private final LoopInfo loopInfo;

        private ExceptLoopFolder(CFA pCfa) {
            super(pCfa, FOLDER_TYPE.FOLD_EXCEPT_LOOPS);
            this.loopInfo = new LoopInfo(pCfa);
        }

        @Override
        protected Pair<String, CallstackStateEqualsWrapper> getRootFoldId(ARGState pRoot) {
            CFANode rootLoc = AbstractStates.extractLocation(pRoot);
            Object loopPart = ":";
            if (!this.shouldFold(rootLoc)) {
                loopPart = ":|" + pRoot.getStateId();
            }
            return Pair.of(rootLoc + (String)loopPart, new CallstackStateEqualsWrapper(AbstractStates.extractStateByType(pRoot, CallstackState.class)));
        }

        @Override
        protected Pair<String, CallstackStateEqualsWrapper> adaptID(CFAEdge pEdge, Pair<String, CallstackStateEqualsWrapper> pFoldID, ARGState pChild) {
            Object newLoopNesting = pFoldID.getFirstNotNull();
            newLoopNesting = ((String)newLoopNesting).substring(((String)newLoopNesting).indexOf(":"));
            if ((this.loopInfo.leaveLoop(pEdge) || this.loopInfo.startNewLoopIteation(pEdge)) && ((String)newLoopNesting).contains("|")) {
                newLoopNesting = ((String)newLoopNesting).substring(0, ((String)newLoopNesting).lastIndexOf("|"));
            }
            if (this.cfa.getAllLoopHeads().orElseThrow().contains((Object)pEdge.getSuccessor())) {
                newLoopNesting = (String)newLoopNesting + "|" + pChild.getStateId();
            }
            return Pair.of(pEdge.getSuccessor().getNodeNumber() + (String)newLoopNesting, new CallstackStateEqualsWrapper(AbstractStates.extractStateByType(pChild, CallstackState.class)));
        }

        @Override
        protected boolean shouldFold(CFANode pLoc) {
            return !this.loopHeads.contains(pLoc);
        }
    }

    @Options(prefix="residualprogram")
    private static class BoundUnrollingContextLoopFolder
    extends StructureFolder<String> {
        private final LoopInfo loopInfo;
        @Option(secure=true, description="How often may a loop be unrolled before it must be folded", name="unrollBound")
        @IntegerOption(min=2L)
        private int maxUnrolls = 2;

        private BoundUnrollingContextLoopFolder(CFA pCfa, Configuration pConfig) throws InvalidConfigurationException {
            super(pCfa, FOLDER_TYPE.LOOP_BOUND_SAME_CONTEXT);
            pConfig.inject((Object)this);
            this.loopInfo = new LoopInfo(pCfa);
        }

        @Override
        protected String getRootFoldId(ARGState pRoot) {
            CFANode rootLoc = AbstractStates.extractLocation(pRoot);
            if (this.shouldFold(rootLoc)) {
                return "|L" + rootLoc.getNodeNumber() + ":1L";
            }
            return "";
        }

        @Override
        protected String adaptID(CFAEdge pEdge, String pFoldID, ARGState pChild) {
            Object newLoopBoundContextID = pFoldID;
            int prevLoopIt = 0;
            if (this.loopInfo.leaveLoop(pEdge) && ((String)newLoopBoundContextID).contains("|")) {
                newLoopBoundContextID = ((String)newLoopBoundContextID).substring(0, ((String)newLoopBoundContextID).lastIndexOf("|"));
            }
            if (this.loopInfo.startNewLoopIteation(pEdge) && ((String)newLoopBoundContextID).contains("|")) {
                int indexCol = ((String)newLoopBoundContextID).lastIndexOf(":");
                prevLoopIt = Integer.parseInt(((String)newLoopBoundContextID).substring(indexCol + 1, ((String)newLoopBoundContextID).indexOf("L", indexCol)));
                newLoopBoundContextID = ((String)newLoopBoundContextID).substring(0, ((String)newLoopBoundContextID).lastIndexOf("|"));
            }
            if (pEdge instanceof FunctionReturnEdge && ((String)newLoopBoundContextID).contains("/")) {
                newLoopBoundContextID = ((String)newLoopBoundContextID).substring(0, ((String)newLoopBoundContextID).lastIndexOf("/"));
            }
            if (pEdge instanceof FunctionCallEdge) {
                newLoopBoundContextID = (String)newLoopBoundContextID + "/N" + pEdge.getPredecessor().getNodeNumber() + "N";
            }
            if (this.cfa.getAllLoopHeads().orElseThrow().contains((Object)pEdge.getSuccessor())) {
                newLoopBoundContextID = (String)newLoopBoundContextID + "|L" + pEdge.getSuccessor().getNodeNumber() + ":" + Math.min(prevLoopIt + 1, this.maxUnrolls) + "L";
            }
            if (pEdge instanceof AssumeEdge) {
                newLoopBoundContextID = ((AssumeEdge)pEdge).getTruthAssumption() ? (String)newLoopBoundContextID + "1" : (String)newLoopBoundContextID + "0";
            }
            return newLoopBoundContextID;
        }

        @Override
        protected boolean shouldFold(CFANode pLoc) {
            return this.loopHeads.contains(pLoc);
        }
    }

    @Options(prefix="residualprogram")
    private static class BoundUnrollingLoopFolder
    extends StructureFolder<String> {
        private final LoopInfo loopInfo;
        @Option(secure=true, description="How often may a loop be unrolled before it must be folded", name="unrollBound")
        @IntegerOption(min=2L)
        private int maxUnrolls = 2;

        private BoundUnrollingLoopFolder(CFA pCfa, Configuration pConfig) throws InvalidConfigurationException {
            super(pCfa, FOLDER_TYPE.LOOP_BOUND);
            pConfig.inject((Object)this);
            this.loopInfo = new LoopInfo(pCfa);
        }

        @Override
        protected String getRootFoldId(ARGState pRoot) {
            CFANode rootLoc = AbstractStates.extractLocation(pRoot);
            if (this.shouldFold(rootLoc)) {
                return "|" + rootLoc.getNodeNumber() + ":1";
            }
            return "";
        }

        @Override
        protected String adaptID(CFAEdge pEdge, String pFoldID, ARGState pChild) {
            Object newLoopBoundID = pFoldID;
            int prevLoopIt = 0;
            if (this.loopInfo.leaveLoop(pEdge) && ((String)newLoopBoundID).contains("|")) {
                newLoopBoundID = ((String)newLoopBoundID).substring(0, ((String)newLoopBoundID).lastIndexOf("|"));
            }
            if (this.loopInfo.startNewLoopIteation(pEdge) && ((String)newLoopBoundID).contains("|")) {
                prevLoopIt = Integer.parseInt(((String)newLoopBoundID).substring(((String)newLoopBoundID).lastIndexOf(":") + 1));
                newLoopBoundID = ((String)newLoopBoundID).substring(0, ((String)newLoopBoundID).lastIndexOf("|"));
            }
            if (pEdge instanceof FunctionReturnEdge && ((String)newLoopBoundID).contains("/")) {
                newLoopBoundID = ((String)newLoopBoundID).substring(0, ((String)newLoopBoundID).lastIndexOf("/"));
            }
            if (pEdge instanceof FunctionCallEdge) {
                newLoopBoundID = (String)newLoopBoundID + "/N" + pEdge.getPredecessor().getNodeNumber() + "N";
            }
            if (this.cfa.getAllLoopHeads().orElseThrow().contains((Object)pEdge.getSuccessor())) {
                newLoopBoundID = (String)newLoopBoundID + "|" + pEdge.getSuccessor().getNodeNumber() + ":" + Math.min(prevLoopIt + 1, this.maxUnrolls);
            }
            return newLoopBoundID;
        }

        @Override
        protected boolean shouldFold(CFANode pLoc) {
            return this.loopHeads.contains(pLoc);
        }
    }

    private static class ContextLoopFolder
    extends StructureFolder<String> {
        private final LoopInfo loopInfo;

        private ContextLoopFolder(CFA pCfa) {
            super(pCfa, FOLDER_TYPE.LOOP_SAME_CONTEXT);
            this.loopInfo = new LoopInfo(this.cfa);
        }

        private String extendLoopContext(CFAEdge pEdge, String pLoopContext) {
            Object newLoopContext = pLoopContext;
            if (this.loopInfo.leaveLoop(pEdge) && ((String)newLoopContext).contains("|")) {
                newLoopContext = ((String)newLoopContext).substring(0, ((String)newLoopContext).lastIndexOf("|"));
            }
            if (this.loopInfo.startNewLoopIteation(pEdge) && ((String)newLoopContext).contains("|")) {
                newLoopContext = ((String)newLoopContext).substring(0, ((String)newLoopContext).lastIndexOf("|"));
            }
            if (pEdge instanceof FunctionReturnEdge && ((String)newLoopContext).contains("/")) {
                newLoopContext = ((String)newLoopContext).substring(0, ((String)newLoopContext).lastIndexOf("/"));
            }
            if (pEdge instanceof FunctionCallEdge) {
                newLoopContext = (String)newLoopContext + "/N" + pEdge.getPredecessor().getNodeNumber() + "N";
            }
            if (this.cfa.getAllLoopHeads().orElseThrow().contains((Object)pEdge.getSuccessor())) {
                newLoopContext = (String)newLoopContext + "|L" + pEdge.getSuccessor().getNodeNumber() + "L";
            }
            if (pEdge instanceof AssumeEdge) {
                newLoopContext = ((AssumeEdge)pEdge).getTruthAssumption() ? (String)newLoopContext + "1" : (String)newLoopContext + "0";
            }
            return newLoopContext;
        }

        @Override
        protected String getRootFoldId(ARGState pRoot) {
            CFANode rootLoc = AbstractStates.extractLocation(pRoot);
            if (this.shouldFold(rootLoc)) {
                return "|L" + rootLoc.getNodeNumber() + "L";
            }
            return "";
        }

        @Override
        protected String adaptID(CFAEdge pEdge, String pLoopContext, ARGState pChild) {
            return this.extendLoopContext(pEdge, pLoopContext);
        }

        @Override
        protected boolean shouldFold(CFANode pLoc) {
            return this.loopHeads.contains(pLoc);
        }
    }

    private static class LoopAlwaysFolder
    extends StructureFolder<Pair<CFANode, CallstackStateEqualsWrapper>> {
        public LoopAlwaysFolder(CFA pCfa) {
            super(pCfa, FOLDER_TYPE.LOOP_ALWAYS);
        }

        @Override
        protected @Nullable Pair<CFANode, CallstackStateEqualsWrapper> adaptID(CFAEdge pEdge, Pair<CFANode, CallstackStateEqualsWrapper> pFoldID, ARGState child) {
            return this.getID(pEdge.getSuccessor(), child);
        }

        @Override
        protected @Nullable Pair<CFANode, CallstackStateEqualsWrapper> getRootFoldId(ARGState pRoot) {
            return this.getID(AbstractStates.extractLocation(pRoot), pRoot);
        }

        private @Nullable Pair<CFANode, CallstackStateEqualsWrapper> getID(CFANode node, ARGState argNode) {
            if (this.shouldFold(node)) {
                return Pair.of(node, new CallstackStateEqualsWrapper(AbstractStates.extractStateByType(argNode, CallstackState.class)));
            }
            return null;
        }

        @Override
        protected boolean shouldFold(CFANode pLoc) {
            return this.loopHeads.contains(pLoc);
        }
    }

    private static abstract class StructureFolder<T>
    extends ConditionFolder {
        protected final CFA cfa;
        protected final Set<CFANode> loopHeads;

        protected StructureFolder(CFA pCfa, FOLDER_TYPE type) {
            super(type);
            this.cfa = pCfa;
            Preconditions.checkState((boolean)this.cfa.getAllLoopHeads().isPresent());
            this.loopHeads = (Set)this.cfa.getAllLoopHeads().orElseThrow();
        }

        protected abstract T getRootFoldId(ARGState var1);

        protected abstract T adaptID(CFAEdge var1, T var2, ARGState var3);

        protected abstract boolean shouldFold(CFANode var1);

        @Override
        public ARGState foldARG(ARGState pRoot) {
            HashMap<ARGState, ARGState> oldARGToFoldedState = new HashMap<ARGState, ARGState>();
            HashMap newARGToFoldedStates = new HashMap();
            HashMap<Object, ARGState> folderStatesFoldIDToFoldedARGState = new HashMap<Object, ARGState>();
            HashMap foldedARGStateToFoldIDs = new HashMap();
            MergeUpdateFunction update = (merge, mergeInto) -> {
                for (ARGState oldState : (Set)newARGToFoldedStates.remove(merge)) {
                    oldARGToFoldedState.put(oldState, mergeInto);
                    ((Set)newARGToFoldedStates.get(mergeInto)).add(oldState);
                }
                if (foldedARGStateToFoldIDs.containsKey(merge)) {
                    for (Object foldID : (Set)foldedARGStateToFoldIDs.remove(merge)) {
                        folderStatesFoldIDToFoldedARGState.put(foldID, mergeInto);
                        ((Set)foldedARGStateToFoldIDs.get(mergeInto)).add(foldID);
                    }
                }
            };
            ArrayDeque<Pair<ARGState, Object>> waitlist = new ArrayDeque<Pair<ARGState, Object>>();
            ARGState foldedNode = new ARGState(pRoot.getWrappedState(), null);
            oldARGToFoldedState.put(pRoot, foldedNode);
            HashSet<ARGState> foldedStates = new HashSet<ARGState>();
            foldedStates.add(pRoot);
            newARGToFoldedStates.put(foldedNode, foldedStates);
            CFANode loc = AbstractStates.extractLocation(pRoot);
            T id = this.getRootFoldId(pRoot);
            if (this.shouldFold(loc)) {
                folderStatesFoldIDToFoldedARGState.put(id, foldedNode);
                HashSet<T> loopContexts = new HashSet<T>();
                loopContexts.add(id);
                foldedARGStateToFoldIDs.put(foldedNode, loopContexts);
            }
            waitlist.push(Pair.of(pRoot, id));
            while (!waitlist.isEmpty()) {
                ARGState oldState = (ARGState)((Pair)waitlist.peek()).getFirst();
                Object foldID = ((Pair)waitlist.pop()).getSecond();
                loc = AbstractStates.extractLocation(oldState);
                for (ARGState child : oldState.getChildren()) {
                    ARGState newState;
                    CFANode locChild = AbstractStates.extractLocation(child);
                    CFAEdge edge = oldState.getEdgeToChild(child);
                    child = this.getUncoveredChild(child);
                    Object foldIDChild = this.adaptID(edge, foldID, child);
                    if (!oldARGToFoldedState.containsKey(child)) {
                        if (this.shouldFold(locChild) && folderStatesFoldIDToFoldedARGState.containsKey(foldIDChild)) {
                            foldedNode = (ARGState)folderStatesFoldIDToFoldedARGState.get(foldIDChild);
                            assert (Objects.equals(locChild, AbstractStates.extractLocation(foldedNode)));
                        } else {
                            foldedNode = null;
                            newState = (ARGState)oldARGToFoldedState.get(oldState);
                            for (ARGState newARGChild : newState.getChildren()) {
                                if (!edge.equals(newState.getEdgeToChild(newARGChild))) continue;
                                foldedNode = newARGChild;
                                break;
                            }
                            if (foldedNode == null) {
                                foldedNode = new ARGState(child.getWrappedState(), null);
                                foldedStates = new HashSet();
                                newARGToFoldedStates.put(foldedNode, foldedStates);
                            }
                            if (this.shouldFold(locChild)) {
                                folderStatesFoldIDToFoldedARGState.put(foldIDChild, foldedNode);
                                if (!foldedARGStateToFoldIDs.containsKey(foldedNode)) {
                                    foldedARGStateToFoldIDs.put(foldedNode, new HashSet());
                                }
                                ((Set)foldedARGStateToFoldIDs.get(foldedNode)).add(foldIDChild);
                            }
                        }
                        oldARGToFoldedState.put(child, foldedNode);
                        ((Set)newARGToFoldedStates.get(foldedNode)).add(child);
                        waitlist.push(Pair.of(child, foldIDChild));
                    }
                    newState = (ARGState)oldARGToFoldedState.get(oldState);
                    ARGState newChild = null;
                    for (ARGState newARGChild : newState.getChildren()) {
                        if (!edge.equals(newState.getEdgeToChild(newARGChild))) continue;
                        newChild = newARGChild;
                        break;
                    }
                    if (newChild != null && !newChild.equals(oldARGToFoldedState.get(child))) {
                        this.merge(newChild, (ARGState)oldARGToFoldedState.get(child), update);
                    }
                    newChild = (ARGState)oldARGToFoldedState.get(child);
                    newChild.addParent((ARGState)oldARGToFoldedState.get(oldState));
                }
            }
            return (ARGState)oldARGToFoldedState.get(pRoot);
        }
    }

    private static class CFAFolder
    extends ConditionFolder {
        public CFAFolder() {
            super(FOLDER_TYPE.CFA);
        }

        @Override
        public ARGState foldARG(ARGState pARGRoot) {
            HashMap<Pair<LocationState, CallstackStateEqualsWrapper>, ARGState> foldedNodesToNewARGNode = new HashMap<Pair<LocationState, CallstackStateEqualsWrapper>, ARGState>();
            HashSet<ARGState> seen = new HashSet<ARGState>();
            ArrayDeque<Pair<ARGState, Pair<LocationState, CallstackStateEqualsWrapper>>> toProcess = new ArrayDeque<Pair<ARGState, Pair<LocationState, CallstackStateEqualsWrapper>>>();
            Pair foldedNode = Pair.of(AbstractStates.extractStateByType(pARGRoot, LocationState.class), new CallstackStateEqualsWrapper(AbstractStates.extractStateByType(pARGRoot, CallstackState.class)));
            seen.add(pARGRoot);
            toProcess.add(Pair.of(pARGRoot, foldedNode));
            ARGState newRoot = new ARGState(foldedNode.getFirst(), null);
            foldedNodesToNewARGNode.put(foldedNode, newRoot);
            while (!toProcess.isEmpty()) {
                ARGState currentARGState = (ARGState)((Pair)toProcess.peek()).getFirst();
                foldedNode = (Pair)((Pair)toProcess.pop()).getSecond();
                for (ARGState child : currentARGState.getChildren()) {
                    if (!seen.add(child)) continue;
                    Pair<LocationState, CallstackStateEqualsWrapper> foldedChild = Pair.of(AbstractStates.extractStateByType(child, LocationState.class), new CallstackStateEqualsWrapper(AbstractStates.extractStateByType(child, CallstackState.class)));
                    toProcess.add(Pair.of(child, foldedChild));
                    ARGState newChild = (ARGState)foldedNodesToNewARGNode.get(foldedChild);
                    if (newChild == null) {
                        newChild = new ARGState(foldedChild.getFirst(), (ARGState)foldedNodesToNewARGNode.get(foldedNode));
                        foldedNodesToNewARGNode.put(foldedChild, newChild);
                        continue;
                    }
                    if (((ARGState)foldedNodesToNewARGNode.get(foldedNode)).getChildren().contains(newChild)) continue;
                    newChild.addParent((ARGState)foldedNodesToNewARGNode.get(foldedNode));
                }
            }
            return newRoot;
        }
    }

    @Options(prefix="residualprogram")
    private static class FolderOptions {
        @Option(secure=true, description="Define kind of folder to use when combining condition with folding approach in residual program generation")
        private FOLDER_TYPE folderType = FOLDER_TYPE.CFA;

        private FolderOptions() {
        }
    }

    private static class LoopInfo {
        private final CFA cfa;
        private final Map<CFANode, LoopStructure.Loop> loopMap;

        public LoopInfo(CFA pCfa) {
            this.cfa = pCfa;
            this.loopMap = this.buildLoopMap();
        }

        private Map<CFANode, LoopStructure.Loop> buildLoopMap() {
            HashMap loopMapResult = Maps.newHashMapWithExpectedSize((int)this.cfa.getAllNodes().size());
            ArrayDeque<Pair<CFANode, Object>> toVisit = new ArrayDeque<Pair<CFANode, Object>>();
            toVisit.push(Pair.of(this.cfa.getMainFunction(), ImmutableList.of()));
            loopMapResult.put(this.cfa.getMainFunction(), null);
            while (!toVisit.isEmpty()) {
                CFANode node = (CFANode)((Pair)toVisit.peek()).getFirst();
                ArrayList<LoopStructure.Loop> loopStack = (ArrayList<LoopStructure.Loop>)((Pair)toVisit.pop()).getSecond();
                LoopStructure.Loop l = loopStack.isEmpty() ? null : (LoopStructure.Loop)loopStack.get(loopStack.size() - 1);
                for (CFAEdge edge : CFAUtils.allLeavingEdges(node)) {
                    if (loopMapResult.containsKey(edge.getSuccessor())) continue;
                    ArrayList<LoopStructure.Loop> succLoopStack = loopStack;
                    LoopStructure.Loop lsucc = l;
                    if (edge instanceof CFunctionReturnEdge) continue;
                    if (edge instanceof CFunctionCallEdge) {
                        lsucc = null;
                        succLoopStack = ImmutableList.of();
                    }
                    while (lsucc != null && lsucc.getOutgoingEdges().contains((Object)edge)) {
                        succLoopStack = new ArrayList<LoopStructure.Loop>(succLoopStack);
                        succLoopStack.remove(succLoopStack.size() - 1);
                        if (succLoopStack.isEmpty()) {
                            lsucc = null;
                            continue;
                        }
                        lsucc = (LoopStructure.Loop)succLoopStack.get(succLoopStack.size() - 1);
                    }
                    if (this.cfa.getAllLoopHeads().orElseThrow().contains((Object)edge.getSuccessor())) {
                        ImmutableSet<LoopStructure.Loop> loop = this.cfa.getLoopStructure().orElseThrow().getLoopsForLoopHead(edge.getSuccessor());
                        assert (loop.size() >= 1);
                        lsucc = (LoopStructure.Loop)loop.iterator().next();
                        if (succLoopStack == loopStack) {
                            succLoopStack = new ArrayList(succLoopStack);
                        }
                        succLoopStack.add(lsucc);
                    }
                    loopMapResult.put(edge.getSuccessor(), lsucc);
                    toVisit.push(Pair.of(edge.getSuccessor(), succLoopStack));
                }
            }
            return loopMapResult;
        }

        public boolean leaveLoop(CFAEdge pEdge) {
            LoopStructure.Loop l = this.loopMap.get(pEdge.getPredecessor());
            return l != null && !(pEdge instanceof CFunctionCallEdge) && !(pEdge instanceof CFunctionReturnEdge) && l != this.loopMap.get(pEdge.getSuccessor()) && !l.getLoopNodes().contains((Object)pEdge.getSuccessor());
        }

        public boolean startNewLoopIteation(CFAEdge pEdge) {
            return this.cfa.getAllLoopHeads().orElseThrow().contains((Object)pEdge.getSuccessor()) && this.loopMap.get(pEdge.getPredecessor()) == this.loopMap.get(pEdge.getSuccessor());
        }
    }

    private static interface MergeUpdateFunction {
        public void updateAfterMerging(ARGState var1, ARGState var2);
    }

    public static enum FOLDER_TYPE {
        CFA,
        FOLD_EXCEPT_LOOPS,
        LOOP_ALWAYS,
        LOOP_BOUND,
        LOOP_BOUND_SAME_CONTEXT,
        LOOP_SAME_CONTEXT;

    }
}

