/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.residualprogram;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.ResidualProgramConstructionAlgorithm;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="conditional.verifier")
public class ConditionalVerifierAlgorithm
implements Algorithm,
StatisticsProvider {
    @Option(secure=true, description="configuration for the verification of the residual program which is constructed from another verifier's condition")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private @Nullable Path verifierConfig;
    @Option(secure=true, description="configuration of the residual program generator")
    @FileOption(value=FileOption.Type.REQUIRED_INPUT_FILE)
    private @Nullable Path generatorConfig;
    private final LogManager logger;
    private final ShutdownNotifier shutdown;
    private final CFA cfa;
    private final Specification spec;
    private final Configuration globalConfig;
    private final ConditionalVerifierStats stats = new ConditionalVerifierStats();

    public ConditionalVerifierAlgorithm(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Specification pSpecification, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.shutdown = pShutdownNotifier;
        this.spec = pSpecification;
        this.cfa = pCfa;
        this.globalConfig = pConfig;
    }

    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pReachedSet instanceof ForwardingReachedSet));
        Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        try {
            Path residProg = Files.createTempFile("residualProg", ".c", new FileAttribute[0]);
            CFANode entryFunction = AbstractStates.extractLocation(pReachedSet.getFirstState());
            if (!this.generateResidualProgram(entryFunction, residProg.toString())) {
                return status.withSound(false);
            }
            this.shutdown.shutdownIfNecessary();
            status = status.update(this.verifyResidualProgram(entryFunction.getFunctionName(), residProg.toString(), (ForwardingReachedSet)pReachedSet));
        }
        catch (IOException e) {
            this.logger.logException(Level.SEVERE, (Throwable)e, "Failed to create temporary file for residual program");
            return status.withSound(false);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateResidualProgram(CFANode pEntryNode, String residualProg) throws InterruptedException, CPAException {
        this.stats.residGen.start();
        try {
            this.logger.log(Level.INFO, new Object[]{"Start constructing residual program"});
            this.logger.log(Level.FINE, new Object[]{"Build configuration for residual program generation"});
            ConfigurationBuilder configBuild = Configuration.builder();
            try {
                configBuild.copyFrom(this.globalConfig).clearOption("analysis.asConditionalVerifier").clearOption("conditional.verifier.verifierConfig").clearOption("conditional.verifier.generatorConfig").loadFromFile(this.generatorConfig).copyOptionFromIfPresent(this.globalConfig, "AssumptionGuidingAutomaton.cpa.automaton.inputFile").copyOptionFromIfPresent(this.globalConfig, "AssumptionAutomaton.cpa.automaton.inputFile").setOption("residualprogram.file", residualProg);
                Configuration config = configBuild.build();
                this.shutdown.shutdownIfNecessary();
                CoreComponentsFactory coreComponents = new CoreComponentsFactory(config, this.logger, this.shutdown, AggregatedReachedSets.empty());
                this.logger.log(Level.FINE, new Object[]{"Build configurable program analysis"});
                ConfigurableProgramAnalysis cpa = coreComponents.createCPA(this.cfa, this.spec);
                this.shutdown.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Instantiate residual program construction algorithm"});
                ResidualProgramConstructionAlgorithm algorithm = new ResidualProgramConstructionAlgorithm(this.cfa, config, this.logger, this.shutdown, this.spec, cpa, CPAAlgorithm.create(cpa, this.logger, config, this.shutdown));
                this.shutdown.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Create reached set"});
                AbstractState initialState = cpa.getInitialState(pEntryNode, StateSpacePartition.getDefaultPartition());
                Precision initialPrecision = cpa.getInitialPrecision(pEntryNode, StateSpacePartition.getDefaultPartition());
                ReachedSet reachedSet = coreComponents.createReachedSet(cpa);
                reachedSet.add(initialState, initialPrecision);
                this.shutdown.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Run algorithm for residual program construction"});
                Algorithm.AlgorithmStatus status = algorithm.run(reachedSet);
                this.collectStatistics(algorithm);
                Preconditions.checkState((!status.wasPropertyChecked() ? 1 : 0) != 0);
                if (reachedSet.hasWaitingState()) {
                    this.logger.log(Level.SEVERE, new Object[]{"Residual program construction failed."});
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException | InvalidConfigurationException e) {
                this.logger.logException(Level.SEVERE, e, "Residual program construction failed");
                boolean bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Finished construction of residual program"});
            boolean bl = true;
            return bl;
        }
        finally {
            this.stats.residGen.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Algorithm.AlgorithmStatus verifyResidualProgram(String pEntryFunctionName, String pResidProgPath, ForwardingReachedSet reached) throws InterruptedException, CPAException {
        this.stats.residVerif.start();
        try {
            this.logger.log(Level.INFO, new Object[]{"Start verification of residual program"});
            this.logger.log(Level.FINE, new Object[]{"Build configuration for verification"});
            ConfigurationBuilder configBuild = Configuration.builder();
            try {
                configBuild.copyFrom(this.globalConfig).clearOption("analysis.asConditionalVerifier").clearOption("conditional.verifier.verifierConfig").clearOption("conditional.verifier.generatorConfig").loadFromFile(this.verifierConfig).setOption("analysis.entryFunction", pEntryFunctionName);
                Configuration config = configBuild.build();
                this.shutdown.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Parse constructed residual program"});
                this.stats.residParse.start();
                CFA cfaResidProg = new CFACreator(config, this.logger, this.shutdown).parseFileAndCreateCFA(Collections.singletonList(pResidProgPath));
                this.stats.residParse.stop();
                this.stats.numResidLoc = cfaResidProg.getAllNodes().size();
                this.shutdown.shutdownIfNecessary();
                CoreComponentsFactory coreComponents = new CoreComponentsFactory(config, this.logger, this.shutdown, AggregatedReachedSets.empty());
                this.logger.log(Level.FINE, new Object[]{"Build configurable program analysis"});
                ConfigurableProgramAnalysis cpa = coreComponents.createCPA(cfaResidProg, this.spec);
                this.collectStatistics(cpa);
                this.shutdown.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Get verification algorithm"});
                Algorithm algorithm = coreComponents.createAlgorithm(cpa, cfaResidProg, this.spec);
                this.shutdown.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Create reached set"});
                AbstractState initialState = cpa.getInitialState(cfaResidProg.getMainFunction(), StateSpacePartition.getDefaultPartition());
                Precision initialPrecision = cpa.getInitialPrecision(cfaResidProg.getMainFunction(), StateSpacePartition.getDefaultPartition());
                ReachedSet reachedSet = coreComponents.createReachedSet(cpa);
                reachedSet.add(initialState, initialPrecision);
                reached.setDelegate(reachedSet);
                this.shutdown.shutdownIfNecessary();
                this.logger.log(Level.FINE, new Object[]{"Run verification algorithm"});
                Algorithm.AlgorithmStatus status = Algorithm.AlgorithmStatus.UNSOUND_AND_IMPRECISE;
                try {
                    this.stats.residAnalysis.start();
                    status = algorithm.run(reachedSet);
                }
                finally {
                    this.stats.residAnalysis.stop();
                }
                this.collectStatistics(algorithm);
                this.logger.log(Level.INFO, new Object[]{"Finished verification of residual program"});
                Algorithm.AlgorithmStatus algorithmStatus = status;
                return algorithmStatus;
            }
            catch (IOException | InvalidConfigurationException | ParserException e) {
                this.logger.logException(Level.SEVERE, e, "Verification of residual program failed");
                Algorithm.AlgorithmStatus algorithmStatus = Algorithm.AlgorithmStatus.UNSOUND_AND_PRECISE;
                this.stats.residParse.stopIfRunning();
                this.stats.residVerif.stop();
                return algorithmStatus;
            }
        }
        finally {
            this.stats.residParse.stopIfRunning();
            this.stats.residVerif.stop();
        }
    }

    private void collectStatistics(Object pStatisticsProviderCandidate) {
        if (pStatisticsProviderCandidate instanceof StatisticsProvider) {
            ((StatisticsProvider)pStatisticsProviderCandidate).collectStatistics(this.stats.substats);
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private class ConditionalVerifierStats
    implements Statistics {
        private final Collection<Statistics> substats = new ArrayList<Statistics>();
        private final Timer residGen = new Timer();
        private final Timer residVerif = new Timer();
        private final Timer residParse = new Timer();
        private final Timer residAnalysis = new Timer();
        private int numResidLoc;

        private ConditionalVerifierStats() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            StatisticsWriter statWriter = StatisticsWriter.writingStatisticsTo(pOut);
            statWriter.put("Time for residual program construction", this.residGen);
            statWriter.put("Time for residual program verification", this.residVerif);
            statWriter.put("Time for residual program parsing", this.residParse);
            statWriter.put("Time for residual program analysis", this.residAnalysis);
            statWriter.put("Size of original program", ConditionalVerifierAlgorithm.this.cfa.getAllNodes().size());
            statWriter.put("Size of residual program", this.numResidLoc);
            statWriter.spacer();
            for (Statistics substat : this.substats) {
                substat.printStatistics(pOut, pResult, pReached);
                substat.writeOutputFiles(pResult, pReached);
            }
        }

        @Override
        public @Nullable String getName() {
            return "Conditional Verifier Statistics";
        }
    }
}

