/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.residualprogram;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.IGoalFindingStrategy;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.TestGoalToConditionConverterAlgorithm;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class LeafGoalStrategy
implements IGoalFindingStrategy {
    @Override
    public Map<TestGoalToConditionConverterAlgorithm.LeafStates, List<CFANode>> findGoals(Deque<ARGState> pWaitlist, Set<String> coveredGoals) {
        HashSet<ARGState> reachedNodes = new HashSet<ARGState>();
        HashMap<TestGoalToConditionConverterAlgorithm.LeafStates, List<CFANode>> leafGoals = new HashMap<TestGoalToConditionConverterAlgorithm.LeafStates, List<CFANode>>();
        leafGoals.put(TestGoalToConditionConverterAlgorithm.LeafStates.COVERED, new ArrayList());
        leafGoals.put(TestGoalToConditionConverterAlgorithm.LeafStates.UNCOVERED, new ArrayList());
        while (!pWaitlist.isEmpty()) {
            CFALabelNode lbl;
            ARGState argState = pWaitlist.removeFirst();
            reachedNodes.add(argState);
            LocationState state = AbstractStates.extractStateByType(argState, LocationState.class);
            if (state == null) continue;
            CFANode label = state.getLocationNode();
            if (label instanceof CFALabelNode && (lbl = (CFALabelNode)label).getLabel().matches("^GOAL_[0-9]+$")) {
                if (coveredGoals.contains(lbl.getLabel())) {
                    ((List)leafGoals.get((Object)TestGoalToConditionConverterAlgorithm.LeafStates.COVERED)).add(label);
                    continue;
                }
                ((List)leafGoals.get((Object)TestGoalToConditionConverterAlgorithm.LeafStates.UNCOVERED)).add(label);
                continue;
            }
            for (ARGState it : argState.getChildren()) {
                if (reachedNodes.contains(it)) continue;
                pWaitlist.add(it);
            }
        }
        return leafGoals;
    }
}

