/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.residualprogram;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.IGoalFindingStrategy;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.TestGoalToConditionConverterAlgorithm;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class LeafGoalWithPropagationStrategy
implements IGoalFindingStrategy {
    @Override
    public Map<TestGoalToConditionConverterAlgorithm.LeafStates, List<CFANode>> findGoals(Deque<ARGState> pWaitlist, Set<String> coveredGoals) {
        ArrayDeque waitList = pWaitlist.stream().map(AbstractStates::extractLocation).collect(Collectors.toCollection(ArrayDeque::new));
        HashSet<CFANode> reachedNodes = new HashSet<CFANode>();
        HashMap nodes = new HashMap();
        nodes.put(NodeStates.VIRGIN, new HashSet());
        nodes.put(NodeStates.UNCOVERED, new HashSet());
        nodes.put(NodeStates.COVERED, new HashSet());
        HashSet removableNodes = new HashSet();
        while (!waitList.isEmpty()) {
            CFANode node = (CFANode)waitList.removeFirst();
            reachedNodes.add(node);
            ImmutableList childrenNodes = CFAUtils.successorsOf(node).toList();
            if (((HashSet)nodes.get((Object)NodeStates.VIRGIN)).containsAll((Collection<?>)childrenNodes) && node instanceof CFALabelNode && ((CFALabelNode)node).getLabel().matches("^GOAL_[0-9]+$")) {
                if (coveredGoals.contains(((CFALabelNode)node).getLabel())) {
                    ((HashSet)nodes.get((Object)NodeStates.COVERED)).add(node);
                } else {
                    ((HashSet)nodes.get((Object)NodeStates.UNCOVERED)).add(node);
                }
            } else if (childrenNodes.isEmpty() || ((HashSet)nodes.get((Object)NodeStates.VIRGIN)).containsAll((Collection<?>)childrenNodes)) {
                ((HashSet)nodes.get((Object)NodeStates.VIRGIN)).add(node);
            } else if (((HashSet)nodes.get((Object)NodeStates.COVERED)).containsAll((Collection<?>)childrenNodes)) {
                ((HashSet)nodes.get((Object)NodeStates.COVERED)).add(node);
            } else {
                if (!((HashSet)nodes.get((Object)NodeStates.UNCOVERED)).containsAll((Collection<?>)childrenNodes)) continue;
                ((HashSet)nodes.get((Object)NodeStates.UNCOVERED)).add(node);
            }
            removableNodes.addAll(childrenNodes);
            ImmutableList todoNodes = CFAUtils.predecessorsOf(node).filter(n -> !reachedNodes.contains(n) && !waitList.contains(n)).toList();
            waitList.addAll(todoNodes);
        }
        ((HashSet)nodes.get((Object)NodeStates.COVERED)).removeAll(removableNodes);
        ((HashSet)nodes.get((Object)NodeStates.UNCOVERED)).removeAll(removableNodes);
        HashMap<TestGoalToConditionConverterAlgorithm.LeafStates, List<CFANode>> leafGoals = new HashMap<TestGoalToConditionConverterAlgorithm.LeafStates, List<CFANode>>();
        leafGoals.put(TestGoalToConditionConverterAlgorithm.LeafStates.COVERED, new ArrayList((Collection)nodes.get((Object)NodeStates.COVERED)));
        leafGoals.put(TestGoalToConditionConverterAlgorithm.LeafStates.UNCOVERED, new ArrayList((Collection)nodes.get((Object)NodeStates.UNCOVERED)));
        return leafGoals;
    }

    private static enum NodeStates {
        VIRGIN,
        UNCOVERED,
        COVERED,
        BOTH;

    }
}

