/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.core.algorithm.residualprogram;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CoreComponentsFactory;
import org.sosy_lab.cpachecker.core.algorithm.Algorithm;
import org.sosy_lab.cpachecker.core.algorithm.AssumptionCollectorAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.residualprogram.ResidualProgramConstructionAlgorithm;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.AggregatedReachedSets;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackCPA;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackStateEqualsWrapper;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.InfeasibleCounterexampleException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

public class ResidualProgramConstructionAfterAnalysisAlgorithm
extends ResidualProgramConstructionAlgorithm
implements StatisticsProvider {
    private final CFA cfa;
    private final Algorithm innerAlgorithm;
    private final Collection<Statistics> stats = new ArrayList<Statistics>();

    private static boolean isStop(AbstractState e) {
        AssumptionStorageState ass = AbstractStates.extractStateByType(e, AssumptionStorageState.class);
        return ass != null && ass.isStop();
    }

    public ResidualProgramConstructionAfterAnalysisAlgorithm(CFA pCfa, Algorithm pAlgorithm, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdown, Specification pSpec) throws InvalidConfigurationException {
        super(pCfa, pConfig, pLogger, pShutdown, pSpec);
        this.cfa = pCfa;
        this.innerAlgorithm = pAlgorithm;
        if (this.innerAlgorithm instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.innerAlgorithm)).collectStatistics(this.stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Algorithm.AlgorithmStatus run(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Preconditions.checkArgument((boolean)(pReachedSet.getFirstState() instanceof ARGState), (Object)"Top most abstract state must be an ARG state");
        Preconditions.checkArgument((boolean)(AbstractStates.extractLocation(pReachedSet.getFirstState()) != null), (Object)"Require location information to build residual program");
        status = Algorithm.AlgorithmStatus.SOUND_AND_PRECISE;
        try {
            this.logger.log(Level.INFO, new Object[]{"Start analysis"});
            status = status.update(this.innerAlgorithm.run(pReachedSet));
        }
        catch (InfeasibleCounterexampleException | RefinementFailedException var3_3) {
            // empty catch block
        }
        if (!pReachedSet.hasWaitingState() && !FluentIterable.from((Iterable)pReachedSet).anyMatch((Predicate)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isStop(org.sosy_lab.cpachecker.core.interfaces.AbstractState ), (Lorg/sosy_lab/cpachecker/core/interfaces/AbstractState;)Z)())) {
            this.logger.log(Level.INFO, new Object[]{"Analysis complete"});
            return status;
        }
        this.logger.log(Level.INFO, new Object[]{"Analysis incomplete, some states could not be explored. Generate residual program."});
        argRoot = (ARGState)pReachedSet.getFirstState();
        mainFunction = AbstractStates.extractLocation(argRoot);
        if (!ResidualProgramConstructionAfterAnalysisAlgorithm.$assertionsDisabled && mainFunction == null) {
            throw new AssertionError();
        }
        assumptionAutomaton = null;
        if (this.usesParallelCompositionOfProgramAndCondition()) {
            try {
                assumptionAutomaton = TempFile.builder().prefix("assumptions").suffix("txt").create();
                automatonWriter = IO.openOutputFile((Path)assumptionAutomaton, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);
                try {
                    AssumptionCollectorAlgorithm.writeAutomaton(automatonWriter, argRoot, this.computeRelevantStates(pReachedSet), (Set<AbstractState>)ImmutableSet.copyOf(pReachedSet.getWaitlist()), 0, true, true);
                }
                finally {
                    if (automatonWriter != null) {
                        automatonWriter.close();
                    }
                }
            }
            catch (IOException e1) {
                throw new CPAException("Could not generate assumption automaton needed to generate residual program", e1);
            }
        }
        if ((result = this.prepareARGToConstructResidualProgram(mainFunction, assumptionAutomaton)) == null || result.getFirst() == null) {
            throw new CPAException("Failed to build structure of residual program");
        }
        argRoot = result.getFirst();
        try {
            this.statistic.collectPragmaPointsTimer.stop();
            switch (1.$SwitchMap$org$sosy_lab$cpachecker$core$algorithm$residualprogram$ResidualProgramConstructionAlgorithm$ResidualGenStrategy[this.getStrategy().ordinal()]) {
                case 1: {
                    addPragma = this.getAllTargetStates(result.getSecond());
                    ** break;
lbl43:
                    // 1 sources

                    break;
                }
                case 2: {
                    addPragma = this.getAllTargetStatesNotFullyExplored(pReachedSet, result.getSecond());
                    ** break;
lbl47:
                    // 1 sources

                    break;
                }
                default: {
                    addPragma = null;
                    break;
                }
            }
        }
        finally {
            this.statistic.collectPragmaPointsTimer.stop();
        }
        if (!this.writeResidualProgram(argRoot, addPragma)) {
            throw new CPAException("Failed to write residual program.");
        }
        return status;
    }

    private Set<ARGState> computeRelevantStates(ReachedSet pReachedSet) {
        TreeSet<ARGState> uncoveredAncestors = new TreeSet<ARGState>();
        ArrayDeque<ARGState> toAdd = new ArrayDeque<ARGState>();
        for (AbstractState unexplored : pReachedSet.getWaitlist()) {
            toAdd.push((ARGState)unexplored);
        }
        for (AbstractState stop : FluentIterable.from((Iterable)pReachedSet).filter(ResidualProgramConstructionAfterAnalysisAlgorithm::isStop)) {
            toAdd.push((ARGState)stop);
        }
        while (!toAdd.isEmpty()) {
            ARGState current = (ARGState)toAdd.pop();
            assert (!current.isCovered());
            if (!uncoveredAncestors.add(current)) continue;
            toAdd.addAll(current.getParents());
            for (ARGState coveredByCurrent : current.getCoveredByThis()) {
                toAdd.addAll(coveredByCurrent.getParents());
            }
        }
        return uncoveredAncestors;
    }

    private Set<ARGState> getAllTargetStatesNotFullyExplored(ReachedSet pIncompleteExploration, ReachedSet pNodesOfInlinedProg) throws CPAException, InterruptedException {
        if (AbstractStates.extractStateByType(pIncompleteExploration.getFirstState(), CallstackState.class) == null) {
            return this.getAllTargetStatesNotFullyExploredBasedOnLocations(pIncompleteExploration.getWaitlist(), pNodesOfInlinedProg);
        }
        return this.getAllTargetStatesNotFullyExploredFunctionsInlined(pIncompleteExploration.getWaitlist(), pNodesOfInlinedProg);
    }

    private Set<ARGState> getAllTargetStatesNotFullyExploredBasedOnLocations(Collection<AbstractState> pUnexploredStates, ReachedSet pNodesOfInlinedProg) throws InterruptedException {
        CFANode current;
        HashSet seen = Sets.newHashSetWithExpectedSize((int)this.cfa.getAllNodes().size());
        ArrayDeque<CFANode> toProcess = new ArrayDeque<CFANode>();
        for (AbstractState state2 : pUnexploredStates) {
            current = AbstractStates.extractLocation(state2);
            Preconditions.checkNotNull((Object)current);
            if (!seen.add(current)) continue;
            toProcess.add(current);
        }
        while (!toProcess.isEmpty()) {
            this.shutdown.shutdownIfNecessary();
            current = (CFANode)toProcess.pop();
            for (CFAEdge leaving : CFAUtils.leavingEdges(current)) {
                if (!seen.add(leaving.getSuccessor())) continue;
                toProcess.push(leaving.getSuccessor());
            }
        }
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)pNodesOfInlinedProg, ARGState.class), state -> state.isTarget() && seen.contains(AbstractStates.extractLocation(state))));
    }

    private Set<ARGState> getAllTargetStatesNotFullyExploredFunctionsInlined(Collection<AbstractState> pUnexploredStates, ReachedSet pNodesOfInlinedProg) throws CPAException, InterruptedException {
        CallstackCPA callstackCpa;
        Pair current;
        HashMultimap seen = HashMultimap.create((int)this.cfa.getAllNodes().size(), (int)this.cfa.getNumberOfFunctions());
        ArrayDeque<Pair<CFANode, CallstackState>> toProcess = new ArrayDeque<Pair<CFANode, CallstackState>>();
        for (AbstractState state : pUnexploredStates) {
            current = Pair.of(AbstractStates.extractLocation(state), AbstractStates.extractStateByType(state, CallstackState.class));
            if (!seen.put((Object)current.getFirst(), (Object)new CallstackStateEqualsWrapper(current.getSecond()))) continue;
            toProcess.add(current);
        }
        try {
            callstackCpa = new CallstackCPA(Configuration.defaultConfiguration(), this.logger);
        }
        catch (InvalidConfigurationException e) {
            this.logger.log(Level.INFO, new Object[]{"Cannot use inlined representation to detect unexplored target states. ", "Use fall-back solution (less precise) and only consider locations."});
            return this.getAllTargetStatesNotFullyExploredBasedOnLocations(pUnexploredStates, pNodesOfInlinedProg);
        }
        CallstackTransferRelation csTr = callstackCpa.getTransferRelation();
        while (!toProcess.isEmpty()) {
            this.shutdown.shutdownIfNecessary();
            current = (Pair)toProcess.pop();
            for (CFAEdge leaving : CFAUtils.leavingEdges((CFANode)current.getFirst())) {
                Pair<CFANode, CallstackState> explored;
                Collection<? extends AbstractState> csSucc = csTr.getAbstractSuccessorsForEdge((AbstractState)current.getSecond(), SingletonPrecision.getInstance(), leaving);
                if (csSucc.isEmpty() || !seen.put((Object)(explored = Pair.of(leaving.getSuccessor(), (CallstackState)csSucc.iterator().next())).getFirst(), (Object)new CallstackStateEqualsWrapper(explored.getSecond()))) continue;
                toProcess.add(explored);
            }
        }
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)pNodesOfInlinedProg, ARGState.class), arg_0 -> ResidualProgramConstructionAfterAnalysisAlgorithm.lambda$getAllTargetStatesNotFullyExploredFunctionsInlined$1((Multimap)seen, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable Pair<ARGState, ReachedSet> prepareARGToConstructResidualProgram(CFANode mainFunction, @Nullable Path assumptionAutomaton) {
        try {
            ConfigurationBuilder configBuilder = Configuration.builder();
            configBuilder.setOption("cpa", "cpa.arg.ARGCPA");
            configBuilder.setOption("ARGCPA.cpa", "cpa.composite.CompositeCPA");
            configBuilder.setOption("CompositeCPA.cpas", "cpa.location.LocationCPA,cpa.callstack.CallstackCPA");
            configBuilder.setOption("cpa.automaton.breakOnTargetState", "-1");
            Configuration config = configBuilder.build();
            CoreComponentsFactory coreComponents = new CoreComponentsFactory(config, this.logger, this.shutdown, AggregatedReachedSets.empty());
            Specification spec = this.getSpecification();
            if (this.usesParallelCompositionOfProgramAndCondition()) {
                assert (assumptionAutomaton != null);
                spec = spec.withAdditionalSpecificationFile((Set<Path>)ImmutableSet.of((Object)this.getAssumptionGuider(), (Object)assumptionAutomaton), this.cfa, config, this.logger, this.shutdown);
            }
            ConfigurableProgramAnalysis cpa = coreComponents.createCPA(this.cfa, spec);
            ReachedSet reached = coreComponents.createReachedSet(cpa);
            reached.add(cpa.getInitialState(mainFunction, StateSpacePartition.getDefaultPartition()), cpa.getInitialPrecision(mainFunction, StateSpacePartition.getDefaultPartition()));
            CPAAlgorithm algo = CPAAlgorithm.create(cpa, this.logger, config, this.shutdown);
            try {
                this.statistic.modelBuildTimer.start();
                algo.run(reached);
            }
            finally {
                this.statistic.modelBuildTimer.stop();
            }
            if (reached.hasWaitingState()) {
                this.logger.log(Level.SEVERE, new Object[]{"Analysis run to get structure of residual program is incomplete"});
                return null;
            }
            return Pair.of((ARGState)reached.getFirstState(), reached);
        }
        catch (IllegalArgumentException | InterruptedException | InvalidConfigurationException | CPAException e1) {
            this.logger.log(Level.SEVERE, new Object[]{"Analysis to build structure of residual program failed", e1});
            return null;
        }
    }

    @Override
    protected void checkConfiguration() throws InvalidConfigurationException {
        if (this.usesParallelCompositionOfProgramAndCondition() && this.getAssumptionGuider() == null) {
            throw new InvalidConfigurationException("For current strategy " + this.getStrategy() + ", the control automaton guiding the exploration based on the condition is needed. Please set the option residualprogram.assumptionGuider.");
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.addAll(this.stats);
    }

    private static /* synthetic */ boolean lambda$getAllTargetStatesNotFullyExploredFunctionsInlined$1(Multimap seen, ARGState state) {
        return seen.get((Object)AbstractStates.extractLocation(state)).contains(new CallstackStateEqualsWrapper(AbstractStates.extractStateByType(state, CallstackState.class)));
    }
}

